/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.openapi.v2;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.openapi.common.constant.DataType;
import kd.isc.iscb.platform.core.api.openapi.v2.IscApiUtil;
import kd.isc.iscb.platform.core.api.openapi.v2.OpenApiField;
import kd.isc.iscb.platform.core.api.openapi.v2.OpenApiVersion2Builder;
import kd.isc.iscb.platform.core.apic.IscApiParam;
import kd.isc.iscb.util.dt.D;

public class OpenApiFormIscMServiceApi
extends OpenApiVersion2Builder {
    @Override
    protected DynamicObjectCollection makeBodyEntries(DynamicObject svc, DynamicObject api) {
        DynamicObjectCollection inputEntries = svc.getDynamicObjectCollection("bodyentryentity");
        inputEntries.clear();
        IscApiParam inputSchema = OpenApiFormIscMServiceApi.getInputSchema(api);
        this.addInput(0L, inputEntries, inputSchema, 0);
        return inputEntries;
    }

    public static IscApiParam getInputSchema(DynamicObject api) {
        DynamicObjectCollection inputs = api.getDynamicObjectCollection("inputs");
        ArrayList<IscApiParam.Field> fields = new ArrayList<IscApiParam.Field>(inputs.size());
        for (DynamicObject input : inputs) {
            String name = input.getString("input_field");
            String dataType = input.getString("input_data_type");
            String title = input.getString("input_description");
            boolean isArray = OpenApiFormIscMServiceApi.isArray(dataType);
            fields.add(new IscApiParam.Field(name, dataType, title, isArray, false, null));
        }
        return new IscApiParam(fields);
    }

    private static boolean isArray(String dataType) {
        return "ENTRIES".equals(dataType) || "ARRAY".equals(dataType);
    }

    private void addInput(long parentId, DynamicObjectCollection inputEntries, IscApiParam inputSchema, int level) {
        if (inputSchema != null) {
            List<IscApiParam.Field> fields = inputSchema.getFields();
            for (IscApiParam.Field field : fields) {
                DynamicObject inputEntry = inputEntries.addNew();
                long id = IscApiUtil.getId();
                inputEntry.set("id", (Object)id);
                inputEntry.set("paramname", (Object)field.getName());
                inputEntry.set("bodyparamdes", (Object)field.getTitle());
                DataType openApiFieldType = OpenApiField.structTypeToOpenApiType(field.getDataType());
                Object object = openApiFieldType.defaultValue();
                inputEntry.set("example", (Object)("-".equals(object) ? "-" : JSON.toJSONString((Object)object)));
                inputEntry.set("paramtype", (Object)openApiFieldType.type());
                inputEntry.set("is_req_mul_value", (Object)field.isArray());
                inputEntry.set("must", (Object)(field.isRequired() ? "1" : "0"));
                inputEntry.set("pid", (Object)parentId);
                inputEntry.set("body_level", (Object)D.s((Object)level));
                this.addInput(id, inputEntries, field.getSchema(), level + 1);
            }
        }
    }

    @Override
    protected DynamicObjectCollection makeRespEntries(DynamicObject svc, DynamicObject api) {
        DynamicObjectCollection outputEntries = svc.getDynamicObjectCollection("respentryentity");
        outputEntries.clear();
        IscApiParam outputSchema = OpenApiFormIscMServiceApi.getOutputSchema(api);
        this.addOutput(0L, outputEntries, outputSchema, 1);
        return outputEntries;
    }

    public static IscApiParam getOutputSchema(DynamicObject api) {
        DynamicObjectCollection outputs = api.getDynamicObjectCollection("outputs");
        ArrayList<IscApiParam.Field> fields = new ArrayList<IscApiParam.Field>(outputs.size());
        for (DynamicObject output : outputs) {
            String name = output.getString("output_field");
            String dataType = output.getString("output_data_type");
            String title = output.getString("output_description");
            boolean isArray = OpenApiFormIscMServiceApi.isArray(dataType);
            fields.add(new IscApiParam.Field(name, dataType, title, isArray, false, null));
        }
        return new IscApiParam(fields);
    }

    private void addOutput(long parentId, DynamicObjectCollection outputEntries, IscApiParam outputSchema, int level) {
        if (outputSchema != null) {
            List<IscApiParam.Field> fields = outputSchema.getFields();
            for (IscApiParam.Field field : fields) {
                DynamicObject outputEntry = outputEntries.addNew();
                long id = IscApiUtil.getId();
                outputEntry.set("id", (Object)id);
                outputEntry.set("respparamname", (Object)field.getName());
                outputEntry.set("respdes", (Object)field.getTitle());
                DataType openApiType = OpenApiField.structTypeToOpenApiType(field.getDataType());
                Object object = openApiType.defaultValue();
                outputEntry.set("respparamtype", (Object)openApiType.type());
                outputEntry.set("respexample", (Object)("-".equals(object) ? "-" : JSON.toJSONString((Object)object)));
                outputEntry.set("is_resp_mul_value", (Object)field.isArray());
                outputEntry.set("pid", (Object)parentId);
                outputEntry.set("resp_level", (Object)D.s((Object)level));
                this.addOutput(id, outputEntries, field.getSchema(), level + 1);
            }
        }
    }
}

