/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.openapi.v2;

import com.alibaba.fastjson.JSON;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.IDService;
import kd.isc.iscb.platform.core.api.openapi.v2.IscApiUtil;
import kd.isc.iscb.platform.core.api.openapi.v2.OpenApiField;
import kd.isc.iscb.platform.core.api.openapi.v2.OpenApiVersion2Builder;
import kd.isc.iscb.platform.core.api.webapi.Param;
import kd.isc.iscb.platform.core.api.webapi.WebReqBody;
import kd.isc.iscb.platform.core.api.webapi.WebReqHeader;
import kd.isc.iscb.platform.core.api.webapi.WebRespBody;
import kd.isc.iscb.platform.core.api.webapi.WebUrlParam;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class OpenApiFromIscWebApi
extends OpenApiVersion2Builder {
    @Override
    protected DynamicObjectCollection makeBodyEntries(DynamicObject svc, DynamicObject api) {
        DynamicObjectCollection web_req_body;
        LinkedHashMap<String, Param> bodyToParam;
        Map<String, Param> newBodyToParam;
        DynamicObjectCollection web_req_header;
        LinkedHashMap<String, Param> headNameToParam;
        Map<String, Param> newHeadNameToParam;
        DynamicObjectCollection inputEntries = svc.getDynamicObjectCollection("bodyentryentity");
        inputEntries.clear();
        DynamicObjectCollection web_url_params = api.getDynamicObjectCollection("web_url_params");
        LinkedHashMap<String, Param> urlNameToParam = new LinkedHashMap<String, Param>(new WebUrlParam(web_url_params).getNameToParam());
        Map<String, Param> newParam = this.getNewParam(urlNameToParam);
        if (!newParam.isEmpty()) {
            long urlParamId = IDService.get().genLongId();
            OpenApiField urlParam = new OpenApiField("queryParam", "STRUCT");
            IscApiUtil.addInputField(inputEntries, 0L, urlParamId, 1, urlParam);
            this.addInputBodyField(inputEntries, newParam, urlParamId, 2);
        }
        if (!(newHeadNameToParam = this.getNewParam(headNameToParam = new LinkedHashMap<String, Param>(new WebReqHeader(web_req_header = api.getDynamicObjectCollection("web_req_header")).getNameToParam()))).isEmpty()) {
            long headId = IDService.get().genLongId();
            OpenApiField header = new OpenApiField("head", "STRUCT");
            IscApiUtil.addInputField(inputEntries, 0L, headId, 1, header);
            this.addInputBodyField(inputEntries, newHeadNameToParam, headId, 2);
        }
        if (!(newBodyToParam = this.getNewParam(bodyToParam = new LinkedHashMap<String, Param>(new WebReqBody(web_req_body = api.getDynamicObjectCollection("web_req_body")).getNameToParam()))).isEmpty()) {
            long bodyId = IDService.get().genLongId();
            OpenApiField headers = new OpenApiField("body", "STRUCT");
            IscApiUtil.addInputField(inputEntries, 0L, bodyId, 1, headers);
            this.addInputBodyField(inputEntries, newBodyToParam, bodyId, 2);
        }
        return inputEntries;
    }

    public Map<String, Param> getNewParam(Map<String, Param> nameToParam) {
        LinkedHashMap<String, Param> newParam = new LinkedHashMap<String, Param>();
        for (Map.Entry<String, Param> entry : nameToParam.entrySet()) {
            if (!StringUtil.isEmpty((String)entry.getValue().getParamValue())) continue;
            newParam.put(entry.getKey(), entry.getValue());
        }
        return newParam;
    }

    private void addInputBodyField(DynamicObjectCollection inputEntries, Map<String, Param> nameToParam, long parentId, int level) {
        for (Map.Entry<String, Param> paramEntry : nameToParam.entrySet()) {
            Param param = paramEntry.getValue();
            DynamicObject inputEntry = inputEntries.addNew();
            long paramID = IDService.get().genLongId();
            inputEntry.set("id", (Object)paramID);
            inputEntry.set("paramname", (Object)param.getName());
            inputEntry.set("bodyparamdes", (Object)param.getDesc());
            inputEntry.set("example", (Object)("-".equals(param.getExampleValue()) ? "-" : JSON.toJSONString((Object)StringUtil.trim((String)param.getExampleValue(), (int)50))));
            inputEntry.set("paramtype", (Object)OpenApiField.structTypeToOpenApiType(param.getType()).type());
            inputEntry.set("is_req_mul_value", (Object)param.isArray());
            inputEntry.set("must", (Object)(param.isRequired() ? "1" : "0"));
            inputEntry.set("pid", (Object)parentId);
            inputEntry.set("body_level", (Object)D.s((Object)level));
            if (param.getNameToChildParam() == null || param.getNameToChildParam().isEmpty()) continue;
            int l = level + 1;
            this.addInputBodyField(inputEntries, param.getNameToChildParam(), paramID, l);
        }
    }

    private void addOutputBodyField(DynamicObjectCollection outputEntries, Map<String, Param> nameToParam, long parentId, int level) {
        for (Map.Entry<String, Param> paramEntry : nameToParam.entrySet()) {
            Param param = paramEntry.getValue();
            DynamicObject outputEntry = outputEntries.addNew();
            long paramID = IDService.get().genLongId();
            outputEntry.set("id", (Object)paramID);
            outputEntry.set("respparamname", (Object)param.getName());
            outputEntry.set("respdes", (Object)param.getDesc());
            outputEntry.set("respparamtype", (Object)OpenApiField.structTypeToOpenApiType(param.getType()).type());
            outputEntry.set("respexample", (Object)("-".equals(param.getExampleValue()) ? "-" : JSON.toJSONString((Object)StringUtil.trim((String)param.getExampleValue(), (int)50))));
            outputEntry.set("is_resp_mul_value", (Object)param.isArray());
            outputEntry.set("pid", (Object)parentId);
            outputEntry.set("resp_level", (Object)level);
            if (param.getNameToChildParam() == null || param.getNameToChildParam().isEmpty()) continue;
            int l = level + 1;
            this.addOutputBodyField(outputEntries, param.getNameToChildParam(), paramID, l);
        }
    }

    @Override
    protected DynamicObjectCollection makeRespEntries(DynamicObject svc, DynamicObject api) {
        DynamicObjectCollection outputEntries = svc.getDynamicObjectCollection("respentryentity");
        outputEntries.clear();
        Map<String, Param> respNameToParam = new WebRespBody(api.getDynamicObjectCollection("web_resp_body")).getNameToParam();
        if (!respNameToParam.isEmpty()) {
            this.addOutputBodyField(outputEntries, respNameToParam, 0L, 1);
        }
        return outputEntries;
    }
}

