/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.parsers.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.api.parsers.model.IscFieldType;
import kd.isc.iscb.platform.core.api.parsers.xdm.XdmApiParam;
import kd.isc.iscb.platform.core.api.parsers.xdm.XdmParamTypeMap;
import kd.isc.iscb.platform.core.api.webapi.Util;

public class ApiParam {
    private String name;
    private String desc;
    private String originType;
    private IscFieldType iscFieldType;
    private boolean isArray;
    private boolean isRequired;
    private boolean isComplex;
    private List<ApiParam> childParams;

    public ApiParam() {
    }

    public ApiParam(Map<String, XdmApiParam> paramMap, String fieldName, Object object) {
        this.name = fieldName;
        this.setBaseInfoFromModel(paramMap, fieldName);
        if (object instanceof JSONObject) {
            this.handleJsonObject(paramMap, fieldName, (JSONObject)object);
        } else if (object instanceof JSONArray) {
            this.handleJsonArray(paramMap, fieldName, (JSONArray)object);
        } else {
            this.iscFieldType = XdmParamTypeMap.getIscTypeByXdmType(this.originType);
            if (this.iscFieldType == null) {
                this.setIscFieldTypeFromValue(object);
            }
        }
    }

    public ApiParam(String fieldName, IscFieldType iscFieldType, boolean isRequired) {
        this.name = fieldName;
        this.iscFieldType = iscFieldType;
        this.isRequired = isRequired;
    }

    private void setBaseInfoFromModel(Map<String, XdmApiParam> paramMap, String fieldName) {
        XdmApiParam originXdmParam = paramMap.get(fieldName);
        if (originXdmParam != null) {
            this.desc = originXdmParam.getDescription();
            this.originType = originXdmParam.getType();
            this.isRequired = originXdmParam.isIsRequired();
        }
    }

    private void handleJsonArray(Map<String, XdmApiParam> paramMap, String fieldName, JSONArray object) {
        this.isArray = true;
        if (!object.isEmpty()) {
            this.childParams = new ArrayList<ApiParam>(1);
            Object o = object.get(0);
            if (o instanceof JSONObject) {
                this.handleJsonObject(paramMap, fieldName, (JSONObject)o);
            } else {
                this.setIscFieldTypeFromValue(o);
            }
        } else {
            this.iscFieldType = IscFieldType.UNKNOWN;
        }
    }

    private void handleJsonObject(Map<String, XdmApiParam> paramMap, String fieldName, JSONObject object) {
        this.isComplex = true;
        this.iscFieldType = IscFieldType.STRUCT;
        this.childParams = new ArrayList<ApiParam>(object.size());
        for (Map.Entry entry : object.entrySet()) {
            String propName = (String)entry.getKey();
            Object value = entry.getValue();
            this.childParams.add(new ApiParam(paramMap, propName, value));
        }
    }

    private void setIscFieldTypeFromValue(Object object) {
        this.iscFieldType = Util.getIscFieldTypeFromValue(object);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc != null ? this.desc : this.name;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getOriginType() {
        return this.originType;
    }

    public void setOriginType(String originType) {
        this.originType = originType;
    }

    public void setIscFieldType(IscFieldType iscFieldType) {
        this.iscFieldType = iscFieldType;
    }

    public IscFieldType getIscFieldType() {
        return this.iscFieldType;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setArray(boolean array) {
        this.isArray = array;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean required) {
        this.isRequired = required;
    }

    public boolean isComplex() {
        return this.isComplex;
    }

    public void setComplex(boolean complex) {
        this.isComplex = complex;
    }

    public List<ApiParam> getChildParams() {
        return this.childParams;
    }

    public void setChildParams(List<ApiParam> childParams) {
        this.childParams = childParams;
    }
}

