/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.parsers.model;

import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.api.parsers.model.Model;
import kd.isc.iscb.platform.core.api.parsers.model.SwaggerField;
import kd.isc.iscb.platform.core.api.quick.UrlItem;

public class SwaggerModel
implements Model {
    private String url;
    private String method;
    private List<SwaggerField> urlParams;
    private List<SwaggerField> headers;
    private List<SwaggerField> requestBody;
    private List<SwaggerField> responses;
    private String number;
    private String name;
    private UrlItem urlItem;

    public SwaggerModel() {
    }

    private UrlItem parseUrl(String url, List<SwaggerField> urlParams) {
        UrlItem urlItem = new UrlItem(url);
        this.mergeUrlParams(urlItem, urlParams);
        return urlItem;
    }

    private void mergeUrlParams(UrlItem urlItem, List<SwaggerField> urlParams) {
        if (urlParams != null) {
            Map<String, Object> queryParamMap = urlItem.getQueryParamMap();
            for (SwaggerField urlParam : urlParams) {
                String name = urlParam.getName();
                Object value = urlParam.getDefaultValue();
                if (value == null) {
                    value = urlParam.getExampleValue();
                }
                if (value == null) continue;
                queryParamMap.put(name, value);
            }
        }
    }

    public SwaggerModel(String url, String method, List<SwaggerField> urlParams, List<SwaggerField> headers, List<SwaggerField> requestBody, List<SwaggerField> responses) {
        this.url = url;
        this.method = method;
        this.urlParams = urlParams;
        this.headers = headers;
        this.requestBody = requestBody;
        this.responses = responses;
        this.urlItem = this.parseUrl(url, urlParams);
        this.setNumberAndName();
    }

    private void setNumberAndName() {
        String path = this.urlItem.getPath();
        int i = path.indexOf("/v2");
        if (i >= 0) {
            String number;
            this.number = number = path.substring(i);
            this.name = number;
        } else {
            i = path.lastIndexOf(47);
            if (i >= 0) {
                String number;
                this.number = number = path.substring(i + 1);
                this.name = number;
            }
        }
    }

    public String getUrl() {
        return this.url;
    }

    public List<SwaggerField> getUrlParams() {
        return this.urlParams;
    }

    public void setUrlParams(List<SwaggerField> urlParams) {
        this.urlParams = urlParams;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UrlItem getUrlItem() {
        return this.urlItem;
    }

    public void setUrlItem(UrlItem urlItem) {
        this.urlItem = urlItem;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public List<SwaggerField> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<SwaggerField> headers) {
        this.headers = headers;
    }

    public List<SwaggerField> getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(List<SwaggerField> requestBody) {
        this.requestBody = requestBody;
    }

    public List<SwaggerField> getResponses() {
        return this.responses;
    }

    public void setResponses(List<SwaggerField> responses) {
        this.responses = responses;
    }
}

