/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.parsers.xdm;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.isc.iscb.platform.core.api.parsers.ApiParser;
import kd.isc.iscb.platform.core.api.parsers.model.ApiModel;
import kd.isc.iscb.platform.core.api.parsers.model.ApiParam;
import kd.isc.iscb.platform.core.api.parsers.model.IscFieldType;
import kd.isc.iscb.platform.core.api.parsers.model.Model;
import kd.isc.iscb.platform.core.api.parsers.xdm.ApiParamBuilder;
import kd.isc.iscb.platform.core.api.parsers.xdm.XdmConst;

public class XdmApiParser
implements ApiParser,
XdmConst {
    @Override
    public Model parse(String text) {
        Map item = (Map)JSON.parseObject((String)text, Map.class);
        List<ApiParam> inputs = this.makeApiInputParam(item);
        List<ApiParam> outputs = this.makeApiOutputParam(item);
        String subUrl = this.addPageParamToInput(item, inputs);
        String name = (String)item.get("name");
        String nameEn = (String)item.get("nameEn");
        String desc = (String)item.get("description");
        String requestMethod = (String)item.get("requestMethod");
        String url = requestMethod.toUpperCase(Locale.ENGLISH) + "://" + subUrl;
        return new ApiModel(nameEn, name, 0L, url, desc, inputs, outputs);
    }

    private String addPageParamToInput(Map<String, String> item, List<ApiParam> inputs) {
        int index;
        String requestUrl = item.get("requestUrl");
        String subUrl = requestUrl.substring(index = requestUrl.indexOf("/publicservices/api/") + 20);
        if (subUrl.contains("curPage")) {
            inputs.add(new ApiParam("curPage", IscFieldType.INT, true));
        }
        if (subUrl.contains("pageSize")) {
            inputs.add(new ApiParam("pageSize", IscFieldType.INT, true));
        }
        return subUrl;
    }

    private List<ApiParam> makeApiOutputParam(Map<String, String> item) {
        String respParamStr = item.get("responseParameters");
        String respExample = item.get("responseExample");
        return new ApiParamBuilder(respParamStr, respExample).build();
    }

    private List<ApiParam> makeApiInputParam(Map<String, String> item) {
        String reqParamStr = item.get("requestParameters");
        String reqExample = item.get("requestExample");
        return new ApiParamBuilder(reqParamStr, reqExample).build();
    }
}

