/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.quick;

import java.util.Map;
import kd.isc.iscb.platform.core.api.quick.CodeGenerator;
import kd.isc.iscb.platform.core.api.quick.HttpItem;
import kd.isc.iscb.platform.core.api.webapi.multipart.MultipartUtil;

public class CurlGenerator
implements CodeGenerator {
    @Override
    public String generate(HttpItem httpItem) {
        if (httpItem != null) {
            if (httpItem.bodyIsFormData()) {
                return MultipartUtil.generateCurlScript(httpItem);
            }
            return this.defaultHandle(httpItem);
        }
        return "";
    }

    private String defaultHandle(HttpItem httpItem) {
        StringBuilder sb = new StringBuilder("curl");
        sb.append(" -X ").append(httpItem.getHttpMethod()).append(" \\\r\n ");
        sb.append('\'').append(httpItem.getUrl()).append("' \\\r\n");
        for (Map.Entry<String, Object> entry : httpItem.getHeaders().entrySet()) {
            sb.append("-H ").append('\'').append(entry.getKey()).append(": ").append(entry.getValue()).append("' \\\r\n");
        }
        if (httpItem.getData() != null) {
            sb.append("-d ").append('\'').append(httpItem.getData()).append('\'');
        }
        return sb.toString();
    }
}

