/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.quick;

import java.io.Serializable;

public class FormItem
implements Serializable {
    public static final String IERP_FILE_PREFIX = "@IERP_FILE:";
    private boolean isFile;
    private String filePath;
    private String key;
    private String value;

    public FormItem() {
    }

    public FormItem(String key, String value) {
        this.key = key;
        if (value == null) {
            this.value = "";
        } else if (value.startsWith(IERP_FILE_PREFIX)) {
            this.isFile = true;
            String s = this.trimDoubleQuote(value);
            this.filePath = s.substring(IERP_FILE_PREFIX.length());
        } else if (value.startsWith("@")) {
            this.isFile = true;
            this.filePath = this.trimDoubleQuote(value.substring(1));
        } else {
            this.value = this.trimDoubleQuote(value);
        }
    }

    public boolean isFile() {
        return this.isFile;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public void setFile(boolean file) {
        this.isFile = file;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }

    private String trimDoubleQuote(String value) {
        if (value != null && value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    public String genValueForCurl() {
        if (this.isFile) {
            return "@\"" + this.filePath + "\"";
        }
        return "\"" + this.value + "\"";
    }

    public String genValueForIscScript() {
        if (this.isFile) {
            return "\"@IERP_FILE:" + this.filePath + "\"";
        }
        return "\"" + this.value + "\"";
    }
}

