/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.quick;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.api.parsers.model.Model;
import kd.isc.iscb.platform.core.api.quick.CurlTokenFinder;
import kd.isc.iscb.platform.core.api.quick.FormItem;
import kd.isc.iscb.platform.core.api.quick.UrlItem;
import kd.isc.iscb.platform.core.api.webapi.FormatType;
import kd.isc.iscb.platform.core.api.webapi.Util;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class HttpItem
implements Model {
    private static final String SHORT_HEADER_TAG = "-H";
    private static final String LONG_HEADER_TAG = "--header";
    private static final String SHORT_BODY_TAG = "-d";
    private static final String LONG_BODY_TAG = "--data";
    private static final String SHORT_REQUEST_METHOD = "-X";
    private static final String LONG_REQUEST_METHOD = "--request";
    private static final String DATA_URLENCODE = "--data-urlencode";
    private static final String SHORT_FORM_TAG = "-F";
    private static final String LONG_FORM_TAG = "--form";
    private String url;
    private Map<String, Object> headers = new LinkedHashMap<String, Object>();
    private String data;
    private String charset;
    private String httpMethod;
    private int timeout;
    private UrlItem urlItem;
    private List<String> urlEncodedBodyItem = new ArrayList<String>();
    private List<FormItem> formItemList = new ArrayList<FormItem>();
    private String resp;

    public HttpItem() {
    }

    public HttpItem(String url, Map<String, Object> cookies, Map<String, Object> headers, String data, String httpMethod, int timeout, String charset, String resp) {
        this.url = url;
        this.headers = this.getAllHeaderProperties(cookies, headers);
        this.data = data;
        this.initHttpMethod(httpMethod);
        this.initContentType();
        this.timeout = timeout;
        this.charset = charset;
        this.resp = resp;
    }

    public HttpItem(String url, Map<String, Object> cookies, Map<String, Object> headers, Map<String, Object> form, String method) {
        this.url = url;
        this.headers = this.getAllHeaderProperties(cookies, headers);
        if (form != null && form.size() > 0) {
            for (Map.Entry<String, Object> entry : form.entrySet()) {
                this.formItemList.add(new FormItem(entry.getKey(), D.s((Object)entry.getValue())));
            }
        }
        this.initHttpMethod(method);
        this.initContentType();
        this.timeout = 0;
        this.charset = "UTF-8";
    }

    public UrlItem getUrlItem() {
        if (this.urlItem == null) {
            this.urlItem = new UrlItem(this.url);
        }
        return this.urlItem;
    }

    private void initContentType() {
        String contentType = Util.getContentType(this.headers);
        if (contentType == null) {
            contentType = this.bodyIsFormData() ? Util.generateMultipartContentType(Util.newBoundary()) : Util.getContentTypeByBodyStr(this.data);
            this.headers.put("Content-Type", contentType);
        }
    }

    private void initHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod != null ? httpMethod : (this.data == null && this.formItemList.size() == 0 ? "GET" : "POST");
    }

    public HttpItem(String url, Map<String, Object> cookies, Map<String, Object> headers, String data, String httpMethod) {
        this(url, cookies, headers, data, httpMethod, 0, "UTF-8", null);
    }

    public HttpItem(String url, Map<String, Object> cookies, Map<String, Object> headers, String data, String httpMethod, String resp) {
        this(url, cookies, headers, data, httpMethod, 0, "UTF-8", resp);
    }

    public final Map<String, Object> getAllHeaderProperties(Map<String, Object> cookies, Map<String, Object> headers) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (cookies != null && cookies.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Object> e : cookies.entrySet()) {
                String name = e.getKey();
                String value = D.s((Object)e.getValue());
                if (sb.length() > 0) {
                    sb.append(';');
                }
                sb.append(name).append('=').append(value);
            }
            map.put("Cookie", sb.toString());
        }
        if (headers != null) {
            map.putAll(headers);
        }
        return map;
    }

    public HttpItem(String curlString) {
        curlString = this.trimAndCheck(curlString);
        List<String> validStrings = new CurlTokenFinder(curlString).find();
        this.handleValidStrings(validStrings);
        this.initBodyData();
        this.initHttpMethod(this.httpMethod);
        this.initContentType();
        this.checkUrl();
    }

    private void handleValidStrings(List<String> validStrings) {
        for (int i = 0; i < validStrings.size(); ++i) {
            String currentStr = validStrings.get(i);
            if (currentStr.equals(SHORT_HEADER_TAG) || currentStr.equals(LONG_HEADER_TAG)) {
                currentStr = validStrings.get(++i);
                this.recordHeaders(currentStr);
                continue;
            }
            if (currentStr.equals(DATA_URLENCODE)) {
                String encodedData = validStrings.get(++i);
                this.urlEncodedBodyItem.add(encodedData);
                continue;
            }
            if (currentStr.equals(SHORT_BODY_TAG) || currentStr.startsWith(LONG_BODY_TAG)) {
                this.data = validStrings.get(++i);
                continue;
            }
            if (currentStr.startsWith("http") || currentStr.startsWith("https")) {
                this.url = currentStr;
                continue;
            }
            if (currentStr.startsWith(SHORT_REQUEST_METHOD) || currentStr.startsWith(LONG_REQUEST_METHOD)) {
                this.httpMethod = validStrings.get(++i);
                continue;
            }
            if (!currentStr.equals(SHORT_FORM_TAG) && !currentStr.equals(LONG_FORM_TAG)) continue;
            currentStr = validStrings.get(++i);
            this.recordFormData(currentStr);
        }
    }

    private void recordHeaders(String currentStr) {
        int index = currentStr.indexOf(58);
        if (index <= 0) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"curl\u7684header\u53c2\u6570\u4e0d\u5408\u6cd5:%s,\u5e94\u8be5\u4ee5\":\"\u5206\u5272\u3002", (String)"HttpItem_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), currentStr));
        }
        this.headers.put(D.s((Object)currentStr.substring(0, index)), D.s((Object)currentStr.substring(index + 1)));
    }

    private void recordFormData(String currentStr) {
        int index = currentStr.indexOf(61);
        if (index <= 0) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"curl\u7684form\u53c2\u6570\u4e0d\u5408\u6cd5:%s,\u5e94\u8be5\u4ee5\"=\"\u5206\u5272\u3002", (String)"HttpItem_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), currentStr));
        }
        String key = D.s((Object)currentStr.substring(0, index));
        String value = D.s((Object)currentStr.substring(index + 1));
        this.formItemList.add(new FormItem(key, value));
    }

    private void initBodyData() {
        if (this.urlEncodedBodyItem.size() > 0) {
            this.data = StringUtil.join(this.urlEncodedBodyItem, (String)"&");
        }
    }

    private void checkUrl() {
        if (this.url == null) {
            throw new IscBizException(ResManager.loadKDString((String)"curl\u547d\u4ee4\u5b57\u7b26\u4e32\u4e0d\u5408\u6cd5\uff0c\u627e\u4e0d\u5230\u8c03\u7528\u7684url\u5730\u5740\u3002", (String)"HttpItem_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    private String trimAndCheck(String curlString) {
        if ((curlString = D.s((Object)curlString)) == null) {
            throw new IscBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684curl\u547d\u4ee4\u5b57\u7b26\u4e32\u4e3a\u7a7a\u3002", (String)"HttpItem_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        String start = curlString.substring(0, 4);
        if (!"curl".equalsIgnoreCase(start)) {
            throw new IscBizException(ResManager.loadKDString((String)"curl\u547d\u4ee4\u5b57\u7b26\u4e32\u5e94\u8be5\u4ee5\"curl\"\u5f00\u5934", (String)"HttpItem_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return curlString;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public String getData() {
        return this.data;
    }

    public Map<String, Object> getDataMap() {
        if (this.data != null) {
            return FormatType.getFormatTypeByContentType(Util.getContentType(this.headers)).parse(this.data);
        }
        return null;
    }

    public boolean isJson() {
        return this.data != null && this.data.startsWith("{");
    }

    public boolean isXml() {
        return this.data != null && this.data.startsWith("<?xml");
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean bodyIsFormData() {
        return this.formItemList.size() > 0;
    }

    public void setFormItemList(List<FormItem> formItemList) {
        this.formItemList = formItemList;
    }

    public List<FormItem> getFormItemList() {
        return Collections.unmodifiableList(this.formItemList);
    }

    public String getResp() {
        return this.resp;
    }

    public void setResp(String resp) {
        this.resp = resp;
    }

    public String toString() {
        return "HttpItem{url='" + this.url + '\'' + ", headers=" + this.headers + ", data='" + this.data + '\'' + ", httpMethod='" + this.httpMethod + '\'' + ", charset='" + this.charset + '\'' + ", timeout=" + this.timeout + '}';
    }
}

