/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.quick;

import com.alibaba.fastjson.JSON;
import kd.isc.iscb.platform.core.api.quick.CodeGenerator;
import kd.isc.iscb.platform.core.api.quick.HttpItem;
import kd.isc.iscb.platform.core.api.webapi.multipart.MultipartUtil;

public class IscHttpFuncGenerator
implements CodeGenerator {
    private static final String formatStr = "var url = \"%s\";\nvar httpMethod = \"%s\";\nvar header = %s;\nvar data = %s;\nvar result = HttpAccess(url, httpMethod, %s, \"UTF-8\", null, header).result;";
    private static final String formatStr2 = "var url = \"%s\";\nvar httpMethod = \"%s\";\nvar header = %s;\nvar data = %s;\nvar result = HttpAccess(url, httpMethod, %s, \"UTF-8\", null, header);";

    @Override
    public String generate(HttpItem httpItem) {
        return this.generate(httpItem, true);
    }

    public String generate(HttpItem httpItem, boolean withResult) {
        if (httpItem != null) {
            if (httpItem.bodyIsFormData()) {
                return MultipartUtil.generateIscScript(httpItem, withResult);
            }
            return this.defaultHandle(httpItem, withResult);
        }
        return "";
    }

    private String defaultHandle(HttpItem httpItem, boolean withResult) {
        String str = withResult ? formatStr : formatStr2;
        String data = this.getData(httpItem);
        String dataFormatStr = httpItem.isJson() ? "String.FormatJson(data)" : "data";
        return String.format(str, httpItem.getUrl(), httpItem.getHttpMethod(), JSON.toJSONString(httpItem.getHeaders(), (boolean)true), data, dataFormatStr);
    }

    private String getData(HttpItem httpItem) {
        String orignalData = httpItem.getData();
        if (orignalData == null) {
            return null;
        }
        if (httpItem.isJson()) {
            return httpItem.getData();
        }
        return "'" + httpItem.getData() + "'";
    }
}

