/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.quick;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.api.webapi.Util;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class UrlItem {
    private static final String PROTOCOL_TAG = "://";
    private String url;
    private String protocol;
    private String domain;
    private String path;
    private String queryParamStr;
    private String ip;
    private int port;
    private Map<String, Object> queryParamMap = new LinkedHashMap<String, Object>();

    public UrlItem(String url) {
        this.checkUrl(url);
        this.url = url;
        String[] split = url.split(PROTOCOL_TAG);
        this.protocol = split[0];
        String subUrl = split[1];
        int start = subUrl.indexOf(47);
        if (start >= 0) {
            this.domain = subUrl.substring(0, start);
            int end = (subUrl = subUrl.substring(start)).indexOf(63);
            if (end > 0) {
                this.path = subUrl.substring(0, end);
                this.queryParamStr = subUrl.substring(end + 1);
                this.queryParamMap = Util.initUrlParamMap(this.queryParamStr);
            } else {
                this.path = subUrl;
            }
        } else {
            this.domain = subUrl;
        }
        this.initIpAndPort();
    }

    private void initIpAndPort() {
        try {
            int index = this.domain.indexOf(58);
            if (index >= 0) {
                this.ip = this.domain.substring(0, index);
                this.port = D.i((Object)this.domain.substring(index + 1));
            } else {
                this.ip = this.domain;
                this.port = -1;
            }
        }
        catch (Throwable e) {
            this.ip = this.domain;
            this.port = -1;
        }
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    private void checkUrl(String url) {
        if (StringUtil.isEmpty((String)url)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684url\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"UrlItem_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (!url.contains(PROTOCOL_TAG)) {
            throw new IscBizException(ResManager.loadKDString((String)"url\u4e0d\u5b8c\u6574\uff0c\u9700\u5305\u542b\u5b8c\u6574\u534f\u8bae\u5934", (String)"UrlItem_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getUrlPrefix() {
        return this.protocol + PROTOCOL_TAG + this.domain;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public String getQueryParamStr() {
        return this.queryParamStr;
    }

    public Map<String, Object> getQueryParamMap() {
        return this.queryParamMap;
    }
}

