/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.webapi;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.api.parsers.model.IscFieldType;
import kd.isc.iscb.platform.core.api.webapi.Const;
import kd.isc.iscb.platform.core.api.webapi.Util;
import kd.isc.iscb.platform.core.api.webapi.multipart.IerpFileType;
import kd.isc.iscb.platform.core.api.webapi.privacy.PrivacyQueryDto;
import kd.isc.iscb.platform.core.api.webapi.privacy.PrivacyService;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.DataTypes;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.Script;

public class Param
implements DataType,
Const {
    private long id;
    private String name;
    private String desc;
    private String paramValue;
    private String type;
    private IscFieldType iscFieldType;
    private DataType dataType;
    private boolean isArray;
    private boolean isRequired;
    private boolean isComplex;
    private Script script;
    private String exampleValue;
    private PrivacyQueryDto privacyQueryDto;
    private Map<String, Param> nameToChildParam;

    public Param(long id, String name, String desc, String type, boolean isArray, boolean isRequired, String exampleValue, String paramValue) {
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.initType(type, isArray);
        this.initValue(paramValue);
        this.isRequired = isRequired;
        this.exampleValue = exampleValue;
    }

    private void initValue(String paramValue) {
        this.paramValue = paramValue;
        if (paramValue != null) {
            if (this.isVariable(paramValue)) {
                this.script = Script.compileSimpleScript((String)paramValue);
            } else if (this.isSimpleScript(paramValue)) {
                String scriptStr = this.getSimpleScriptStr(paramValue);
                this.script = Script.compileSimpleScript((String)scriptStr);
            }
        }
    }

    private void initType(String type, boolean isArray) {
        this.type = type;
        this.iscFieldType = IscFieldType.getIscTypeByTypeName(type);
        boolean bl = this.isComplex = IscFieldType.STRUCT == this.iscFieldType;
        if (this.isComplex) {
            this.dataType = this;
            this.nameToChildParam = new HashMap<String, Param>();
        } else {
            this.dataType = this.iscFieldType == IscFieldType.IERP_FILE ? IerpFileType.INSTANCE : DataTypes.get((String)type);
        }
        this.isArray = isArray;
        if (isArray) {
            this.dataType = DataTypes.listType((DataType)this.dataType);
        }
    }

    private String getSimpleScriptStr(String paramValue) {
        int start = paramValue.indexOf("<%");
        int end = paramValue.lastIndexOf("%>");
        return paramValue.substring(start + 2, end);
    }

    private boolean isSimpleScript(String paramValue) {
        return paramValue.startsWith("<%") && paramValue.endsWith("%>");
    }

    private boolean isVariable(String paramValue) {
        return paramValue.startsWith("$");
    }

    public Object eval(Map<String, Object> orignalCtx) {
        Object value = this.check(orignalCtx);
        try {
            String tarCountry;
            Object returnValue = this.narrowValueWithCtx(orignalCtx, value);
            if (this.privacyQueryDto != null && (tarCountry = D.s((Object)orignalCtx.get("$privacyDomainsNum"))) != null) {
                return ((PrivacyService)PrivacyService.INSTANCE.get()).convertValue(this.privacyQueryDto, returnValue, tarCountry);
            }
            return returnValue;
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570 %1$s(%2$s) \u7c7b\u578b\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u7c7b\u578b\u5b9a\u4e49\u6216\u4f20\u5165\u53c2\u6570\u662f\u5426\u6709\u8bef\u3002", (String)"Util_37", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.getDesc(), this.getName()), (Throwable)e);
        }
    }

    private Object check(Map<String, Object> orignalCtx) {
        Object value = orignalCtx.get(this.name);
        value = this.checkFixValue(value, orignalCtx);
        this.checkNotNull(value);
        return value;
    }

    private Object narrowValueWithCtx(Map<String, Object> orignalCtx, Object value) {
        if (this.isComplex() && this.isArray()) {
            return this.handleEntryType(orignalCtx, value);
        }
        if (this.isComplex() && value instanceof Map) {
            Map<String, Object> mergeCtx = this.mergeContext((Map)value, orignalCtx);
            return this.getDataType().narrow(mergeCtx);
        }
        return this.getDataType().narrow(value);
    }

    private Object handleEntryType(Map<String, Object> orignalCtx, Object value) {
        if (value instanceof List) {
            List listVal = (List)value;
            ArrayList<Map<String, Object>> newListCtx = new ArrayList<Map<String, Object>>(listVal.size());
            for (Map o : listVal) {
                Map<String, Object> mergeCtx = this.mergeContext(o, orignalCtx);
                newListCtx.add(mergeCtx);
            }
            return this.getDataType().narrow(newListCtx);
        }
        if (value instanceof Map) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(1);
            Map<String, Object> mergeCtx = this.mergeContext((Map)value, orignalCtx);
            list.add(mergeCtx);
            return this.getDataType().narrow(list);
        }
        return this.getDataType().narrow(value);
    }

    private Map<String, Object> mergeContext(Map<String, Object> value, Map<String, Object> orignalCtx) {
        HashMap<String, Object> mergeCtx = new HashMap<String, Object>(value);
        if (orignalCtx != null) {
            for (Map.Entry<String, Object> entry : orignalCtx.entrySet()) {
                if (mergeCtx.containsKey(entry.getKey())) continue;
                mergeCtx.put(entry.getKey(), entry.getValue());
            }
        }
        return mergeCtx;
    }

    private void checkNotNull(Object value) {
        if (this.isRequired() && value == null) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\uff08%s\uff09\u8bbe\u7f6e\u4e86\u5fc5\u586b\uff0c\u4e0d\u5141\u8bb8\u4e3anull", (String)"Util_27", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.name));
        }
    }

    private Object checkFixValue(Object value, Map<String, Object> ctx) {
        Object eval = this.innerEval(ctx);
        if (!Util.isEmpty(eval)) {
            if (value != null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"WebAPI\u7684\u53c2\u6570%s\u5df2\u7ecf\u8bbe\u7f6e\u4e86\u56fa\u5b9a\u8d4b\u503c\uff0c\u4e0d\u5141\u8bb8\u518d\u4f20\u5165\u52a8\u6001\u53c2\u6570", (String)"Util_29", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.name));
            }
            value = eval;
        }
        return value;
    }

    public Object innerEval(Map<String, Object> ctx) {
        if (this.script != null) {
            return this.script.eval(ctx);
        }
        return this.paramValue;
    }

    public Object getTestValue() {
        if (this.isArray) {
            ArrayList<Object> ret = new ArrayList<Object>();
            ret.add(this.innerGetTestValue());
            return ret;
        }
        return this.innerGetTestValue();
    }

    private Object innerGetTestValue() {
        if (this.isComplex) {
            return this.handleStruct();
        }
        return this.handleBaseType();
    }

    private Object handleBaseType() {
        if (Util.isEmpty(this.exampleValue)) {
            return this.getDefaultValue(this.type);
        }
        return this.exampleValue;
    }

    private Object handleStruct() {
        Set<Map.Entry<String, Param>> entries = this.nameToChildParam.entrySet();
        LinkedHashMap<String, Object> example = new LinkedHashMap<String, Object>(entries.size());
        for (Map.Entry<String, Param> entry : entries) {
            Param param = entry.getValue();
            if (param.getParamValue() != null) continue;
            example.put(entry.getKey(), param.getTestValue());
        }
        return example;
    }

    private Object getDefaultValue(String type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case "string": {
                return "";
            }
            case "int": 
            case "long": {
                return 0;
            }
            case "decimal": {
                return BigDecimal.ZERO;
            }
            case "datetime": {
                return "1970-01-01 00:00:00";
            }
            case "boolean": {
                return Boolean.FALSE;
            }
            case "double": {
                return 0.0;
            }
        }
        return null;
    }

    public void addChildParam(Param param) {
        if (this.nameToChildParam == null) {
            this.nameToChildParam = new LinkedHashMap<String, Param>();
        }
        this.nameToChildParam.put(param.getName(), param);
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public String getType() {
        return this.type;
    }

    public Script getScript() {
        return this.script;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public IscFieldType getIscFieldType() {
        return this.iscFieldType;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean isComplex() {
        return this.isComplex;
    }

    public Map<String, Param> getNameToChildParam() {
        return this.nameToChildParam;
    }

    public String getExampleValue() {
        return this.exampleValue;
    }

    public Object narrow(Object outerValue) {
        if (outerValue == null) {
            if (this.isRequired) {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\uff08%s\uff09\u8bbe\u7f6e\u4e86\u5fc5\u586b\uff0c\u4e0d\u5141\u8bb8\u4e3anull", (String)"Param_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.name));
            }
            return null;
        }
        if (!(outerValue instanceof Map)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\uff08%1$s\uff09\u4f20\u5165\u7684\u53c2\u6570\u7c7b\u578b\u5e94\u8be5\u4e3amap\uff0c\u4f46\u5f53\u524d\u4f20\u5165\u7684\u5b57\u6bb5\u7c7b\u578b\u4e3a\uff1a%2$s", (String)"Param_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.name, outerValue.getClass()));
        }
        Map map = (Map)outerValue;
        return Util.evalParam(this.nameToChildParam, map, false);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Object forSave(Object innerValue) {
        throw new UnsupportedOperationException();
    }

    public Object forJson(Object object) {
        return object;
    }

    public void setPrivacyQueryDto(PrivacyQueryDto privacyQueryDto) {
        this.privacyQueryDto = privacyQueryDto;
    }
}

