/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.webapi;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.api.quick.HttpItem;
import kd.isc.iscb.platform.core.api.quick.HttpRecorder;
import kd.isc.iscb.platform.core.api.webapi.Const;
import kd.isc.iscb.platform.core.api.webapi.FormatType;
import kd.isc.iscb.platform.core.api.webapi.Util;
import kd.isc.iscb.platform.core.api.webapi.WebReqBody;
import kd.isc.iscb.platform.core.api.webapi.WebReqHeader;
import kd.isc.iscb.platform.core.api.webapi.WebRespBody;
import kd.isc.iscb.platform.core.api.webapi.WebUrlParam;
import kd.isc.iscb.platform.core.api.webapi.privacy.PrivacyService;
import kd.isc.iscb.platform.core.cache.CacheableObjectFactory;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.platform.core.cache.data.ConnectionConfig;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.webapi.ReloginFunction;
import kd.isc.iscb.platform.core.connector.webapi.WebApiConnectionFactory;
import kd.isc.iscb.platform.core.fn.ScriptFunction;
import kd.isc.iscb.platform.core.fn.ScriptFunctionManager;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.ReflectionUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.misc.mem.ObjectSizeIgnored;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.misc.log.LoggerFactory;

public class WebApi
implements Const,
ObjectSizeIgnored {
    private DynamicObject cfg;
    private long id;
    private String urlScript;
    private String charset;
    private String orginalWebSite;
    private String urlPath;
    private String relativePathScript;
    private int timeout;
    private boolean omitEmptyParams;
    private boolean needFormatResult;
    private String method;
    private WebUrlParam webUrlParams;
    private WebReqHeader webReqHeader;
    private WebReqBody webReqBody;
    private WebRespBody webRespBody;
    private Map<String, ScriptFunction> functions;
    private long dsId;
    private String invokeScriptTxt;
    private Script invokeScript;
    private boolean isMultipart;
    private boolean isForDebugTool;
    private Map<String, Object> privacyInfo;

    public static WebApi get(long id) {
        return CacheableObjectManager.get(WebApi.class, id);
    }

    public static WebApi getByNumber(String number) {
        WebApi webApi = CacheableObjectManager.getByNumber(WebApi.class, number);
        if (webApi != null) {
            return webApi;
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a\u3010%s\u3011\u7684WebApi\u5bf9\u8c61\u3002", (String)"WebApi_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), number));
    }

    public WebApi(DynamicObject dynamicObject) {
        this.cfg = dynamicObject;
        this.id = D.l((Object)dynamicObject.get("id"));
        this.method = D.s((Object)dynamicObject.get("method"));
        this.orginalWebSite = D.s((Object)dynamicObject.get("url_prefix"));
        this.urlPath = D.s((Object)dynamicObject.get("url_path"));
        this.dsId = D.l((Object)dynamicObject.get("group_id"));
        this.timeout = D.i((Object)dynamicObject.get("timeout"));
        String charset = D.s((Object)dynamicObject.get("charset"));
        this.charset = charset != null ? charset : "UTF-8";
        this.omitEmptyParams = D.x((Object)dynamicObject.get("omit_empty_params"));
        this.needFormatResult = D.x((Object)dynamicObject.get("need_format_result"));
        this.isMultipart = D.x((Object)dynamicObject.get("is_multipart"));
        this.invokeScriptTxt = D.s((Object)dynamicObject.get("invoke_script_tag"));
        this.invokeScript = Script.compile((String)this.invokeScriptTxt);
        this.webUrlParams = new WebUrlParam(dynamicObject.getDynamicObjectCollection("web_url_params"));
        this.initUrlOrRelativePath();
        this.webReqHeader = new WebReqHeader(dynamicObject.getDynamicObjectCollection("web_req_header"));
        this.privacyInfo = this.initPrivacyInfo();
        this.webReqBody = new WebReqBody(this.id, dynamicObject.getDynamicObjectCollection("web_req_body"), this.privacyInfo);
        this.webRespBody = new WebRespBody(dynamicObject.getDynamicObjectCollection("web_resp_body"));
        this.functions = this.initWebResource(dynamicObject);
    }

    public WebApi(String method, String url, DynamicObject apiTest) {
        this.webUrlParams = new WebUrlParam(apiTest.getDynamicObjectCollection("web_url_params"));
        this.webReqHeader = new WebReqHeader(apiTest.getDynamicObjectCollection("web_req_header"));
        this.webReqBody = new WebReqBody(apiTest.getDynamicObjectCollection("web_req_body"));
        this.isForDebugTool = true;
        this.initUrl(url);
        this.isMultipart = D.x((Object)apiTest.get("is_multipart"));
        this.method = method;
        this.charset = "utf-8";
        this.timeout = 300000;
        this.invokeScriptTxt = this.getInvokeScript();
    }

    private void initUrl(String url) {
        this.urlScript = this.webUrlParams.generateUrlScript(url);
    }

    public WebApi() {
    }

    private Map<String, ScriptFunction> initWebResource(DynamicObject dynamicObject) {
        DynamicObjectCollection resources = dynamicObject.getDynamicObjectCollection("resources");
        HashMap<String, ScriptFunction> functionMap = new HashMap<String, ScriptFunction>(resources.size());
        for (DynamicObject resource : resources) {
            ScriptFunction fn = ScriptFunctionManager.getFunction(resource.getLong("res_ref.id"));
            functionMap.put(resource.getString("res_alias"), fn);
        }
        return functionMap;
    }

    private void initUrlOrRelativePath() {
        if (this.isMultipart) {
            this.relativePathScript = this.webUrlParams.generateRelativePathScript(this.urlPath);
        } else {
            this.urlScript = this.webUrlParams.generateUrlScript(this.urlPath);
        }
    }

    public long getId() {
        return this.id;
    }

    public DynamicObject getCfg() {
        return this.cfg;
    }

    private Map<String, Object> initPrivacyInfo() {
        QFilter qFilter = new QFilter("api.id", "=", (Object)this.id);
        DynamicObject apicPrivacy = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_apic_privacy", (QFilter[])new QFilter[]{qFilter});
        if (apicPrivacy != null) {
            return (Map)Json.toObject((String)D.s((Object)apicPrivacy.get("privacy_info_tag")));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object invoke(Script invokeScript, Map<String, Object> body, Map<String, Object> head, Map<String, Object> queryParam, String realDataSourceNumber) {
        DataSource dataSource = this.getRealDataSource(realDataSourceNumber);
        if (dataSource == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u6570\u636e\u6e90\u4e0d\u5b58\u5728\u3002", (String)"WebApi_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), realDataSourceNumber));
        }
        long dbLink = dataSource.getDbLink();
        try (ConnectionWrapper conwrap = ConnectionManager.getConnection(dbLink);){
            Object object = this.invokeWithConnection(invokeScript, body, head, queryParam, conwrap);
            return object;
        }
        catch (Exception e) {
            String linkNumber = ConnectionConfig.getConfig(dbLink).getString("number");
            String msg = String.format(ResManager.loadKDString((String)"WebAPI\uff08%1$s@%2$s\uff09\u8c03\u7528\u5931\u8d25,\u539f\u56e0:%3$s", (String)"WebApi_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.cfg.getString("number"), linkNumber, StringUtil.getCascadeMessage((Throwable)e));
            throw new IscBizException(msg, (Throwable)e);
        }
    }

    private Object invokeWithConnection(Script invokeScript, Map<String, Object> body, Map<String, Object> head, Map<String, Object> queryParam, ConnectionWrapper conwrap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<String, Object> cnCtx = this.genCtx(conwrap);
        map.put("$head", this.webReqHeader.eval(this.mergeParamAndContext(head, cnCtx)));
        map.put("$body", this.webReqBody.eval(this.mergeParamAndContext(body, cnCtx), this.omitEmptyParams));
        map.put("$urlParam", this.webUrlParams.eval(this.mergeParamAndContext(queryParam, cnCtx)));
        map.putAll(cnCtx);
        map.put("$connection", cnCtx.get("this"));
        map.put("$cn", conwrap);
        map.putAll(this.functions);
        Object eval = invokeScript.eval(map);
        if (this.needFormatResult) {
            return this.webRespBody.eval(eval);
        }
        return eval;
    }

    private DataSource getRealDataSource(String realDataSourceNumber) {
        DataSource dataSource = StringUtil.isEmpty((String)realDataSourceNumber) ? DataSource.get(this.dsId) : DataSource.get(realDataSourceNumber);
        return dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object invoke(Map<String, Object> body, Map<String, Object> head, Map<String, Object> queryParam, String realDataSourceNumber) {
        ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense(this.cfg));
        try {
            Object object = this.invoke(this.invokeScript, body, head, queryParam, realDataSourceNumber);
            return object;
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    Object invokeWithConnection(Map<String, Object> body, Map<String, Object> head, Map<String, Object> queryParam, ConnectionWrapper connectionWrapper) {
        ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense(this.cfg));
        try {
            Object object = this.invokeWithConnection(this.invokeScript, body, head, queryParam, connectionWrapper);
            return object;
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"WebAPI\uff08%1$s@%2$s\uff09\u8c03\u7528\u5931\u8d25,\u539f\u56e0:%3$s", (String)"WebApi_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.cfg.getString("number"), connectionWrapper.getConfig().getString("number"), StringUtil.getCascadeMessage((Throwable)e));
            throw new IscBizException(msg, (Throwable)e);
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    public HttpItem generateHttpItemByExampleData() {
        ConnectionManager.pushResLicense(true);
        try {
            HttpItem httpItem = this.innerGenerateHttpItem();
            return httpItem;
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpItem generateTestHttpItem(String bodyStr) {
        Script testScript = Script.compile((String)this.invokeScriptTxt, Util.replaceHttpFunction());
        try {
            HttpRecorder.openRecording();
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            ctx.put("$head", this.webReqHeader.eval(new HashMap<String, Object>()));
            ctx.put("$urlParam", this.webUrlParams.eval(new HashMap<String, Object>()));
            ctx.put("$body", !StringUtil.isEmpty((String)bodyStr) ? bodyStr : this.webReqBody.eval(this.webReqBody.getExampleParamMap(), false));
            testScript.eval(ctx);
            HttpItem httpItem = HttpRecorder.getHttpItem();
            return httpItem;
        }
        finally {
            HttpRecorder.closeRecording();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpItem innerGenerateHttpItem() {
        Map<String, Object> body = this.webReqBody.getExampleParamMap();
        Script exampleScript = Script.compile((String)this.invokeScriptTxt, Util.replaceHttpFunction());
        try {
            HttpRecorder.openRecording();
            this.invoke(exampleScript, body, new HashMap<String, Object>(), new HashMap<String, Object>(), null);
            HttpItem httpItem = HttpRecorder.getHttpItem();
            return httpItem;
        }
        finally {
            HttpRecorder.closeRecording();
        }
    }

    private Map<String, Object> genCtx(ConnectionWrapper conwrap) {
        ConnectionFactory factory = conwrap.getFactory();
        if (factory instanceof WebApiConnectionFactory) {
            WebApiConnectionFactory webApiConnectionFactory = (WebApiConnectionFactory)factory;
            Map<String, Object> ctx = webApiConnectionFactory.generateCtx(conwrap.getConfig());
            ctx.put("Relogin", new ReloginFunction(conwrap));
            ctx.put("$urlPath", this.urlPath);
            ctx.put("$privacyDomainsNum", WebApi.getTarCountry(ctx));
            return ctx;
        }
        DynamicObject connType = Util.queryConnTypeByConn(conwrap.getConfig());
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u9009\u62e9WebAPI\u8fde\u63a5\u7c7b\u578b\u7684\u6570\u636e\u6e90\uff0c\u800c\u5f53\u524d\u8fde\u63a5\u7c7b\u578b\u3010%1$s\uff08%2$s\uff09\u3011", (String)"WebApi_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), connType.get("name"), connType.get("number")));
    }

    public static String getTarCountry(Map<String, Object> ctx) {
        Object eval = Script.compile((String)"this.privacyDomains").eval(ctx);
        if (eval instanceof Map) {
            DynamicObject country;
            Map map = (Map)eval;
            String entityType = D.s(map.get("entityType"));
            Object entityPk = map.get("entityPk");
            if (entityType != null && entityPk != null && (country = BusinessDataServiceHelper.loadSingle(entityPk, (String)entityType)) != null) {
                return D.s((Object)country.get("number"));
            }
        }
        return null;
    }

    private Map<String, Object> mergeParamAndContext(Map<String, Object> map, Map<String, Object> cnCtx) {
        HashMap<String, Object> mergeCtx = new HashMap<String, Object>();
        if (map != null) {
            mergeCtx.putAll(map);
        }
        mergeCtx.putAll(cnCtx);
        mergeCtx.put("$connection", cnCtx.get("this"));
        return mergeCtx;
    }

    public final String getInvokeScript() {
        StringBuilder sb = new StringBuilder();
        this.appendComment(sb);
        this.appendUrlOrRelativePath(sb);
        this.appendHeadScript(sb);
        this.appendRequestScript(sb);
        return sb.toString();
    }

    private void appendUrlOrRelativePath(StringBuilder sb) {
        if (this.isMultipart) {
            this.appendRelativePath(sb);
        } else {
            this.appendUrl(sb);
        }
    }

    private void appendRelativePath(StringBuilder sb) {
        sb.append(this.relativePathScript);
    }

    private void appendRequestScript(StringBuilder sb) {
        if (this.isMultipart) {
            this.appendFormDataScript(sb);
        } else {
            if (this.isForDebugTool) {
                sb.append("var dataStr = $body;\n");
            } else {
                this.appendFormatBodyScript(sb);
            }
            this.appendInvokeScript(sb);
        }
    }

    private void appendFormDataScript(StringBuilder sb) {
        sb.append(ResManager.loadKDString((String)"//\u8c03\u7528\u5e76\u8fd4\u56de\u7ed3\u679cbody\u5b57\u7b26\u4e32", (String)"WebApi_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        sb.append('\n');
        String returnStr = "return Http.sendMultipart($cn, relativePath, \"%s\", $body, \"%s\", null, head, %d).result;";
        sb.append(String.format(returnStr, this.method, this.charset, this.timeout));
    }

    private void appendHeadScript(StringBuilder sb) {
        sb.append("//head \t");
        sb.append(ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u53d8\u91cf", (String)"WebApi_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        sb.append('\n');
        sb.append("var head = {\n");
        sb.append(this.webReqHeader.getHeaderString());
        sb.append("\n};\n");
    }

    private void appendComment(StringBuilder sb) {
        sb.append("//$body\t");
        sb.append(ResManager.loadKDString((String)"\u8bf7\u6c42\u4f53", (String)"WebApi_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        sb.append('\n');
        sb.append("//$head\t");
        sb.append(ResManager.loadKDString((String)"\u8bf7\u6c42\u5934", (String)"WebApi_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        sb.append('\n');
        sb.append("//$urlParam\t");
        sb.append(ResManager.loadKDString((String)"URL\u53c2\u6570", (String)"WebApi_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        sb.append('\n');
        sb.append("//$connection\t");
        sb.append(ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e\u5bf9\u8c61", (String)"WebApi_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        sb.append('\n');
        sb.append("//$cn\t");
        sb.append(ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e\u6e90\u3001\u8fde\u63a5\u914d\u7f6e\u8d44\u6e90\u65f6\u751f\u6210\u7684\u8fde\u63a5\u5305\u88c5\u5bf9\u8c61\uff0c\u5305\u542bsession\u4fe1\u606f", (String)"WebApi_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        sb.append('\n');
        sb.append("//$session\t");
        sb.append(ResManager.loadKDString((String)"\u4f1a\u8bdd\u4fe1\u606f", (String)"WebApi_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        sb.append('\n');
        sb.append("//$website\t");
        sb.append(ResManager.loadKDString((String)"\u7f51\u7ad9\u5730\u5740", (String)"WebApi_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        sb.append('\n');
        sb.append("//$urlPath\t");
        sb.append(ResManager.loadKDString((String)"\u8bf7\u6c42\u8def\u5f84", (String)"WebApi_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        sb.append('\n');
    }

    private void appendFormatBodyScript(StringBuilder sb) {
        Map<String, Object> head = this.webReqHeader.getExampleParamMap();
        FormatType formatType = this.webReqBody.isEmpty() ? FormatType.DEFAULT : this.webReqHeader.getFormatType(Util.getContentType(head));
        sb.append(formatType.genScript()).append('\n');
    }

    private void appendInvokeScript(StringBuilder sb) {
        sb.append(ResManager.loadKDString((String)"//\u8c03\u7528\u5e76\u8fd4\u56de\u7ed3\u679cbody\u5b57\u7b26\u4e32", (String)"WebApi_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        sb.append('\n');
        String returnStr = "return HttpAccess(url, \"%s\", dataStr, \"%s\", null, head, %d).result;";
        sb.append(String.format(returnStr, this.method, this.charset, this.timeout));
    }

    private void appendUrl(StringBuilder sb) {
        sb.append("//url \t");
        String tips = String.format(ResManager.loadKDString((String)"\u8be5API\u7684\u8bbf\u95ee\u5730\u5740\uff0c\u5176\u4e2d\u539f\u59cb\u7f51\u7ad9\u7684\u5730\u5740\u4e3a %s", (String)"WebApi_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.orginalWebSite);
        sb.append(tips);
        sb.append('\n');
        sb.append(this.getUrlScript());
    }

    public String getUrlScript() {
        return this.urlScript;
    }

    public Map<String, Object> getBodyExample() {
        return this.webReqBody.getExampleParamMap();
    }

    public Map<String, Object> getHeaderExample() {
        return this.webReqHeader.getExampleXParamMap();
    }

    public Map<String, Object> getUrlParamsExample() {
        return this.webUrlParams.getExampleParamMap();
    }

    static {
        try {
            Object o = ReflectionUtil.newInstance((String)"kd.isc.iscb.webapi.privacy.PrivacyServiceImpl");
            PrivacyService.INSTANCE.set((Object)((PrivacyService)o));
        }
        catch (Throwable e) {
            ((LoggerFactory)LoggerFactory.REF.get()).getLogger(WebApi.class).error("init Initializer instance error : ", e);
        }
        CacheableObjectManager.registerFactory(new CacheableObjectFactory<WebApi>(){

            @Override
            public String entityType() {
                return "isc_apic_webapi";
            }

            @Override
            public WebApi create(DynamicObject cfg) {
                return new WebApi(cfg);
            }

            @Override
            public Class<WebApi> target() {
                return WebApi.class;
            }
        });
    }
}

