/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.webapi;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.id.IDService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.IscRuntimeInfo;
import kd.isc.iscb.platform.core.api.UserPermissionUtil;
import kd.isc.iscb.platform.core.api.webapi.WebApi;
import kd.isc.iscb.platform.core.apic.IscApiSetting;
import kd.isc.iscb.platform.core.apic.IscLogFactory;
import kd.isc.iscb.platform.core.apis.ApiInvokeStat;
import kd.isc.iscb.platform.core.app.AppParameterServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.mq.MQUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class WebApiDispatcher {
    private static final String ISC_APIC_WEBAPI = "isc_apic_webapi";

    public static Object execute(String apiNumber, Map<String, Object> data) {
        return WebApiDispatcher.execute(apiNumber, data, new HashMap<String, Object>(), new HashMap<String, Object>(), null);
    }

    public static Object execute(String apiNumber, Map<String, Object> data, String realDataSourceNumber) {
        return WebApiDispatcher.execute(apiNumber, data, new HashMap<String, Object>(), new HashMap<String, Object>(), realDataSourceNumber);
    }

    public static ApiResult execute(String apiNumber, String caller, Map<String, Object> data) {
        ApiResult permResult = UserPermissionUtil.checkAPIPermByParam(ISC_APIC_WEBAPI, "4TAR7QONT/3J");
        if (!permResult.getSuccess()) {
            return permResult;
        }
        Map body = (Map)data.get("body");
        Map head = (Map)data.get("head");
        Map queryParam = (Map)data.get("queryParam");
        Object result = WebApiDispatcher.execute(apiNumber, (Map<String, Object>)body, (Map<String, Object>)head, (Map<String, Object>)queryParam);
        return ApiResult.success((Object)result);
    }

    public static Object execute(String apiNumber, Map<String, Object> body, Map<String, Object> head, Map<String, Object> queryParam) {
        WebApi cachedApi = WebApi.getByNumber(apiNumber);
        return WebApiDispatcher.execute(cachedApi, body, head, queryParam, null);
    }

    public static Object execute(String apiNumber, Map<String, Object> body, Map<String, Object> head, Map<String, Object> queryParam, String realDataSourceNumber) {
        WebApi cachedApi = WebApi.getByNumber(apiNumber);
        return WebApiDispatcher.execute(cachedApi, body, head, queryParam, realDataSourceNumber);
    }

    public static Object execute(WebApi webApi, Map<String, Object> data) {
        return WebApiDispatcher.execute(webApi, data, new HashMap<String, Object>(), new HashMap<String, Object>());
    }

    public static Object execute(WebApi webApi, Map<String, Object> body, Map<String, Object> head, Map<String, Object> queryParam, String realDataSourceNumber) {
        DynamicObject cfg = webApi.getCfg();
        DynamicObject log = WebApiDispatcher.loggerBegin(cfg, body, realDataSourceNumber);
        try {
            WebApiDispatcher.checkApiEnable(cfg);
            Object invoke = webApi.invoke(body, head, queryParam, realDataSourceNumber);
            WebApiDispatcher.invokeEnd(log, invoke, cfg);
            return invoke;
        }
        catch (Throwable e) {
            WebApiDispatcher.invokeEnd(log, e, cfg);
            throw e;
        }
    }

    public static Object executeWithConnection(WebApi webApi, Map<String, Object> body, Map<String, Object> head, Map<String, Object> queryParam, ConnectionWrapper connectionWrapper) {
        DynamicObject cfg = webApi.getCfg();
        DynamicObject link = connectionWrapper.getConfig();
        DynamicObject log = WebApiDispatcher.loggerBegin(cfg, body, link.getString("number"));
        try {
            WebApiDispatcher.checkApiEnable(cfg);
            Object invoke = webApi.invokeWithConnection(body, head, queryParam, connectionWrapper);
            WebApiDispatcher.invokeEnd(log, invoke, cfg);
            return invoke;
        }
        catch (Throwable e) {
            WebApiDispatcher.invokeEnd(log, e, cfg);
            throw e;
        }
    }

    public static Object execute(WebApi webApi, Map<String, Object> body, Map<String, Object> head, Map<String, Object> queryParam) {
        return WebApiDispatcher.execute(webApi, body, head, queryParam, null);
    }

    private static void checkApiEnable(DynamicObject cfg) {
        if (!D.x((Object)cfg.get("enable")) && AppParameterServiceHelper.isEnableControl()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528WebAPI\uff1a%1$s\uff08%2$s\uff09", (String)"WebApiDispatcher_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cfg.get("name"), cfg.get("number")));
        }
    }

    private static boolean needRecordLog(DynamicObject cfg) {
        return D.x((Object)cfg.get("record_log"));
    }

    private static DynamicObject loggerBegin(DynamicObject cfg, Map<String, Object> body, String realDataSourceNumber) {
        if (!WebApiDispatcher.needRecordLog(cfg)) {
            return null;
        }
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"isc_apic_log");
        log.set("id", (Object)IDService.get().genLongId());
        log.set("type", (Object)ISC_APIC_WEBAPI);
        log.set("api", cfg.getPkValue());
        log.set("start_time", (Object)new Timestamp(System.currentTimeMillis()));
        log.set("state", (Object)"R");
        String s = Json.toString(body);
        log.set("params", MQUtil.parseMsgDigest(s, D.s((Object)cfg.get("in_digest")), body));
        log.set("params_tag", (Object)StringUtil.trim((String)s, (int)IscApiSetting.getApiLogParamSize()));
        log.set("server", (Object)StringUtil.trim((String)NetUtil.getServerId(), (int)100));
        log.set("caller", (Object)RequestContext.get().getUserName());
        log.set("real_data_source", (Object)realDataSourceNumber);
        IscLogFactory.getLogService().saveLog(log);
        return log;
    }

    private static void invokeEnd(DynamicObject log, Object result, DynamicObject apiObj) {
        WebApiDispatcher.refreshCounter(result);
        if (log != null) {
            IscLogFactory.getLogService().updateLog(log, result, apiObj);
        }
        WebApiDispatcher.refreshInvokeStat(apiObj, result);
    }

    private static void refreshInvokeStat(DynamicObject apiObj, Object result) {
        boolean failed = result instanceof Throwable;
        ApiInvokeStat.createOrUpdateInvokeStat(apiObj, failed);
    }

    private static void refreshCounter(Object result) {
        IscRuntimeInfo info = IscRuntimeInfo.get();
        if (result instanceof Throwable) {
            info.incApiFailedCount();
        }
        info.incApiTotalCount();
    }
}

