/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.webapi;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.api.webapi.Const;
import kd.isc.iscb.platform.core.api.webapi.Param;
import kd.isc.iscb.platform.core.api.webapi.Util;
import kd.isc.iscb.platform.core.api.webapi.privacy.PrivacyQueryDto;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class WebReqBody
implements Const {
    private Map<String, Param> nameToParam = new LinkedHashMap<String, Param>();
    private long webApiId;

    public WebReqBody(DynamicObjectCollection webReqBody) {
        this.init(webReqBody);
    }

    public WebReqBody(long webApiId, DynamicObjectCollection webReqBody, Map<String, Object> privacyInfo) {
        this.webApiId = webApiId;
        this.init(webReqBody);
        this.initIsPrivacy(privacyInfo, this.nameToParam);
    }

    private void init(DynamicObjectCollection webReqBody) {
        HashMap<Long, Param> idToParam = new HashMap<Long, Param>(8);
        for (DynamicObject bodyEntry : webReqBody) {
            long id = D.l((Object)bodyEntry.get("id"));
            long pid = D.l((Object)bodyEntry.get("pid"));
            String name = D.s((Object)bodyEntry.get("req_b_param_name"));
            String desc = D.s((Object)bodyEntry.get("req_b_param_desc"));
            String value = D.s((Object)bodyEntry.get("req_b_param_value"));
            String type = D.s((Object)bodyEntry.get("req_b_param_type"));
            boolean isArray = D.x((Object)bodyEntry.get("req_b_param_is_array"));
            boolean required = D.x((Object)bodyEntry.get("req_b_param_required"));
            String exampleValue = D.s((Object)bodyEntry.get("req_b_param_example"));
            Param param = new Param(id, name, desc, type, isArray, required, exampleValue, value);
            if (pid > 0L) {
                Param parentParam = (Param)idToParam.get(pid);
                parentParam.addChildParam(param);
            } else {
                this.nameToParam.put(name, param);
            }
            idToParam.put(id, param);
        }
    }

    private void initIsPrivacy(Map<String, Object> privacyInfo, Map<String, Param> nameToParam) {
        if (privacyInfo == null) {
            return;
        }
        Map fields = (Map)privacyInfo.get("fields");
        for (Map.Entry<String, Param> entry : nameToParam.entrySet()) {
            String fieldName = entry.getKey();
            Param param = entry.getValue();
            String type = param.getType();
            Map field = (Map)fields.get(fieldName);
            if (field == null) continue;
            String strategyNum = D.s(field.get("privacy_num"));
            if (strategyNum != null) {
                PrivacyQueryDto privacyQueryDto = new PrivacyQueryDto(this.webApiId, fieldName, strategyNum);
                param.setPrivacyQueryDto(privacyQueryDto);
            }
            if (!param.isComplex()) continue;
            this.initIsPrivacy(field, param.getNameToChildParam());
        }
    }

    public Map<String, Object> getExampleParamMap() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        if (!this.nameToParam.isEmpty()) {
            for (Map.Entry<String, Param> entry : this.nameToParam.entrySet()) {
                String filedName = entry.getKey();
                Param param = entry.getValue();
                if (param.getParamValue() != null) continue;
                ret.put(filedName, param.getTestValue());
            }
        }
        return ret;
    }

    public Map<String, Object> eval(Map<String, Object> ctx, boolean omitEmptyParams) {
        try {
            return Util.evalParam(this.nameToParam, ctx, omitEmptyParams);
        }
        catch (Exception e) {
            throw new IscBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4f53\u53c2\u6570\u8f6c\u6362\u51fa\u9519\uff1a", (String)"WebReqBody_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.nameToParam);
    }

    public Map<String, Param> getNameToParam() {
        return Collections.unmodifiableMap(this.nameToParam);
    }
}

