/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.webapi;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.api.webapi.Const;
import kd.isc.iscb.platform.core.api.webapi.Param;
import kd.isc.iscb.platform.core.api.webapi.Util;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.except.IscBizException;

public class WebUrlParam
implements Const {
    private Map<String, Param> nameToParam = new LinkedHashMap<String, Param>();
    private List<Param> listTypeParams = new ArrayList<Param>();

    public WebUrlParam(DynamicObjectCollection urlParamEntries) {
        for (DynamicObject urlParamEntry : urlParamEntries) {
            String name = D.s((Object)urlParamEntry.get("url_param_name"));
            if (name == null) continue;
            long id = D.l((Object)urlParamEntry.get("id"));
            String desc = D.s((Object)urlParamEntry.get("url_param_desc"));
            String value = D.s((Object)urlParamEntry.get("url_param_value"));
            String type = D.s((Object)urlParamEntry.get("url_param_type"));
            boolean required = D.x((Object)urlParamEntry.get("url_param_required"));
            boolean isArray = D.x((Object)urlParamEntry.get("url_param_is_array"));
            Param param = new Param(id, name, desc, type, isArray, required, null, value);
            this.nameToParam.put(name, param);
            if (!isArray) continue;
            this.listTypeParams.add(param);
        }
    }

    public String getQueryString() {
        StringBuilder s = new StringBuilder();
        for (Map.Entry<String, Param> e : this.nameToParam.entrySet()) {
            Param param;
            if (s.length() > 0) {
                s.append('&');
            }
            if ((param = e.getValue()).isArray()) {
                s.append("#{tmp_").append(param.getName()).append('}');
                continue;
            }
            String key = e.getKey();
            s.append(this.encodeWhenNotContainPercent(key));
            s.append('=');
            String paramValue = param.getParamValue();
            if (paramValue == null) {
                s.append("#{").append("$urlParam.").append(param.getName()).append('}');
                continue;
            }
            if (paramValue.startsWith("$")) {
                s.append("#{").append(paramValue).append('}');
                continue;
            }
            s.append(this.encodeWhenNotContainPercent(paramValue));
        }
        return s.toString();
    }

    private String encodeWhenNotContainPercent(String sourceStr) {
        if (sourceStr.contains("%")) {
            return sourceStr;
        }
        return this.encode(sourceStr);
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw CommonError.INVALID_CHARSET.create((Throwable)e, new String[]{"UTF-8"});
        }
    }

    public Map<String, Object> eval(Map<String, Object> ctx) {
        try {
            return Util.evalParam(this.nameToParam, ctx, false);
        }
        catch (Exception e) {
            throw new IscBizException(ResManager.loadKDString((String)"URL\u53c2\u6570\u8f6c\u6362\u51fa\u9519\uff1a", (String)"WebUrlParam_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public String generateUrlScript(String urlPath) {
        return this.getListVarDefineScript() + this.getUrlDefineScript(urlPath);
    }

    public String generateRelativePathScript(String urlPath) {
        String urlPathAndQueryString = this.mergeUrlPathAndQueryString(urlPath, this.getQueryString());
        return this.getListVarDefineScript() + "var relativePath = $$(\"" + urlPathAndQueryString + "\");\n";
    }

    private String getUrlDefineScript(String urlPath) {
        String url = "#{$website}" + this.mergeUrlPathAndQueryString(urlPath, this.getQueryString());
        return "var url = $$(\"" + url + "\");\n";
    }

    private String mergeUrlPathAndQueryString(String urlPath, String queryString) {
        String mergeStr = "";
        if (urlPath != null) {
            mergeStr = mergeStr + urlPath;
        }
        if (queryString != null && queryString.length() > 0) {
            mergeStr = mergeStr + "?" + queryString;
        }
        return mergeStr;
    }

    private String getListVarDefineScript() {
        StringBuilder sb = new StringBuilder();
        String formatStr = "var tmp_%1$s = ConvertToUrlEncodeString(\"%1$s\",$urlParam.%1$s);\n";
        for (Param listTypeParam : this.listTypeParams) {
            String varScript = String.format(formatStr, listTypeParam.getName());
            sb.append(varScript);
        }
        return sb.toString();
    }

    public Map<String, Param> getNameToParam() {
        return Collections.unmodifiableMap(this.nameToParam);
    }

    public Map<String, Object> getExampleParamMap() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        if (!this.nameToParam.isEmpty()) {
            for (Map.Entry<String, Param> entry : this.nameToParam.entrySet()) {
                String filedName = entry.getKey();
                Param param = entry.getValue();
                String paramValue = param.getParamValue();
                if (paramValue != null) continue;
                ret.put(filedName, param.getTestValue());
            }
        }
        return ret;
    }
}

