/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.webapi.multipart;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.api.quick.FormItem;
import kd.isc.iscb.platform.core.api.quick.HttpItem;

public class MultipartUtil {
    private static final String ISC_SCRIPT_FORMAT = "var relativePath = \"%s\";\nvar httpMethod = \"%s\";\nvar header = %s;\nvar data = %s;\nvar result = Http.sendMultipart($cn, relativePath, httpMethod, data, \"UTF-8\", null, header).result;";
    private static final String ISC_SCRIPT_FORMAT2 = "var relativePath = \"%s\";\nvar httpMethod = \"%s\";\nvar header = %s;\nvar data = %s;\nvar result = Http.sendMultipart($cn, relativePath, httpMethod, data, \"UTF-8\", null, header);";

    public static String generateIscScript(HttpItem httpItem, boolean withResult) {
        String formatStr = withResult ? ISC_SCRIPT_FORMAT : ISC_SCRIPT_FORMAT2;
        return String.format(formatStr, MultipartUtil.getRelativePath(httpItem.getUrl()), httpItem.getHttpMethod(), JSON.toJSONString(httpItem.getHeaders(), (boolean)true), MultipartUtil.generateDataString(httpItem.getFormItemList()));
    }

    private static String getRelativePath(String url) {
        int i = url.indexOf("://");
        if (i > 0) {
            int j = url.indexOf(47, i + 3);
            if (j >= 0) {
                return url.substring(j);
            }
            return "";
        }
        return url;
    }

    private static String generateDataString(List<FormItem> formItemList) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\r\n");
        for (int i = 0; i < formItemList.size(); ++i) {
            if (i > 0) {
                sb.append(',');
                sb.append("\r\n");
            }
            FormItem formItem = formItemList.get(i);
            sb.append('\t');
            sb.append(formItem.getKey());
            sb.append(':');
            sb.append(formItem.genValueForIscScript());
        }
        sb.append("\r\n}");
        return sb.toString();
    }

    public static String generateCurlScript(HttpItem httpItem) {
        if (httpItem != null) {
            StringBuilder sb = new StringBuilder("curl");
            sb.append(" -X ").append(httpItem.getHttpMethod()).append(" \\\r\n ");
            sb.append('\'').append(httpItem.getUrl()).append("' \\\r\n");
            for (Map.Entry<String, Object> entry : httpItem.getHeaders().entrySet()) {
                sb.append("-H ").append('\'').append(entry.getKey()).append(": ").append(entry.getValue()).append("' \\\r\n");
            }
            if (httpItem.bodyIsFormData()) {
                List<FormItem> formItemList = httpItem.getFormItemList();
                for (FormItem formItem : formItemList) {
                    sb.append("--form ").append('\'').append(formItem.getKey()).append('=').append(formItem.genValueForCurl()).append("' \\\r\n");
                }
            }
            return sb.toString();
        }
        return "";
    }
}

