/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.apic;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.apic.ApiLogService;
import kd.isc.iscb.platform.core.apic.IscApiSetting;
import kd.isc.iscb.platform.core.dc.mq.MQUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class DefaultLogService
implements ApiLogService {
    public static final DefaultLogService INSTANCE = new DefaultLogService();

    private DefaultLogService() {
    }

    @Override
    public void saveLog(DynamicObject log) {
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLog(DynamicObject log, Object result, DynamicObject apiObj) {
        String sql = "UPDATE t_iscb_apic_log SET fresult=?,fresult_tag=?,fend_time=?,fstate=? WHERE fid=?";
        ArrayList<Object> values = new ArrayList<Object>(5);
        ArrayList<Integer> types = new ArrayList<Integer>(5);
        this.prepareParams(result, values, types, log, apiObj);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private void prepareParams(Object result, List<Object> values, List<Integer> types, DynamicObject log, DynamicObject apiObj) {
        String s;
        boolean failed = result instanceof Throwable;
        String string = s = failed ? StringUtil.toString((Throwable)((Throwable)result)) : Json.toString((Object)result);
        if (failed) {
            values.add(StringUtil.trim((String)s, (int)50));
        } else {
            values.add(MQUtil.parseMsgDigest(s, D.s((Object)apiObj.get("out_digest"))));
        }
        types.add(12);
        values.add(StringUtil.trim((String)s, (int)IscApiSetting.getApiLogParamSize()));
        types.add(12);
        values.add(new Timestamp(System.currentTimeMillis()));
        types.add(93);
        values.add(failed ? "F" : "S");
        types.add(12);
        values.add(log.getLong("id"));
        types.add(-5);
    }
}

