/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.apic;

import java.sql.Timestamp;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.apic.ApiLogService;
import kd.isc.iscb.platform.core.apic.IscApiSetting;
import kd.isc.iscb.platform.core.dc.mq.MQUtil;
import kd.isc.iscb.platform.core.log.es.EsLogUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class EsLogService
implements ApiLogService {
    public static EsLogService INSTANCE = new EsLogService();

    private EsLogService() {
    }

    @Override
    public void saveLog(DynamicObject log) {
        EsLogUtil.saveLogToEs(log);
    }

    @Override
    public void updateLog(DynamicObject log, Object result, DynamicObject apiObj) {
        if (result instanceof Throwable) {
            log.set("state", (Object)"F");
            String s = StringUtil.toString((Throwable)((Throwable)result));
            log.set("result", (Object)StringUtil.trim((String)s, (int)50));
            log.set("result_tag", (Object)StringUtil.trim((String)s, (int)IscApiSetting.getApiLogParamSize()));
        } else {
            log.set("state", (Object)"S");
            String s = Json.toString((Object)result);
            log.set("result", MQUtil.parseMsgDigest(s, D.s((Object)apiObj.get("out_digest"))));
            log.set("result_tag", (Object)StringUtil.trim((String)s, (int)IscApiSetting.getApiLogParamSize()));
        }
        log.set("end_time", (Object)new Timestamp(System.currentTimeMillis()));
        EsLogUtil.saveLogToEs(log);
    }
}

