/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.apic;

import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.cache.CacheableObjectFactory;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.util.misc.mem.ObjectSizeIgnored;

public class IscApiCaller
implements ObjectSizeIgnored {
    private String number;
    private long id;

    public long getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public static IscApiCaller get(String number) {
        return CacheableObjectManager.getByNumber(IscApiCaller.class, number);
    }

    private IscApiCaller(long id, String number) {
        this.id = id;
        this.number = number;
    }

    static {
        CacheableObjectManager.registerFactory(new CacheableObjectFactory<IscApiCaller>(){

            @Override
            public String entityType() {
                return "isc_apic_caller";
            }

            @Override
            public IscApiCaller create(DynamicObject cfg) {
                long id = cfg.getLong("id");
                String number = cfg.getString("number");
                return new IscApiCaller(id, number);
            }

            @Override
            public Class<IscApiCaller> target() {
                return IscApiCaller.class;
            }
        });
    }
}

