/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.apic;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.apic.IscApiParam;
import kd.isc.iscb.platform.core.trace.TraceUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.mem.ObjectSizeIgnored;

public abstract class IscApiMeta
implements ObjectSizeIgnored {
    private static final String OMIT_EMPTY_PARAMS = "omit_empty_params";
    private long id;
    private String number;
    private String type;
    private boolean auth_required;
    private boolean record_log;
    private boolean enabled;
    private DynamicObject cfg;
    private boolean disableTrace;
    private boolean omitEmptyParams;

    protected IscApiMeta(DynamicObject cfg) {
        this.type = cfg.getDataEntityType().getName();
        this.id = cfg.getLong("id");
        this.number = cfg.getString("number");
        this.record_log = cfg.getBoolean("record_log");
        this.auth_required = cfg.getBoolean("auth_required");
        this.enabled = cfg.getBoolean("enable");
        this.cfg = cfg;
        this.disableTrace = TraceUtil.isDisableTrace(cfg);
        this.omitEmptyParams = cfg.containsProperty(OMIT_EMPTY_PARAMS) && D.x((Object)cfg.get(OMIT_EMPTY_PARAMS));
    }

    public boolean isDisableTrace() {
        return this.disableTrace;
    }

    public DynamicObject getDynamicObject() {
        return this.cfg;
    }

    public long getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public String getType() {
        return this.type;
    }

    public boolean isAuthRequired() {
        return this.auth_required;
    }

    public boolean isRecordLog() {
        return this.record_log;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean shouldOmitEmptyParams() {
        return this.omitEmptyParams;
    }

    public abstract IscApiParam getInputs();

    public abstract IscApiParam getOutputs();

    public abstract Object invoke(Map<String, Object> var1);
}

