/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.apic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.DataTypes;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.Script;

public class IscApiParam
implements DataType {
    private List<Field> fields = new ArrayList<Field>();
    private Map<String, Integer> mapping = new HashMap<String, Integer>();

    public IscApiParam(List<Field> fields) {
        for (Field f : fields) {
            String name = f.name;
            String dataType = f.dataType;
            String title = f.title;
            Object defaultValue = f.defaultValue;
            boolean is_array = f.is_array;
            boolean required = f.required;
            this.add(name, dataType, title, is_array, required, defaultValue);
        }
    }

    public int fieldCount() {
        return this.fields.size();
    }

    public List<Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Field getField(int index) {
        return this.fields.get(index);
    }

    public int findField(String name) {
        Integer index = this.mapping.get(name);
        return index == null ? -1 : index;
    }

    private void add(String name, String dataType, String title, boolean is_array, boolean required, Object defaultValue) {
        int dotIndex = name.indexOf(46);
        if (dotIndex < 0) {
            if (this.mapping.putIfAbsent(name, this.fields.size()) == null) {
                Field field = new Field(name, dataType, title, is_array, required, defaultValue);
                this.fields.add(field);
            }
        } else {
            String key = name.substring(0, dotIndex);
            Integer index = this.mapping.get(key);
            if (index == null) {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u672a\u58f0\u660e\u5b57\u6bb5\uff08%s\uff09\u7684\u7c7b\u578b\uff0c\u4ece\u4e0a\u4e0b\u6587\u63a8\u65ad\u8be5\u5b57\u6bb5\u5e94\u8be5\u7ed3\u6784\u6216\u5206\u5f55\u7c7b\u578b\u3002", (String)"IscApiParam_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key));
            }
            Field s = this.fields.get(index);
            if (s.schema != null) {
                s.schema.add(name.substring(dotIndex + 1), dataType, title, is_array, required, defaultValue);
            } else {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\uff08%1$s\uff09\u662f\uff08%2$s\uff09\u6570\u636e\u7c7b\u578b\uff0c\u4e0d\u80fd\u5305\u542b\u4e0b\u7ea7\u5b57\u6bb5\u3002", (String)"IscApiParam_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), s.name, s.dataType));
            }
        }
    }

    public String toString() {
        return this.fields.toString();
    }

    private IscApiParam() {
    }

    public Map<String, Object> narrow(Object outerValue) {
        if (outerValue == null) {
            return null;
        }
        Map map = (Map)outerValue;
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>(map.size());
        for (Map.Entry e : map.entrySet()) {
            String name = (String)e.getKey();
            Object value = e.getValue();
            int index = this.findField(name);
            if (index >= 0) {
                try {
                    value = this.getField(index).narrow(value);
                }
                catch (Exception ex) {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\uff08%1$s\uff09\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff1a%2$s", (String)"IscApiParam_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name, ex.getMessage() == null ? ex.toString() : ex.getMessage()), (Throwable)ex);
                }
            }
            obj.put(name, value);
        }
        return obj;
    }

    public Object forJson(Object object) {
        return object;
    }

    public Object forSave(Object innerValue) {
        throw new UnsupportedOperationException();
    }

    public static class Field
    implements Comparable<Field> {
        private String name;
        private String dataType;
        private String title;
        private boolean is_array;
        private boolean required;
        private Object defaultValue;
        private IscApiParam schema;
        private volatile DataType dt;

        public Field(String name, String dataType, String title, boolean is_array, boolean required, Object defaultValue) {
            this.name = name;
            this.dataType = dataType;
            this.title = title;
            this.is_array = is_array;
            this.required = required;
            if ("STRUCT".equals(dataType)) {
                this.schema = new IscApiParam();
            }
            if (defaultValue instanceof String && (is_array || this.schema != null)) {
                defaultValue = Script.parseJson((String)((String)defaultValue));
            }
            this.defaultValue = defaultValue;
        }

        public Object narrow(Object value) {
            DataType dt = this.dt;
            if (dt == null) {
                dt = this.createDataType();
            }
            return dt.narrow(value);
        }

        private DataType createDataType() {
            String s = this.dataType;
            IscApiParam dt = "STRUCT".equals(s) ? this.schema : DataTypes.get((String)s);
            if (this.is_array) {
                dt = DataTypes.listType((DataType)dt);
            }
            this.dt = dt;
            return dt;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isArray() {
            return this.is_array;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public IscApiParam getSchema() {
            return this.schema;
        }

        public String getDataType() {
            return this.dataType;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Field o) {
            return this.name.compareTo(o.name);
        }
    }
}

