/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.apic;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.WebApiContext;
import kd.bos.openapi.api.model.OpenApiRequest;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.isc.iscb.platform.core.apic.ExecuteServiceFlow;
import kd.isc.iscb.platform.core.apic.InvokeAPI;
import kd.isc.iscb.platform.core.apic.IscApiMeta;
import kd.isc.iscb.platform.core.apic.IscApiParam;
import kd.isc.iscb.platform.core.apic.IscApicUtil;
import kd.isc.iscb.platform.core.cache.CacheableObjectFactory;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.self.MicroServiceInvoker;
import kd.isc.iscb.platform.core.connector.self.MicroServiceInvoker2;
import kd.isc.iscb.platform.core.connector.wechat.CallWechatByCloudPlatform;
import kd.isc.iscb.platform.core.consume.IscConsumeInfo;
import kd.isc.iscb.platform.core.fn.ext.Functions;
import kd.isc.iscb.platform.core.fn.openapi.InvokeOpenApi;
import kd.isc.iscb.platform.core.fn.openapi.OpenAPIToolKit;
import kd.isc.iscb.platform.core.fn.openapi.QueryOpenApi;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.sf.func.InvokeService;
import kd.isc.iscb.util.connector.s.ExecuteBatch;
import kd.isc.iscb.util.connector.s.ExecuteCall;
import kd.isc.iscb.util.connector.s.ExecuteUpdate;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.context.Context;
import kd.isc.iscb.util.script.core.Reference;

public class ScriptApiMeta
extends IscApiMeta {
    private static final InvokeAPI INVOKE_API = new InvokeAPI();
    private static final ExecuteUpdate EXECUTE_UPDATE = new ExecuteUpdate(false);
    private static final ExecuteBatch EXECUTE_BATCH = new ExecuteBatch();
    private static final MicroServiceInvoker INVOKE_MICRO_SERVICE = new MicroServiceInvoker();
    private static final MicroServiceInvoker2 INVOKE_MICRO_SERVICE_2 = new MicroServiceInvoker2();
    private static final ExecuteServiceFlow EXECUTE_SERVICE_FLOW = new ExecuteServiceFlow();
    private static final InvokeOpenApi CALL_OPEN_API_SDK_SERVICE = new InvokeOpenApi();
    private static final QueryOpenApi QUERY_OPEN_API_SDK_SERVICE = new QueryOpenApi();
    private static final OpenAPIToolKit OPEN_API = new OpenAPIToolKit();
    private static final ExecuteCall EXECUTE_CALL = new ExecuteCall();
    private static final InvokeService INVOKE_SERVICE = new InvokeService();
    private static final CallWechatByCloudPlatform CallWechatByCloudPlatform = new CallWechatByCloudPlatform();
    private IscApiParam inputs;
    private IscApiParam outputs;
    private Script script;
    private static final ThreadLocal<WebApiContext> WEB_CONTEXT;

    private ScriptApiMeta(DynamicObject cfg) {
        super(cfg);
        this.inputs = IscApicUtil.getInputSchema(cfg);
        this.outputs = IscApicUtil.getOutputSchema(cfg);
        String script = cfg.getString("script_tag");
        Map<String, Object> ctx = this.createScriptContext(cfg);
        this.script = Script.compile((String)script, ctx);
    }

    private Map<String, Object> createScriptContext(DynamicObject cfg) {
        Map<String, Object> ctx = IscApicUtil.getResource(cfg);
        ctx.put(INVOKE_API.name(), INVOKE_API);
        ctx.put(EXECUTE_UPDATE.name(), EXECUTE_UPDATE);
        ctx.put(EXECUTE_BATCH.name(), EXECUTE_BATCH);
        ctx.put(INVOKE_MICRO_SERVICE.name(), INVOKE_MICRO_SERVICE);
        ctx.put(INVOKE_MICRO_SERVICE_2.name(), INVOKE_MICRO_SERVICE_2);
        ctx.put(EXECUTE_SERVICE_FLOW.name(), EXECUTE_SERVICE_FLOW);
        ctx.put(CALL_OPEN_API_SDK_SERVICE.name(), CALL_OPEN_API_SDK_SERVICE);
        ctx.put(QUERY_OPEN_API_SDK_SERVICE.name(), QUERY_OPEN_API_SDK_SERVICE);
        ctx.put(OPEN_API.name(), (Object)OPEN_API);
        ctx.put(EXECUTE_CALL.name(), EXECUTE_CALL);
        ctx.put(INVOKE_SERVICE.name(), INVOKE_SERVICE);
        ctx.put(CallWechatByCloudPlatform.name(), CallWechatByCloudPlatform);
        this.appendParams(ctx, this.inputs);
        this.appendParams(ctx, this.outputs);
        return ctx;
    }

    private void appendParams(Map<String, Object> ctx, IscApiParam inputs) {
        for (int i = 0; i < inputs.fieldCount(); ++i) {
            String name = inputs.getField(i).getName();
            ctx.put(name, Reference.create((String)name));
        }
    }

    public Script getScript() {
        return this.script;
    }

    public static ScriptApiMeta get(long id) {
        return CacheableObjectManager.get(ScriptApiMeta.class, id);
    }

    public static ScriptApiMeta getByNumber(String number) {
        return CacheableObjectManager.getByNumber(ScriptApiMeta.class, number);
    }

    @Override
    public IscApiParam getInputs() {
        return this.inputs;
    }

    @Override
    public IscApiParam getOutputs() {
        return this.outputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Map<String, Object> params) {
        HashMap<String, Object> ctx = this.getInputs().narrow(params);
        if (ctx == null) {
            ctx = new HashMap<String, Object>(16);
        }
        long start = System.currentTimeMillis();
        try {
            DynamicObject cfg = this.getDynamicObject();
            ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense(cfg));
            try {
                this.script.eval((Context)new ScriptApiContext(ctx));
            }
            finally {
                ConnectionManager.popResLicense();
            }
            Object object = this.getResult(ctx);
            return object;
        }
        finally {
            IscConsumeInfo.recordOnce(start, this.getDynamicObject(), ResManager.loadKDString((String)"\u3010API\u811a\u672c\u3011", (String)"ScriptApiMeta_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            WEB_CONTEXT.remove();
        }
    }

    public static void setWebContext(WebApiContext ctx) {
        WEB_CONTEXT.set(ctx);
    }

    public static void removeWebContext() {
        WEB_CONTEXT.remove();
    }

    private Object getResult(Map<String, Object> ctx) {
        IscApiParam output = this.getOutputs();
        switch (output.fieldCount()) {
            case 1: {
                return this.getSingleValue(ctx, output.getField(0));
            }
            case 0: {
                return null;
            }
        }
        return this.getMultiValues(ctx, output);
    }

    private Object getMultiValues(Map<String, Object> ctx, IscApiParam output) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(output.fieldCount());
        int j = output.fieldCount();
        for (int i = 0; i < j; ++i) {
            IscApiParam.Field field = output.getField(i);
            Object value = this.getSingleValue(ctx, field);
            result.put(field.getName(), value);
        }
        return result;
    }

    private Object getSingleValue(Map<String, Object> ctx, IscApiParam.Field field) {
        Object value = ctx.get(field.getName());
        return field.narrow(value);
    }

    static {
        CacheableObjectManager.registerFactory(new CacheableObjectFactory<ScriptApiMeta>(){

            @Override
            public String entityType() {
                return "isc_apic_script";
            }

            @Override
            public ScriptApiMeta create(DynamicObject cfg) {
                return new ScriptApiMeta(cfg);
            }

            @Override
            public Class<ScriptApiMeta> target() {
                return ScriptApiMeta.class;
            }
        });
        WEB_CONTEXT = new ThreadLocal();
        Functions.init();
    }

    private static class ScriptApiContext
    implements Context {
        private Map<String, Object> params;

        private ScriptApiContext(Map<String, Object> params) {
            this.params = params;
        }

        public Object get(String property) {
            Object value = this.params.get(property);
            if (value != null) {
                return value;
            }
            if ("#request".equals(property)) {
                return this.getRequest();
            }
            if ("#params".equals(property)) {
                return this.params;
            }
            return null;
        }

        private Object getRequest() {
            WebApiContext ctx = (WebApiContext)WEB_CONTEXT.get();
            if (ctx != null) {
                return ctx;
            }
            OpenApiRequest req = ServiceApiContext.getRequest();
            if (req != null) {
                return req;
            }
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u5f53\u524d\u81ea\u5b9a\u4e49\u4e0a\u4e0b\u6587\u73af\u5883\u4e0d\u80fd\u8bbf\u95ee #request\u3002", (String)"ScriptApiMeta_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }

        public boolean set(String property, Object value) {
            this.params.put(property, value);
            return true;
        }

        public boolean contains(String property) {
            if (this.params.containsKey(property)) {
                return true;
            }
            if ("#request".equals(property)) {
                return true;
            }
            return "#params".equals(property);
        }
    }
}

