/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.apis;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.apis.ApiInvokeStatInfo;
import kd.isc.iscb.platform.core.apis.ApiState;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.db.DbUtil;

public class ApiInvokeStat {
    private static Log logger = LogFactory.getLog(ApiInvokeStat.class);
    private static ReadLockFreeMap<String, ReadLockFreeMap<Long, ApiInvokeStatInfo>> localCache = new ReadLockFreeMap(20);

    public static Map<Long, ApiInvokeStatInfo> initTimerTask() {
        String account = ApiInvokeStat.getAccount();
        ReadLockFreeMap accountApiInfo = (ReadLockFreeMap)localCache.get((Object)account);
        if (accountApiInfo == null) {
            accountApiInfo = (ReadLockFreeMap)localCache.putIfAbsent((Object)account, (Object)new ReadLockFreeMap());
            ScheduleManager.submit(ApiInvokeStat.refreshCountJob((Map<Long, ApiInvokeStatInfo>)accountApiInfo), 300);
        }
        return accountApiInfo;
    }

    private static Task refreshCountJob(final Map<Long, ApiInvokeStatInfo> accountApiInfo) {
        return new LightTask(){
            private String id = UUID.randomUUID().toString();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ApiInvokeStat.initTimerTask() == accountApiInfo) {
                    try {
                        ArrayList<List> updateParams = new ArrayList<List>(20);
                        for (Map.Entry entry : accountApiInfo.entrySet()) {
                            List param = ApiInvokeStat.getUpdateParam(entry);
                            if (param.size() <= 0) continue;
                            updateParams.add(param);
                        }
                        if (updateParams.size() > 0) {
                            ApiInvokeStat.updateCount(updateParams);
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u5b9a\u65f6\u66f4\u65b0API\u63a5\u53e3\u8c03\u7528\u7edf\u8ba1\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage(), (Throwable)e);
                    }
                    finally {
                        ScheduleManager.submit((Task)this, 300);
                    }
                }
            }

            @Override
            public String getId() {
                return this.id;
            }
        };
    }

    private static List<Object> getUpdateParam(Map.Entry<Long, ApiInvokeStatInfo> entry) {
        ApiInvokeStatInfo apiInvokeInfo = entry.getValue();
        if (apiInvokeInfo.isChanged()) {
            long totalCount = apiInvokeInfo.getAndResetTotalCount();
            long failedCount = apiInvokeInfo.getAndResetFailedCount();
            long successCount = totalCount - failedCount;
            Timestamp updateTime = new Timestamp(System.currentTimeMillis());
            Timestamp lastInvokeTime = apiInvokeInfo.getLastInvokeTime();
            return Arrays.asList(updateTime, apiInvokeInfo.getApiType(), apiInvokeInfo.getApiNumber(), apiInvokeInfo.getApiName(), totalCount, successCount, failedCount, lastInvokeTime, entry.getKey());
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateCount(List<List<Object>> updateParams) {
        block15: {
            String account = ApiInvokeStat.getAccount();
            try (DLock lock = DLock.create((String)("/isc/iscb/api_invoke_stat/" + account)).fastMode();){
                if (!lock.tryLock()) break block15;
                String batchUpdateSql = "UPDATE T_ISC_API_INVOKE_STAT SET FUPDATE_TIME = ?,FAPI_TYPE = ?,FAPI_NUMBER = ?,FAPI_NAME = ?,FINVOKE_COUNT=FINVOKE_COUNT+ ?,FSUCCESS_COUNT=FSUCCESS_COUNT+ ?,FFAILED_COUNT=FFAILED_COUNT+ ?,FLAST_INVOKE_TIME = ? WHERE FID = ?";
                List<Integer> types = Arrays.asList(93, 12, 12, 12, -5, -5, -5, 93, -5);
                Connection cn = ApiInvokeStat.getConnection();
                try {
                    int[] ints = DbUtil.executeBatch((Connection)cn, (String)batchUpdateSql, updateParams, types);
                    ApiInvokeStat.createInvokeStat(cn, updateParams, ints);
                }
                finally {
                    DbUtil.close((Connection)cn, (boolean)true);
                }
            }
        }
    }

    private static void createInvokeStat(Connection cn, List<List<Object>> updateParams, int[] ints) {
        ArrayList<List<Object>> insertParams = new ArrayList<List<Object>>(20);
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] != 0) continue;
            List<Object> param = updateParams.get(i);
            insertParams.add(ApiInvokeStat.getInsertParams(param));
        }
        if (insertParams.size() > 0) {
            ApiInvokeStat.createStat(cn, insertParams);
        }
    }

    private static void createStat(Connection cn, List<List<Object>> insertParams) {
        String batchInsertSql = "INSERT INTO T_ISC_API_INVOKE_STAT (FUPDATE_TIME,FAPI_TYPE,FAPI_NUMBER,FAPI_NAME,FINVOKE_COUNT,FSUCCESS_COUNT,FFAILED_COUNT,FLAST_INVOKE_TIME,FID,FCREATE_TIME,FAPI_STATE) VALUES (?,?,?,?,?,?,?,?,?,?,1)";
        List<Integer> insetTypes = Arrays.asList(93, 12, 12, 12, -5, -5, -5, 93, -5, 93, 12);
        DbUtil.executeBatch((Connection)cn, (String)batchInsertSql, insertParams, insetTypes);
    }

    private static List<Object> getInsertParams(List<Object> updateParam) {
        ArrayList<Object> insertParam = new ArrayList<Object>(10);
        insertParam.addAll(updateParam);
        Object updateTime = updateParam.get(0);
        insertParam.add(updateTime);
        return insertParam;
    }

    public static void createOrUpdateInvokeStat(DynamicObject apiObj, boolean failed) {
        try {
            long apiId;
            ApiInvokeStatInfo statInfo;
            String account = ApiInvokeStat.getAccount();
            Map accountApiInfo = (Map)localCache.get((Object)account);
            if (accountApiInfo == null) {
                accountApiInfo = (Map)localCache.putIfAbsent((Object)account, (Object)new ReadLockFreeMap());
            }
            if ((statInfo = (ApiInvokeStatInfo)accountApiInfo.get(apiId = ApiInvokeStat.getInvokeStatId(apiObj))) == null) {
                statInfo = accountApiInfo.putIfAbsent(apiId, new ApiInvokeStatInfo(apiObj));
            }
            statInfo.incTotalCount();
            if (failed) {
                statInfo.incFailedCount();
            }
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0API\u8c03\u7528\u6b21\u6570\u7edf\u8ba1\u8ba1\u6570\u5668\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public static void createOrUpdateInvokeStat(DynamicObject apiObject, ApiState state) {
        long invokeStatId = ApiInvokeStat.getInvokeStatId(apiObject);
        if (!ApiInvokeStat.isExistInvokeState(invokeStatId)) {
            ApiInvokeStat.createInvokeStat(apiObject, invokeStatId, state);
        } else {
            ApiInvokeStat.updateState(invokeStatId, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createInvokeStat(DynamicObject apiObject, long invokeStatId, ApiState state) {
        String insertSql = "INSERT INTO T_ISC_API_INVOKE_STAT (FID,FAPI_TYPE,FAPI_NUMBER,FAPI_NAME,FINVOKE_COUNT,FSUCCESS_COUNT,FFAILED_COUNT,FAPI_STATE,FCREATE_TIME,FUPDATE_TIME) VALUES(?,?,?,?,0,0,0,?,?,?)";
        String apiType = apiObject.getDataEntityType().getName();
        String apiName = apiObject.getString("name");
        String apiNumber = apiObject.getString("number");
        Timestamp now = new Timestamp(System.currentTimeMillis());
        List<Object> values = Arrays.asList(invokeStatId, apiType, apiNumber, apiName, state.getState(), now, now);
        List<Integer> types = Arrays.asList(-5, 12, 12, 12, 12, 93, 93);
        Connection cn = ApiInvokeStat.getConnection();
        try {
            DbUtil.executeUpdate((Connection)cn, (String)insertSql, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isExistInvokeState(long invokeStatId) {
        String selectSql = "SELECT COUNT(FID) FROM T_ISC_API_INVOKE_STAT WHERE FID = ?";
        List<Long> values = Collections.singletonList(invokeStatId);
        List<Integer> types = Collections.singletonList(-5);
        Connection cn = ApiInvokeStat.getConnection();
        long count = 0L;
        try {
            count = DbUtil.executeCount((Connection)cn, (String)selectSql, values, types);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
        return count > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateState(long invokeStatId, ApiState state) {
        String updateSql = "UPDATE T_ISC_API_INVOKE_STAT SET FAPI_STATE = ?,FUPDATE_TIME = ? WHERE FID = ?";
        List<Object> values = Arrays.asList(state.getState(), new Timestamp(System.currentTimeMillis()), invokeStatId);
        List<Integer> types = Arrays.asList(12, 93, -5);
        Connection cn = ApiInvokeStat.getConnection();
        try {
            DbUtil.executeUpdate((Connection)cn, (String)updateSql, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private static Connection getConnection() {
        return TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
    }

    private static long getInvokeStatId(DynamicObject apiObj) {
        return apiObj.getLong("id");
    }

    private static String getAccount() {
        return RequestContext.get().getAccountId();
    }
}

