/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.apis;

import java.sql.Timestamp;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.dataentity.entity.DynamicObject;

public class ApiInvokeStatInfo {
    private AtomicLong api_invoke_count = new AtomicLong(0L);
    private AtomicLong api_invoke_failed = new AtomicLong(0L);
    private AtomicBoolean changed = new AtomicBoolean(false);
    private Timestamp last_invoke_time = null;
    private String api_type;
    private String api_number;
    private String api_name;

    public ApiInvokeStatInfo(DynamicObject apiObject) {
        this.api_type = apiObject.getDataEntityType().getName();
        this.api_number = apiObject.getString("number");
        this.api_name = apiObject.getString("name");
    }

    public void incTotalCount() {
        this.api_invoke_count.incrementAndGet();
        this.changed.getAndSet(true);
        this.last_invoke_time = new Timestamp(System.currentTimeMillis());
    }

    public long getAndResetTotalCount() {
        return this.api_invoke_count.getAndSet(0L);
    }

    public void incFailedCount() {
        this.api_invoke_failed.incrementAndGet();
    }

    public long getAndResetFailedCount() {
        return this.api_invoke_failed.getAndSet(0L);
    }

    public boolean isChanged() {
        return this.changed.getAndSet(false);
    }

    public Timestamp getLastInvokeTime() {
        return this.last_invoke_time;
    }

    public String getApiType() {
        return this.api_type;
    }

    public String getApiNumber() {
        return this.api_number;
    }

    public String getApiName() {
        return this.api_name;
    }
}

