/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.article;

import com.alibaba.fastjson.JSON;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.article.SyncCommunityArticleJobFactory;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class SyncCommunityArticleJob
implements Job {
    private static final Log LOGGER = LogFactory.getLog(SyncCommunityArticleJob.class);
    public static final SyncCommunityArticleJobFactory SYNC_FACTORY = new SyncCommunityArticleJobFactory();
    private String title;
    private String param;
    private static final String ISC_ARTICLE_CATEGORY = "isc_article_category";
    private static final String ISC_COMMUNITY_ARTICLE = "isc_community_article";
    private volatile int total = 0;
    private final AtomicInteger success = new AtomicInteger(0);
    private final AtomicInteger failed = new AtomicInteger(0);

    public SyncCommunityArticleJob(String title, String param) {
        this.title = title;
        this.param = param;
    }

    @Override
    public String getParam() {
        return this.param;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return SYNC_FACTORY;
    }

    @Override
    public long getOwnerId() {
        return Math.abs(Hash.mur64((byte[])"SyncCommunityArticleJob".getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public synchronized Job.Progress getRealtimeProgress() {
        MultiLangEnumBridge multiLangEnumBridge = new MultiLangEnumBridge("\u540c\u6b65\u4e2d\uff0c\u603b\u8ba1\uff1a%1$s\uff0c\u6210\u529f\uff1a%2$s\uff0c \u5931\u8d25\uff1a%3$s", "SyncCommunityArticleJob_12", "isc-iscb-platform-core");
        String s = String.format(multiLangEnumBridge.loadKDString(), this.total, this.success.get(), this.failed.get());
        return new Job.Progress(this.total, this.success.get() + this.failed.get(), s);
    }

    @Override
    public String getJobSummary() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5b8c\u6210\uff0c\u603b\u6570\uff1a%1$s\uff1b\u6210\u529f\uff1a%2$s", (String)"SyncCommunityArticleJob_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.success.get() + this.failed.get(), this.success));
        if (this.failed.get() > 0) {
            builder.append('\uff1b');
            builder.append(String.format(ResManager.loadKDString((String)"\uff1b\u5931\u8d25\uff1a%s", (String)"SyncCommunityArticleJob_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.failed));
        }
        return builder.toString();
    }

    @Override
    public void run() {
        try {
            this.syncData();
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u793e\u533a\u96c6\u6210\u4e91\u5e16\u5b50\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"SyncCommunityArticleJob_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.getCascadeMessage((Throwable)e)), (Throwable)e);
        }
    }

    private void syncData() {
        HashMap<Long, String> categoryinfo = new HashMap<Long, String>();
        int page = 0;
        boolean last = false;
        while (!last) {
            Map<String, Object> result;
            if ((result = this.queryArticlesFromCommunity(++page)) == null) continue;
            last = D.x((Object)result.get("last"));
            this.total = D.i((Object)result.get("totalElements"));
            Object content = result.get("content");
            if (content instanceof List) {
                this.parseContent(categoryinfo, (List)content);
                continue;
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u793e\u533a\u63a5\u53e3\u67e5\u8be2\u7684content\u6570\u636e\u4e0d\u662flist\u7ed3\u6784\uff1a%s", (String)"SyncCommunityArticleJob_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), content));
        }
    }

    private void parseContent(Map<Long, String> categoryinfo, List<Map<String, Object>> contents) {
        int size = contents.size();
        ArrayList<DynamicObject> articles = new ArrayList<DynamicObject>(size);
        ArrayList<DynamicObject> categories = new ArrayList<DynamicObject>();
        try {
            for (Map<String, Object> content : contents) {
                this.handleCategory(content, categories, categoryinfo);
                this.handleArticle(content, articles);
            }
            SaveServiceHelper.save((DynamicObject[])categories.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])articles.toArray(new DynamicObject[0]));
            this.success.addAndGet(articles.size());
        }
        catch (Exception e) {
            this.failed.addAndGet(size);
            LOGGER.error("\u540c\u6b65\u793e\u533a\u96c6\u6210\u4e91\u5e16\u5b50\u5931\u8d25\uff0c\u539f\u56e0", (Throwable)e);
        }
    }

    private void handleCategory(Map<String, Object> content, List<DynamicObject> categories, Map<Long, String> categoryinfo) {
        List classInfo = (List)content.get("classifies");
        for (Map info : classInfo) {
            this.parseChild(info, categories, categoryinfo, 0L, "");
        }
    }

    private void parseChild(Map<String, Object> info, List<DynamicObject> categories, Map<Long, String> categoryinfo, long parentId, String prefix) {
        Object child = info.get("child");
        if (child instanceof Map) {
            Map childMap = (Map)child;
            long id = D.l(childMap.get("id"));
            String cate_prefix = categoryinfo.get(id);
            if (cate_prefix != null) {
                this.parseChild(childMap, categories, categoryinfo, id, cate_prefix);
            } else {
                prefix = this.createCategory(categories, parentId, childMap, id, prefix);
                categoryinfo.put(id, prefix);
                this.parseChild(childMap, categories, categoryinfo, id, prefix);
            }
        }
    }

    private String createCategory(List<DynamicObject> categories, long parentId, Map<String, Object> childMap, long id, String prefix) {
        String longNumber;
        DynamicObject category;
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        if (QueryServiceHelper.exists((String)ISC_ARTICLE_CATEGORY, (QFilter[])new QFilter[]{qFilter})) {
            category = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_ARTICLE_CATEGORY);
        } else {
            category = BusinessDataServiceHelper.newDynamicObject((String)ISC_ARTICLE_CATEGORY);
            category.set("id", (Object)id);
        }
        String number = Hash.mur24((Object[])new Object[]{id});
        category.set("number", (Object)number);
        category.set("name", (Object)D.s((Object)childMap.get("name")));
        category.set("parent", (Object)parentId);
        category.set("enable", (Object)1);
        category.set("status", (Object)"C");
        category.set("createtime", (Object)D.t((Object)System.currentTimeMillis()));
        if (parentId == 0L) {
            longNumber = number;
            category.set("longnumber", (Object)longNumber);
        } else {
            longNumber = prefix + "." + number;
            category.set("longnumber", (Object)longNumber);
        }
        categories.add(category);
        return longNumber;
    }

    private void handleArticle(Map<String, Object> content, List<DynamicObject> articles) {
        String xId = D.s((Object)content.get("knowledgeContentType")) + '-' + D.s((Object)content.get("id"));
        String[] s = xId.split("-");
        if (s.length != 2) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u89e3\u6790xId\u5143\u7d20\u6570\u636e\u7ed3\u6784\u5f02\u5e38\uff0c\u6570\u636e\u662f\uff1a%s", (String)"SyncCommunityArticleJob_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]), xId));
        }
        long id = D.l((Object)content.get("id"));
        String articleType = s[0];
        String articleTitle = this.getTitle(content, articleType);
        String url = this.getUrl(articleType, s[1], id);
        this.createArticle(content, articles, id, articleType, articleTitle, url);
    }

    private String getTitle(Map<String, Object> content, String articleType) {
        String articleTitle = "Answer".equals(articleType) ? D.s(((Map)content.get("question")).get("title")) : D.s((Object)content.get("title"));
        return articleTitle;
    }

    private String getUrl(String articleType, String s2, long id) {
        String url = "https://developer.kingdee.com/";
        if ("Article".equals(articleType)) {
            url = url + "article/" + s2;
        } else if ("LearningCourse".equals(articleType)) {
            url = url + "school/" + s2;
        } else if ("Answer".equals(articleType)) {
            url = url + "questions/" + s2 + "/answers/" + id;
        } else {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u793e\u533a\u96c6\u6210\u4e91\u5e16\u5b50,\u672a\u77e5\u5e16\u5b50\u7c7b\u578b:%s", (String)"SyncCommunityArticleJob_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), articleType));
        }
        return url;
    }

    private void createArticle(Map<String, Object> content, List<DynamicObject> articles, long id, String articleType, String articleTitle, String url) {
        DynamicObject article;
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        if (QueryServiceHelper.exists((String)ISC_COMMUNITY_ARTICLE, (QFilter[])new QFilter[]{qFilter})) {
            article = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_COMMUNITY_ARTICLE);
        } else {
            article = BusinessDataServiceHelper.newDynamicObject((String)ISC_COMMUNITY_ARTICLE);
            article.set("id", (Object)id);
        }
        article.set("number", (Object)StringUtil.trim((String)(articleType + "-" + id), (int)150));
        article.set("name", (Object)StringUtil.trim((String)articleTitle, (int)150));
        article.set("article_updatetime", (Object)D.t((Object)content.get("updatedAt")));
        url = url + "?channel_level=\u91d1\u8776\u4e91\u661f\u701a|\u91d1\u8776\u4e91\u661f\u701a|\u96c6\u6210\u670d\u52a1\u4e91|\u96c6\u6210\u7ba1\u7406|\u793e\u533a\u5e16\u5b50|\u793e\u533a\u5e16\u5b50\u5217\u8868";
        article.set("url", (Object)url);
        article.set("group", (Object)this.getGroupId(content));
        article.set("enable", (Object)1);
        article.set("status", (Object)"C");
        article.set("sync_time", (Object)D.t((Object)System.currentTimeMillis()));
        articles.add(article);
    }

    private long getGroupId(Map<String, Object> content) {
        ArrayList<Long> groupIds = new ArrayList<Long>();
        Object classifies = content.get("classifies");
        if (classifies instanceof List) {
            for (Map groupInfo : (List)classifies) {
                this.parseGroupId(groupInfo, groupIds);
            }
        }
        if (groupIds.isEmpty()) {
            return 8018L;
        }
        return (Long)groupIds.get(groupIds.size() - 1);
    }

    private void parseGroupId(Object groupInfo, List<Long> groupIds) {
        if (groupInfo instanceof Map) {
            Map map = (Map)groupInfo;
            long id = D.l(map.get("id"));
            if (!groupIds.contains(id)) {
                groupIds.add(id);
            }
            this.parseGroupId(map.get("child"), groupIds);
        }
    }

    private Map<String, Object> queryArticlesFromCommunity(int page) {
        String url = "https://developer.kingdee.com/knowledgeapi/knowledge/hot?page=" + page + "&pageSize=50&classifyId=8018&classifyType=domain";
        Reader reader = NetUtil.httpGet((String)url, (String)"UTF-8");
        return (Map)JSON.parseObject((String)NetUtil.readText((Reader)reader), Map.class);
    }
}

