/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.cache;

import java.util.ArrayList;
import java.util.List;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.cache.CacheableObjectFactory;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.misc.mem.ObjectSizeIgnored;

public class CacheableObjectManager {
    private static final ReadLockFreeMap<Class, CacheableObjectFactory> factories = new ReadLockFreeMap();
    private static final LocalMemoryCache cache;
    private static final Object NULL;

    public static <T extends ObjectSizeIgnored> T get(Class<T> target, Long id) {
        return CacheableObjectManager.get(target, "id", id);
    }

    public static <T extends ObjectSizeIgnored> T getByNumber(Class<T> target, String number) {
        return CacheableObjectManager.get(target, "number", number);
    }

    public static <T extends ObjectSizeIgnored> T getByFilter(Class<T> target, QFilter filter) {
        String key = CacheableObjectManager.generateCacheKey(filter, target);
        ObjectSizeIgnored obj = (ObjectSizeIgnored)cache.get(key);
        if (obj == null) {
            CacheableObjectFactory<T> factory = CacheableObjectManager.getFactory(target);
            Object id = CacheableObjectManager.find(factory.entityType(), filter);
            obj = id == null ? null : CacheableObjectManager.regetFromCacheOrCreate(target, id, factory);
            CacheableObjectManager.putInCache(obj, filter, target);
        }
        return (T)(obj == NULL ? null : obj);
    }

    public static <T extends ObjectSizeIgnored> List<T> getAllByFilter(Class<T> target, QFilter filter) {
        String key = "L:" + CacheableObjectManager.generateCacheKey(filter, target);
        ArrayList<T> obj = (ArrayList<T>)cache.get(key);
        if (obj == null) {
            CacheableObjectFactory<T> factory = CacheableObjectManager.getFactory(target);
            DynamicObject[] list = BusinessDataServiceHelper.load((String)factory.entityType(), (String)"id", (QFilter[])new QFilter[]{filter});
            obj = new ArrayList<T>(list.length);
            for (DynamicObject o : list) {
                obj.add(CacheableObjectManager.regetFromCacheOrCreate(target, o.get("id"), factory));
            }
            cache.put(key, obj);
        }
        return obj;
    }

    public static <T extends ObjectSizeIgnored> T getOneByFilter(Class<T> target, QFilter filter) {
        String key = "ONE:" + CacheableObjectManager.generateCacheKey(filter, target);
        Object obj = (ObjectSizeIgnored)cache.get(key);
        if (obj == null) {
            CacheableObjectFactory<T> factory = CacheableObjectManager.getFactory(target);
            DynamicObject[] list = BusinessDataServiceHelper.load((String)factory.entityType(), (String)"id", (QFilter[])new QFilter[]{filter});
            if (list.length > 0) {
                obj = CacheableObjectManager.regetFromCacheOrCreate(target, list[0].get("id"), factory);
            }
            CacheableObjectManager.putInCache(key, obj);
        }
        return (T)(obj == NULL ? null : obj);
    }

    public static <T extends ObjectSizeIgnored> T findOne(Class<T> target, QFilter filter) {
        String key = CacheableObjectManager.generateCacheKey(filter, target);
        Object obj = (ObjectSizeIgnored)cache.get(key);
        if (obj == null) {
            CacheableObjectFactory<T> factory = CacheableObjectManager.getFactory(target);
            DynamicObject[] list = BusinessDataServiceHelper.load((String)factory.entityType(), (String)"id", (QFilter[])new QFilter[]{filter});
            if (list.length > 0) {
                obj = CacheableObjectManager.regetFromCacheOrCreate(target, list[0].get("id"), factory);
            }
            CacheableObjectManager.putInCache(obj, filter, target);
        }
        return (T)(obj == NULL ? null : obj);
    }

    public static <T extends ObjectSizeIgnored> boolean cacheContains(Class<T> target, Long id) {
        String key = CacheableObjectManager.generateCacheKey(id, target);
        return cache.contains(key);
    }

    private static <T extends ObjectSizeIgnored> T get(Class<T> target, String field, Object value) {
        String key = CacheableObjectManager.generateCacheKey(value, target);
        Object obj = (ObjectSizeIgnored)cache.get(key);
        if (obj == null) {
            obj = CacheableObjectManager.createObject(target, field, value);
            CacheableObjectManager.putInCache(obj, value, target);
        }
        return (T)(obj == NULL ? null : obj);
    }

    private static <T extends ObjectSizeIgnored> T createObject(Class<T> target, String field, Object value) {
        CacheableObjectFactory<T> factory = CacheableObjectManager.getFactory(target);
        if ("id".equals(field)) {
            return CacheableObjectManager.createById(factory, value);
        }
        Object id = CacheableObjectManager.find(factory.entityType(), field, value);
        return id == null ? null : (T)CacheableObjectManager.regetFromCacheOrCreate(target, id, factory);
    }

    private static <T extends ObjectSizeIgnored> T createById(CacheableObjectFactory<T> factory, Object id) {
        String selector = factory.getDynamicObjectSelector();
        DynamicObject cfg = selector == null ? BusinessDataServiceHelper.loadSingle((Object)id, (String)factory.entityType()) : BusinessDataServiceHelper.loadSingle((Object)id, (String)factory.entityType(), (String)selector);
        return factory.create(cfg);
    }

    private static <T extends ObjectSizeIgnored> T regetFromCacheOrCreate(Class<T> target, Object id, CacheableObjectFactory<T> factory) {
        String key = CacheableObjectManager.generateCacheKey(id, target);
        ObjectSizeIgnored obj = (ObjectSizeIgnored)cache.get(key);
        if (obj != null) {
            return (T)obj;
        }
        return CacheableObjectManager.createById(factory, id);
    }

    private static <T extends ObjectSizeIgnored> CacheableObjectFactory<T> getFactory(Class<T> target) {
        CacheableObjectFactory factory = (CacheableObjectFactory)factories.get(target);
        if (factory == null) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5bf9\u8c61\uff08%s\uff09\u7684\u5de5\u5382\u5bf9\u8c61\u672a\u6ce8\u518c\u3002", (String)"CacheableObjectManager_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), target.getName()));
        }
        return factory;
    }

    private static Object find(String entity, String field, Object value) {
        QFilter filter = new QFilter(field, "=", value);
        return CacheableObjectManager.find(entity, filter);
    }

    private static Object find(String entity, QFilter filter) {
        DynamicObject[] list = BusinessDataServiceHelper.load((String)entity, (String)"id", (QFilter[])new QFilter[]{filter});
        switch (list.length) {
            case 0: {
                return null;
            }
            case 1: {
                return list[0].get("id");
            }
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u6761\u4ef6\uff08%1$s\uff09\u83b7\u53d6\u5230\u591a\u4e2a\u7c7b\u578b\u4e3a\uff08%2$s\uff09\u7684\u52a8\u6001\u5bf9\u8c61\uff01", (String)"CacheableObjectManager_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), filter, entity));
    }

    private static void putInCache(Object obj, Object value, Class<?> target) {
        String key = CacheableObjectManager.generateCacheKey(value, target);
        CacheableObjectManager.putInCache(key, obj);
    }

    private static void putInCache(String key, Object obj) {
        if (obj != null) {
            cache.put(key, obj);
        } else {
            cache.put(key, NULL);
        }
    }

    private static String generateCacheKey(Object value, Class<?> target) {
        return value + ":" + System.identityHashCode(target) + "@" + RequestContext.get().getAccountId();
    }

    public static void clearCache() {
        cache.clear();
    }

    public static <T extends ObjectSizeIgnored> void registerFactory(CacheableObjectFactory<T> factory) {
        Class<T> target = factory.target();
        if (factories.putIfAbsent(target, factory) != factory) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5bf9\u8c61\uff08%s\uff09\u7684\u5de5\u5382\u5bf9\u8c61\u5df2\u6ce8\u518c\u3002", (String)"CacheableObjectManager_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), target.getName()));
        }
    }

    private static void innerClear() {
        factories.clear();
    }

    static {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(360000);
        info.setMaxMemSize(8192);
        CacheFactory commonCacheFactory = CacheFactory.getCommonCacheFactory();
        cache = commonCacheFactory.$getOrCreateLocalMemoryCache("ISCC", "bd", info);
        NULL = new ObjectSizeIgnored(){};
    }
}

