/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.cache.data;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.cache.CacheableObjectFactory;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.mem.ObjectSizeIgnored;

public class ConnectionConfig
implements ObjectSizeIgnored {
    private static final String FIELD_APPSECRET_NEW = "appsecret_new";
    private static final String FIELD_APPSECRET = "appsecret";
    private static final String FIELD_NEWKEY = "newpwd";
    private static final String FIELD_OLDKEY = "password";
    private DynamicObject cfg;
    private Map<String, Object> cache = new ConcurrentHashMap<String, Object>(12);

    private ConnectionConfig(DynamicObject cfg) {
        this.syncNewPassword(cfg);
        this.syncNewAppsecret(cfg);
        this.cfg = cfg;
    }

    private void syncNewAppsecret(DynamicObject cfg) {
        String appsecretNew = cfg.getString(FIELD_APPSECRET_NEW);
        if (!ConnectionConfig.isEmptyPassword(appsecretNew)) {
            cfg.set(FIELD_APPSECRET, (Object)appsecretNew);
        }
    }

    private void syncNewPassword(DynamicObject cfg) {
        String newpwd = cfg.getString(FIELD_NEWKEY);
        if (!ConnectionConfig.isEmptyPassword(newpwd)) {
            cfg.set(FIELD_OLDKEY, (Object)newpwd);
        }
    }

    public void setProperty(String property, Object value) {
        this.cache.put(property, value);
    }

    public Object getProperty(String property) {
        return this.cache.get(property);
    }

    public static ConnectionConfig getConnectionConfig(long dbLink) {
        return CacheableObjectManager.get(ConnectionConfig.class, dbLink);
    }

    public static boolean isEmptyPassword(String s) {
        if (s == null) {
            return true;
        }
        if ("".equals(s)) {
            return true;
        }
        if (" ".equals(s)) {
            return true;
        }
        if ("  ".equals(s)) {
            return true;
        }
        return "   ".equals(s);
    }

    public static DynamicObject getConfig(long dbLink) {
        ConnectionConfig info;
        try {
            info = CacheableObjectManager.get(ConnectionConfig.class, dbLink);
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u6570\u636e\u6e90\u662f\u5426\u914d\u7f6e\u6b63\u786e\u3002\u9519\u8bef\u539f\u56e0\uff1a%s", (String)"ConnectionConfig_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        ConnectorUtil.checkAccountId(info.cfg);
        return info.cfg;
    }

    public static DynamicObject getByNumber(String number) {
        ConnectionConfig info = CacheableObjectManager.getByNumber(ConnectionConfig.class, number);
        return info.cfg;
    }

    static {
        CacheableObjectManager.registerFactory(new CacheableObjectFactory<ConnectionConfig>(){

            @Override
            public String entityType() {
                return "isc_database_link";
            }

            @Override
            public ConnectionConfig create(DynamicObject cfg) {
                return new ConnectionConfig(cfg);
            }

            @Override
            public Class<ConnectionConfig> target() {
                return ConnectionConfig.class;
            }
        });
    }
}

