/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.cache.data.type;

import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.cache.data.type.EntryType;
import kd.isc.iscb.platform.core.cache.data.type.RefType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.DataTypes;

public class Field {
    private String name;
    private String title;
    private DataType dataType;
    private boolean primaryKey;
    private boolean encrypt;
    private String dataSchema;
    private boolean required;

    public Field(DynamicObject item, DynamicObject meta) {
        this.name = D.s((Object)item.getString("prop_name"));
        this.title = D.s((Object)item.getString("prop_label"));
        this.primaryKey = D.x((Object)item.getString("is_primary_key"));
        this.dataType = this.innerGetDataType(item, meta);
        this.encrypt = this.innerGetIsEncrypt(item);
        this.dataSchema = item.getString("data_schema");
        this.required = item.getBoolean("required");
    }

    private boolean innerGetIsEncrypt(DynamicObject item) {
        if (null != item.getDataEntityType().getProperties().get((Object)"is_encrypt")) {
            return item.getBoolean("is_encrypt");
        }
        return false;
    }

    private DataType innerGetDataType(DynamicObject item, DynamicObject meta) {
        String s = D.s((Object)item.getString("data_type"));
        if (s == null) {
            return DataTypes.UNKNOWN;
        }
        if ("int".equalsIgnoreCase(s) || "integer".equalsIgnoreCase(s)) {
            return DataTypes.INTEGER;
        }
        if ("string".equals(s) || "boid".equals(s) || s.startsWith("varchar") || s.startsWith("nvarchar") || s.startsWith("char") || s.startsWith("nchar")) {
            return DataTypes.STRING;
        }
        if ("bigint".equalsIgnoreCase(s) || "long".equalsIgnoreCase(s)) {
            return DataTypes.LONG;
        }
        if (s.startsWith("decimal") || "number".equalsIgnoreCase(s)) {
            return DataTypes.DECIMAL;
        }
        if ("datetime".equalsIgnoreCase(s)) {
            return DataTypes.DATETIME;
        }
        if ("boolean".equalsIgnoreCase(s) || "bit".equalsIgnoreCase(s)) {
            return DataTypes.BOOLEAN;
        }
        if ("REF".equals(s)) {
            return new RefType(item, meta);
        }
        if ("ENTRIES".equals(s) || "SubHeadEntity".equals(s)) {
            return new EntryType(item, meta);
        }
        if ("date".equalsIgnoreCase(s)) {
            return DataTypes.DATE;
        }
        return DataTypes.UNKNOWN;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isEncrypt() {
        return this.encrypt;
    }

    public String getDataSchema() {
        return this.dataSchema;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String toString() {
        return this.name;
    }
}

