/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.cache.data.type;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.DataTypes;

public class RefType
implements DataType {
    private DynamicObject item;
    private DynamicObject owner;
    private MetaDataSchema schema;
    private DataType valueType;

    public RefType(DynamicObject item, DynamicObject meta) {
        this.item = item;
        this.owner = meta;
    }

    public DataType getValueType() {
        DataType valueType = this.valueType;
        if (valueType == null) {
            valueType = this.initValueType();
        }
        return valueType;
    }

    private DataType initValueType() {
        long dataSource = this.owner.getLong("group_id");
        String number = this.item.getString("data_schema");
        QFilter filter = new QFilter("group", "=", (Object)dataSource).and("number", "=", (Object)number);
        this.schema = MetaDataSchema.getOneSchemaByFilter(filter);
        MetaDataSchema schema = this.schema;
        if (schema == null) {
            this.valueType = DataTypes.UNKNOWN;
            return this.valueType;
        }
        this.valueType = schema.getPrimaryKeyDataType();
        return this.valueType;
    }

    public MetaDataSchema getSchema() {
        MetaDataSchema schema = this.schema;
        if (schema != null) {
            return schema;
        }
        this.initValueType();
        return this.schema;
    }

    public Object narrow(Object outerValue) {
        return this.getValueType().narrow(outerValue);
    }

    public Object forSave(Object innerValue) {
        return innerValue;
    }

    public Object forJson(Object object) {
        return object;
    }
}

