/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.check;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.isc.iscb.platform.core.check.CheckSFBigLogsJobFactory;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;

public class CheckSFBigLogsJob
implements Job {
    public static final JobFactory FACTORY = new CheckSFBigLogsJobFactory();
    private static final int BATCH_SIZE = 500;
    public static final int MAX_SIZE = 20000000;
    private Map<Long, Long> hashMap = new ConcurrentHashMap<Long, Long>();
    private long counts;
    private String params;
    private String title;
    private AtomicInteger index = new AtomicInteger(0);

    public CheckSFBigLogsJob(String title, String params) {
        this.params = params;
        this.title = title;
    }

    @Override
    public String getParam() {
        return this.params;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String sql = "SELECT FID FROM t_isc_sf_proc_inst";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            this.counts = DbUtil.executeCount((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            if (this.counts > 0L) {
                List<Long> ids = this.getFirstIdsList(cn);
                this.checkBigLogs(cn, ids);
                this.index.incrementAndGet();
                long minId = ids.get(ids.size() - 1);
                while (true) {
                    SignalManager.checkCancelSignal();
                    List<Long> oids = this.getOtherIdsList(cn, minId);
                    if (oids.isEmpty()) break;
                    this.checkBigLogs(cn, oids);
                    this.index.incrementAndGet();
                    minId = oids.get(oids.size() - 1);
                    D.sleep((long)50L);
                }
                this.updateCheckLog(cn);
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private void updateCheckLog(Connection cn) {
        String sql = "SELECT fid from T_ISC_CHECK_LOG";
        long count = DbUtil.executeCount((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
        String updateSql = count > 0L ? "UPDATE T_ISC_CHECK_LOG SET fcontent = ?,fcreatedate = ? where fid = ?" : "INSERT INTO T_ISC_CHECK_LOG (fcontent,fcreatedate,fid) values (?,?,?)";
        ArrayList<Object> values = new ArrayList<Object>(3);
        ArrayList<Integer> types = new ArrayList<Integer>(3);
        values.add(Json.toString(this.hashMap));
        values.add(new Timestamp(System.currentTimeMillis()));
        values.add(1);
        types.add(12);
        types.add(93);
        types.add(-5);
        DbUtil.executeUpdate((Connection)cn, (String)updateSql, values, types);
    }

    @Override
    public long getOwnerId() {
        return Hash.mur64((byte[])this.params.getBytes(D.UTF_8));
    }

    private List<Long> getOtherIdsList(Connection cn, long minId) {
        String sql = "SELECT top 500 fid FROM t_isc_sf_proc_inst where fid >" + minId + "ORDER BY fid";
        return this.getIdsBySql(cn, sql);
    }

    private List<Long> getFirstIdsList(Connection cn) {
        String firstSql = "SELECT top 500 fid FROM t_isc_sf_proc_inst ORDER BY fid";
        return this.getIdsBySql(cn, firstSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getIdsBySql(Connection cn, String sql) {
        ArrayList<Long> ids = new ArrayList<Long>(500);
        ObjectReader reader = DbUtil.executeQuery((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
        try {
            DataRow data = (DataRow)reader.read();
            while (data != null) {
                ids.add(D.l((Object)data.get((Object)"fid")));
                data = (DataRow)reader.read();
            }
            ArrayList<Long> arrayList = ids;
            return arrayList;
        }
        finally {
            DbUtil.close((ObjectReader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBigLogs(Connection cn, List<Long> ids) {
        ArrayList<Long> values = new ArrayList<Long>(ids.size());
        ArrayList<Integer> types = new ArrayList<Integer>(ids.size());
        StringBuilder sql = new StringBuilder();
        sql.append("select freleased_flow , length(fcontext_tag) as context_length from t_isc_sf_proc_inst where fid in(");
        for (int i = 0; i < ids.size(); ++i) {
            sql.append('?');
            if (i < ids.size() - 1) {
                sql.append(',');
            }
            values.add(ids.get(i));
            types.add(-5);
        }
        sql.append(')');
        sql.append("AND LENGTH(fcontext_tag) > ").append(20000000);
        ObjectReader reader = DbUtil.executeQuery((Connection)cn, (String)sql.toString(), values, types);
        try {
            DataRow data = (DataRow)reader.read();
            while (data != null) {
                Flow flow = ServiceFlowParser.getFlow(D.l((Object)data.get((Object)"freleased_flow")));
                long flowId = ServiceFlowParser.getServiceFlowId(flow);
                this.hashMap.put(flowId, Math.max(D.l((Object)this.hashMap.get(flowId)), D.l((Object)data.get((Object)"context_length"))));
                data = (DataRow)reader.read();
            }
        }
        finally {
            DbUtil.close((ObjectReader)reader);
        }
    }

    @Override
    public String getJobSummary() {
        if (this.hashMap.isEmpty()) {
            return ResManager.loadKDString((String)"\u68c0\u6d4b\u5b8c\u6210\uff0c\u65e0\u5f02\u5e38\u6570\u636e", (String)"CheckSFBigLogsJob_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        return String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5b8c\u6210\uff0c\u5176\u4e2d\u5b58\u5728\u8d85\u8fc720M\u5b57\u8282\u5927\u6570\u636e\u670d\u52a1\u6d41\u7a0b\u65e5\u5fd7\u5171%s\u6761", (String)"CheckSFBigLogsJob_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.hashMap.size()) + "\r\n" + String.format(ResManager.loadKDString((String)"\u8bf7\u5173\u95ed\u9875\u9762\u67e5\u770b\u7ed3\u679c", (String)"CheckSFBigLogsJob_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]);
    }

    @Override
    public String refreshProgress() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(ResManager.loadKDString((String)"%1$s/%2$s\uff0c\u5176\u4e2d\uff1a", (String)"CheckSFBigLogsJob_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.index.get() * 500, this.counts));
        return sb.toString();
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        StringBuilder sb = new StringBuilder();
        if ((long)(this.index.get() * 500) < this.counts) {
            sb.append(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u7b2c%s\u6761\u6570\u636e...", (String)"CheckSFBigLogsJob_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.index.get() * 500 + 1));
            sb.append("\r\n");
        }
        sb.append(String.format(ResManager.loadKDString((String)"\u5df2\u5904\u7406 %1$s\u6761\uff0c\u5176\u4e2d\u5b58\u5728\u8d85\u8fc720M\u5b57\u8282\u5927\u6570\u636e\u670d\u52a1\u6d41\u7a0b\u65e5\u5fd7\u5171\uff1a%2$s\u6761...", (String)"CheckSFBigLogsJob_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), Math.min((long)(this.index.get() * 500), this.counts), this.hashMap.size()));
        sb.append("\r\n");
        sb.append(ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u5173\u95ed\u9875\u9762\u67e5\u770b\u7ed3\u679c", (String)"CheckSFBigLogsJob_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        sb.append("\r\n");
        return new Job.Progress(D.i((Object)this.counts), this.index.get() * 500, sb.toString());
    }
}

