/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.cache.data.ConnectionConfig;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorError;
import kd.isc.iscb.platform.core.connector.DatabaseType;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.license.n.ConnectionInfo;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Index;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Logger;
import kd.isc.iscb.util.misc.SimpleFC;

public class ConnectionManager {
    private static final LocalMemoryCache cache;
    private static Log log;
    private static final ThreadLocal<LinkedList<Boolean>> resLicense;

    public static void checkConnection(DynamicObject dataSource) {
        if (dataSource.get("dblink") == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u201c%1$s\u201d\uff08%2$s\uff09\u6ca1\u6709\u914d\u7f6e\u8fde\u63a5\uff0c\u8bf7\u524d\u5f80\u201c\u6570\u636e\u6e90\u7ba1\u7406\u201d\u5217\u8868\u9009\u62e9\u7cfb\u7edf\u8fde\u63a5\u3002", (String)"ConnectionManager_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), dataSource.get("name"), dataSource.get("number")));
        }
    }

    public static ConnectionWrapper getConnection(long dbLink) {
        if (D.l((Object)dbLink) == 0L) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u7ba1\u7406\u7684\u7cfb\u7edf\u8fde\u63a5\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u8fde\u63a5\u7ba1\u7406-\u6570\u636e\u6e90\u7ba1\u7406\uff0c\u4fee\u6539\u6570\u636e\u6e90\u9009\u62e9\u7cfb\u7edf\u8fde\u63a5\u3002", (String)"ConnectionManager_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        DynamicObject cfg = ConnectionConfig.getConfig(dbLink);
        String name = cfg.getString("name");
        String number = cfg.getString("number");
        String type = cfg.getString("database_type");
        boolean isFree = true;
        if (!ConnectionManager.hasResLicense()) {
            ConnectionInfo cn = IscLicenseUtil.getLicense(dbLink, name, number, type);
            if (cn.isValid()) {
                isFree = cn.getLicenseSN() <= 0;
            } else {
                IscLicenseUtil.printTenantLicenseInfo();
                IscBizException e = ConnectorError.SYS_LICENSE_NOT_READY.create(new String[]{name, number});
                e.setStackTrace(new StackTraceElement[0]);
                throw e;
            }
        }
        try {
            ConnectionFactory factory = DatabaseType.get(type);
            ConnectionManager.setMaxTPS(cfg);
            ConnectionWrapper cn = factory.create(cfg);
            cn.setFree(isFree);
            return cn;
        }
        catch (IscBizException e) {
            ConnectionWrapper.rewrite((Throwable)e, cfg);
            throw e;
        }
        catch (Exception e) {
            String pattern = "[ID=" + dbLink + ",Type=isc_database_link]";
            if (e.getMessage().contains(pattern)) {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u7684\u8fde\u63a5\u914d\u7f6e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\uff01", (String)"ConnectionManager_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e);
            }
            IscBizException err = ConnectorError.CONNECTION_FAILURE.create((Throwable)e, new String[]{name, number, e.getMessage()});
            ConnectionWrapper.rewrite((Throwable)err, cfg);
            throw err;
        }
    }

    private static void setMaxTPS(DynamicObject cfg) {
        int maxTPS = D.i((Object)cfg.get("max_tps"));
        if (maxTPS > 0) {
            String ip = D.s((Object)cfg.get("server_ip"));
            int port = D.i((Object)cfg.get("server_port"));
            SimpleFC.setMaxTPS((String)ip, (int)port, (int)maxTPS);
            SimpleFC.setMaxTPS((long)cfg.getLong("id"), (int)maxTPS);
        }
    }

    public static Table getTable(ConnectionWrapper cn, String table_name) {
        DynamicObject cfg = cn.getConfig();
        String id = cfg == null ? "null" : cfg.get("id");
        String key = table_name + "." + id + '@' + RequestContext.get().getAccountId();
        Table table = (Table)cache.get(key);
        if (table == null) {
            table = cn.getTable(table_name);
            cache.put(key, (Object)table);
        }
        return table;
    }

    public static void clearTableCache() {
        cache.clear();
    }

    public static Map<String, Index> GetIndexInfo(ConnectionWrapper cn, String table_name) {
        return cn.getIndexInfo(table_name);
    }

    public static Map<String, MetaType> getMetaList(ConnectionWrapper cn) {
        ConnectionFactory factory = cn.getFactory();
        return factory.getMetaList(cn);
    }

    public static Map<String, Object> getEnum(ConnectionWrapper cn, String name) {
        ConnectionFactory factory = cn.getFactory();
        return factory.getEnumInfo(cn, name);
    }

    public static ObjectReader<Map<String, Object>> query(ConnectionWrapper cn, String entity, String ... fields) {
        HashMap<String, Object> requires = new HashMap<String, Object>(fields.length);
        for (String field : fields) {
            requires.put(field, 1);
        }
        ConnectionFactory factory = cn.getFactory();
        return factory.query(cn, entity, requires, Collections.emptyList(), Collections.emptyList());
    }

    public static ObjectReader<Map<String, Object>> query(ConnectionWrapper cn, String entity, Map<String, Object> requires, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        ConnectionFactory factory = cn.getFactory();
        return factory.query(cn, entity, requires, filter, orderBy);
    }

    public static List<Map<String, Object>> getEntity(ConnectionWrapper cn, String name) {
        ConnectionFactory factory = cn.getFactory();
        return factory.getEntityInfo(cn, name);
    }

    public static List<Map<String, Object>> getEventSrc(ConnectionWrapper cn, String name) {
        ConnectionFactory factory = cn.getFactory();
        return factory.getEventSrcInfo(cn, name);
    }

    public static Map<String, Object> getTableInfo(ConnectionWrapper cn, String name) {
        return cn.getTableInfo(name);
    }

    public static Map<String, Object> getService(ConnectionWrapper cn, String service_name) {
        ConnectionFactory factory = cn.getFactory();
        return factory.getServiceInfo(cn, service_name);
    }

    public static List<Map<String, Object>> getServiceX(ConnectionWrapper cn, String service_name) {
        ConnectionFactory factory = cn.getFactory();
        return factory.getServiceInfoX(cn, service_name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(long dbLink) {
        ConnectionManager.pushResLicense(true);
        try (ConnectionWrapper cn = ConnectionManager.getConnection(dbLink);){
            cn.getFactory().test(cn);
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    public static boolean hasResLicense() {
        LinkedList<Boolean> stack = resLicense.get();
        if (stack == null) {
            return false;
        }
        for (Boolean b : stack) {
            if (!b.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static void pushResLicense(boolean valid) {
        LinkedList<Boolean> stack = resLicense.get();
        if (stack == null) {
            stack = new LinkedList();
            resLicense.set(stack);
        }
        stack.push(valid);
    }

    public static void popResLicense() {
        LinkedList<Boolean> stack = resLicense.get();
        if (stack != null) {
            stack.pop();
            if (stack.isEmpty()) {
                resLicense.remove();
            }
        }
    }

    static {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(360000);
        info.setMaxMemSize(128);
        CacheFactory commonCacheFactory = CacheFactory.getCommonCacheFactory();
        cache = commonCacheFactory.$getOrCreateLocalMemoryCache("ISC_TABLE_SCHEMA", "bd", info);
        log = LogFactory.getLog(ConnectionManager.class);
        DbUtil.setLogger((Logger)new Logger(){

            public void error(String message, Throwable e) {
                log.warn(message, e);
            }
        });
        resLicense = new ThreadLocal();
    }
}

