/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.webapi.DynamicObjectContext;
import kd.isc.iscb.platform.core.factory.FactoryManager;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.Index;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.SimpleFC;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.misc.mem.ObjectSizeIgnored;
import kd.isc.iscb.util.script.context.Context;

public class ConnectionWrapper
implements AutoCloseable,
Context,
ObjectSizeIgnored {
    private ConnectionFactory factory;
    private DynamicObject cfg;
    private boolean free;
    private static volatile Field detailMessage;
    private static volatile boolean omitted;

    public ConnectionWrapper(ConnectionFactory factory, DynamicObject cfg) {
        this.factory = factory;
        this.cfg = cfg;
    }

    void setFree(boolean free) {
        this.free = free;
    }

    public boolean isFree() {
        return this.free;
    }

    public final ConnectionFactory getFactory() {
        return this.factory;
    }

    public final DynamicObject getConfig() {
        return this.cfg;
    }

    public final void ensureFluidControl() {
        if (this.cfg == null) {
            return;
        }
        int maxTPS = D.i((Object)this.cfg.get("max_tps"));
        if (maxTPS > 0) {
            SimpleFC.visit((long)this.cfg.getLong("id"));
        }
    }

    @Override
    public void close() {
    }

    public boolean supportsExecuteCount() {
        return false;
    }

    public boolean supportsTransaction() {
        throw this.rewriteAndReturn(new UnsupportedOperationException());
    }

    public boolean getAutoCommit() {
        throw this.rewriteAndReturn(new UnsupportedOperationException());
    }

    public void setAutoCommit(boolean autoCommit) {
        throw this.rewriteAndReturn(new UnsupportedOperationException());
    }

    public void rollback() {
        throw this.rewriteAndReturn(new UnsupportedOperationException());
    }

    public Pair<ResultSet, Statement> executeQuery2(String sql, List<Object> values, List<Integer> types) {
        throw this.rewriteAndReturn(new UnsupportedOperationException());
    }

    public ObjectReader<DataRow> executeQuery(String sql, List<Object> values, List<Integer> types) {
        throw this.rewriteAndReturn(new UnsupportedOperationException());
    }

    public int executeUpdate(String sql, List<Object> values, List<Integer> types) {
        throw this.rewriteAndReturn(new UnsupportedOperationException());
    }

    public int[] executeBatch(String sql, List<List<Object>> batch, List<Integer> types) {
        throw this.rewriteAndReturn(new UnsupportedOperationException());
    }

    public void commit() {
        throw this.rewriteAndReturn(new UnsupportedOperationException());
    }

    public long executeCount(String sql, List<Object> values, List<Integer> types) {
        throw this.rewriteAndReturn(new UnsupportedOperationException());
    }

    public List<Map<String, Object>> getProperties(String sql) {
        throw this.rewriteAndReturn(new UnsupportedOperationException());
    }

    public void classify(Table table, List<Map<String, Object>> rows, List<Column> judgeFields, List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update) {
        throw this.rewriteAndReturn(new UnsupportedOperationException());
    }

    public Table getTable(String table_name) {
        throw this.rewriteAndReturn(new UnsupportedOperationException());
    }

    public Map<String, Index> getIndexInfo(String table_name) {
        throw this.rewriteAndReturn(new UnsupportedOperationException());
    }

    public Map<String, Object> getTableInfo(String name) {
        throw this.rewriteAndReturn(new UnsupportedOperationException());
    }

    public char getQuot() {
        throw this.rewriteAndReturn(new UnsupportedOperationException());
    }

    public String topSQL(String sql, int i) {
        throw this.rewriteAndReturn(new UnsupportedOperationException());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.cfg != null) {
            sb.append(this.cfg.get("number")).append('(').append(this.cfg.getPkValue()).append(')');
        } else {
            sb.append(this.factory.getClass().getName());
        }
        return sb.toString();
    }

    public boolean set(String property, Object value) {
        return false;
    }

    public boolean contains(String property) {
        return false;
    }

    public Object get(String property) {
        return DynamicObjectContext.get(this.cfg, property);
    }

    protected final RuntimeException rewriteAndReturn(RuntimeException e) {
        this.rewrite(e);
        return e;
    }

    protected final void rewrite(Throwable e) {
        ConnectionWrapper.rewrite(e, this.cfg);
    }

    public static void rewrite(Throwable e, ConnectionWrapper cn) {
        if (cn != null) {
            ConnectionWrapper.rewrite(e, cn.getConfig());
        }
    }

    public static void ensureFluidControl(ConnectionWrapper cn) {
        if (cn != null) {
            cn.ensureFluidControl();
        }
    }

    public static void rewrite(Throwable e, DynamicObject cfg) {
        if (cfg != null) {
            String newMsg;
            String remark = ConnectionWrapper.generateDbLinkRemark(cfg);
            String message = StringUtil.getCascadeMessage((Throwable)e);
            if (!Objects.equals(message, newMsg = ConnectionWrapper.compositeNewMessage(message, remark))) {
                ConnectionWrapper.rewrite(e, newMsg);
            }
        }
    }

    public static String compositeNewMessage(String message, String remark) {
        if (message.contains(remark)) {
            return message;
        }
        int i = message.indexOf("\r\n" + ResManager.loadKDString((String)"\u9519\u8bef\u7801\uff1a", (String)"ConnectionWrapper_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        if (i >= 0) {
            int j = message.indexOf("\r\n", i + 5);
            if (j < 0) {
                return message + remark + "\r\n";
            }
            return message.substring(0, j) + remark + "\r\n" + message.substring(j);
        }
        i = message.indexOf("\r\n\r\n");
        if (i >= 0) {
            return message.substring(0, i) + remark + "\r\n" + message.substring(i);
        }
        return message + remark + "\r\n";
    }

    public static String generateDbLinkRemark(DynamicObject cfg) {
        String typeNumber = D.s((Object)cfg.get("database_type"));
        String typeName = FactoryManager.getName(typeNumber);
        String linkName = D.s((Object)cfg.get("name"));
        String linkNumber = D.s((Object)cfg.get("number"));
        StringBuilder remark = new StringBuilder();
        remark.append(String.format(ResManager.loadKDString((String)"\r\n\r\n\u63d0\u793a\uff1a\u4e0a\u8ff0\u5f02\u5e38\u7531\u201c%1$s(%2$s)\u201d\u6570\u636e\u6e90\u629b\u51fa,\u82e5\u9700\u8981\u66f4\u8be6\u7ec6\u7684\u65e5\u5fd7\u5206\u6790\u62a5\u9519\uff0c\u8bf7\u5728\u8fde\u63a5\u914d\u7f6e\u201c%3$s", (String)"ConnectionWrapper_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), typeName, typeNumber, linkName));
        if (!Objects.equals(linkName, linkNumber)) {
            remark.append('(').append(linkNumber).append(')');
        }
        remark.append('\u201d');
        remark.append(ResManager.loadKDString((String)"\u6240\u5bf9\u5e94\u7684\u7cfb\u7edf\u4e2d\u83b7\u53d6\u66f4\u591a\u65e5\u5fd7\u3002", (String)"ConnectionWrapper_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        return remark.toString();
    }

    private static void rewrite(Throwable err, String newMsg) {
        if (omitted) {
            return;
        }
        Field f = detailMessage;
        if (f == null) {
            try {
                f = detailMessage = Throwable.class.getDeclaredField("detailMessage");
            }
            catch (Exception e) {
                omitted = true;
            }
        }
        if (f != null) {
            try {
                detailMessage.setAccessible(true);
                f.set(err, newMsg);
            }
            catch (Exception e) {
                omitted = true;
            }
        }
    }

    static {
        omitted = false;
    }
}

