/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.connector.JdbcConnectionFactory;
import kd.isc.iscb.platform.core.connector.jdbc.proxy.IscPreparedStatement;
import kd.isc.iscb.platform.core.connector.trace.SqlLogItem;
import kd.isc.iscb.platform.core.dc.e.p.ViewUtil;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Index;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.ReflectionUtil;

public class JdbcConnectionWrapper
extends ConnectionWrapper
implements Connection {
    private Connection impl;
    private boolean supportsReaderCount = true;

    public JdbcConnectionWrapper(Connection impl, JdbcConnectionFactory factory, DynamicObject cfg) {
        super(factory, cfg);
        this.impl = impl;
    }

    public JdbcConnectionWrapper(Connection impl, JdbcConnectionFactory factory, DynamicObject cfg, boolean supportsReaderCount) {
        super(factory, cfg);
        this.impl = impl;
        this.supportsReaderCount = supportsReaderCount;
    }

    private String getConnDesc() {
        StringBuilder sb = new StringBuilder();
        DynamicObject cfg = this.getConfig();
        if (cfg != null) {
            String type = D.s((Object)cfg.get("database_type"));
            sb.append("conn_type : ").append(type).append("\r\n");
            String linkName = D.s((Object)cfg.get("name"));
            String linkNumber = D.s((Object)cfg.get("number"));
            sb.append("conn_desc : ");
            if (!Objects.equals(linkName, linkNumber)) {
                sb.append(linkName).append('(').append(linkNumber).append(')');
            } else {
                sb.append(linkName);
            }
        }
        sb.append("\r\n");
        return sb.toString();
    }

    @Override
    public boolean supportsExecuteCount() {
        return this.supportsReaderCount;
    }

    public JdbcConnectionFactory getJdbcConnectionFactory() {
        return (JdbcConnectionFactory)this.getFactory();
    }

    @Override
    public void close() {
        ConnectorUtil.close(this.impl);
        this.impl = null;
    }

    @Override
    public boolean supportsTransaction() {
        try {
            return this.getJdbcConnectionFactory().supportsTransaction();
        }
        catch (RuntimeException e) {
            throw this.rewriteAndReturn(e);
        }
    }

    @Override
    public Pair<ResultSet, Statement> executeQuery2(String sql, List<Object> values, List<Integer> types) {
        this.ensureFluidControl();
        SqlLogItem sqlLogItem = SqlLogItem.startRecord(this.getConnDesc(), sql);
        try {
            Pair pair = DbUtil.executeQuery2((Connection)this.impl, (String)sql, values, types, (int)300);
            SqlLogItem.endRecord(sqlLogItem);
            return pair;
        }
        catch (RuntimeException e) {
            SqlLogItem.endRecord(sqlLogItem, e);
            throw this.rewriteAndReturn(e);
        }
    }

    @Override
    public ObjectReader<DataRow> executeQuery(String sql, List<Object> values, List<Integer> types) {
        this.ensureFluidControl();
        SqlLogItem sqlLogItem = SqlLogItem.startRecord(this.getConnDesc(), sql);
        try {
            ObjectReader reader = DbUtil.executeQuery((Connection)this.impl, (String)sql, values, types, (int)300);
            SqlLogItem.endRecord(sqlLogItem);
            return reader;
        }
        catch (RuntimeException e) {
            SqlLogItem.endRecord(sqlLogItem, e);
            throw this.rewriteAndReturn(e);
        }
    }

    @Override
    public int executeUpdate(String sql, List<Object> values, List<Integer> types) {
        this.ensureFluidControl();
        SqlLogItem sqlLogItem = SqlLogItem.startRecord(this.getConnDesc(), sql);
        try {
            int i = DbUtil.executeUpdate((Connection)this.impl, (String)sql, values, types);
            SqlLogItem.endRecord(sqlLogItem);
            return i;
        }
        catch (RuntimeException e) {
            SqlLogItem.endRecord(sqlLogItem, e);
            throw this.rewriteAndReturn(e);
        }
    }

    @Override
    public int[] executeBatch(String sql, List<List<Object>> batch, List<Integer> types) {
        this.ensureFluidControl();
        SqlLogItem sqlLogItem = SqlLogItem.startRecord(this.getConnDesc(), sql);
        try {
            int[] ints = DbUtil.executeBatch((Connection)this.impl, (String)sql, batch, types);
            SqlLogItem.endRecord(sqlLogItem);
            return ints;
        }
        catch (RuntimeException e) {
            SqlLogItem.endRecord(sqlLogItem, e);
            throw this.rewriteAndReturn(e);
        }
    }

    @Override
    public long executeCount(String sql, List<Object> values, List<Integer> types) {
        this.ensureFluidControl();
        try {
            return DbUtil.executeCount((Connection)this.impl, (String)sql, values, types);
        }
        catch (RuntimeException e) {
            throw this.rewriteAndReturn(e);
        }
    }

    @Override
    public List<Map<String, Object>> getProperties(String sql) {
        try {
            String topSql = this.getJdbcConnectionFactory().topSQL(this, sql, 0);
            return ViewUtil.getProperties(this.impl, topSql);
        }
        catch (RuntimeException e) {
            throw this.rewriteAndReturn(e);
        }
    }

    @Override
    public Table getTable(String table_name) {
        try {
            return this.getJdbcConnectionFactory().getTable(this, table_name);
        }
        catch (RuntimeException e) {
            throw this.rewriteAndReturn(e);
        }
    }

    @Override
    public Map<String, Index> getIndexInfo(String table_name) {
        try {
            return this.getJdbcConnectionFactory().getIndexInfo(this, table_name);
        }
        catch (RuntimeException e) {
            throw this.rewriteAndReturn(e);
        }
    }

    @Override
    public Map<String, Object> getTableInfo(String table_name) {
        try {
            return this.getJdbcConnectionFactory().getTableInfo(this, table_name);
        }
        catch (RuntimeException e) {
            throw this.rewriteAndReturn(e);
        }
    }

    @Override
    public char getQuot() {
        try {
            return this.getJdbcConnectionFactory().getQuot();
        }
        catch (RuntimeException e) {
            throw this.rewriteAndReturn(e);
        }
    }

    @Override
    public String topSQL(String sql, int limit) {
        try {
            return this.getJdbcConnectionFactory().topSQL(this, sql, limit);
        }
        catch (RuntimeException e) {
            throw this.rewriteAndReturn(e);
        }
    }

    @Override
    public void classify(Table table, List<Map<String, Object>> rows, List<Column> judgeFields, List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update) {
        try {
            this.getJdbcConnectionFactory().classify(this, table, rows, judgeFields, for_insert, for_update);
        }
        catch (RuntimeException e) {
            throw this.rewriteAndReturn(e);
        }
    }

    @Override
    public final void commit() {
        if (this.supportsTransaction()) {
            try {
                this.impl.commit();
            }
            catch (SQLException e) {
                throw this.rewriteAndReturn(DatabaseError.TRANS_COMMIT_FAILURE.wrap((Throwable)e));
            }
        } else {
            throw this.rewriteAndReturn(new UnsupportedOperationException());
        }
    }

    @Override
    public final void rollback() {
        if (this.supportsTransaction()) {
            try {
                this.impl.rollback();
            }
            catch (SQLException e) {
                throw this.rewriteAndReturn(DatabaseError.TRANS_ROLLBACK_FAILURE.wrap((Throwable)e));
            }
        } else {
            throw this.rewriteAndReturn(new UnsupportedOperationException());
        }
    }

    @Override
    public final void rollback(Savepoint savepoint) {
        if (this.supportsTransaction()) {
            try {
                this.impl.rollback(savepoint);
            }
            catch (SQLException e) {
                throw this.rewriteAndReturn(DatabaseError.TRANS_ROLLBACK_FAILURE.wrap((Throwable)e));
            }
        } else {
            throw this.rewriteAndReturn(new UnsupportedOperationException());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void setAutoCommit(boolean autoCommit) {
        if (!this.supportsTransaction()) throw this.rewriteAndReturn(new UnsupportedOperationException());
        try {
            if (this.impl == null) return;
            this.impl.setAutoCommit(autoCommit);
            return;
        }
        catch (SQLException e) {
            throw this.rewriteAndReturn(DatabaseError.TRANS_MODE_FAILURE.wrap((Throwable)e));
        }
    }

    @Override
    public final boolean getAutoCommit() {
        if (this.supportsTransaction()) {
            try {
                return this.impl.getAutoCommit();
            }
            catch (SQLException e) {
                throw this.rewriteAndReturn(D.e((Throwable)e));
            }
        }
        return true;
    }

    @Override
    public final Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.impl.createArrayOf(typeName, elements);
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.impl.clearWarnings();
    }

    @Override
    public final Blob createBlob() throws SQLException {
        return this.impl.createBlob();
    }

    @Override
    public final Clob createClob() throws SQLException {
        return this.impl.createClob();
    }

    @Override
    public final NClob createNClob() throws SQLException {
        return this.impl.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.impl.createSQLXML();
    }

    @Override
    public final Statement createStatement() throws SQLException {
        this.ensureFluidControl();
        return this.wrap(this.impl.createStatement());
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.ensureFluidControl();
        return this.wrap(this.impl.createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.ensureFluidControl();
        return this.wrap(this.impl.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public final Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.impl.createStruct(typeName, attributes);
    }

    @Override
    public final String getCatalog() throws SQLException {
        return this.impl.getCatalog();
    }

    @Override
    public final Properties getClientInfo() throws SQLException {
        return this.impl.getClientInfo();
    }

    @Override
    public final String getClientInfo(String name) throws SQLException {
        return this.impl.getClientInfo(name);
    }

    @Override
    public final int getHoldability() throws SQLException {
        return this.impl.getHoldability();
    }

    @Override
    public final DatabaseMetaData getMetaData() throws SQLException {
        return this.impl.getMetaData();
    }

    @Override
    public final int getTransactionIsolation() throws SQLException {
        return this.impl.getTransactionIsolation();
    }

    @Override
    public final Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.impl.getTypeMap();
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        return this.impl.getWarnings();
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.impl.isClosed();
    }

    @Override
    public final boolean isReadOnly() throws SQLException {
        return this.impl.isReadOnly();
    }

    @Override
    public final boolean isValid(int timeout) throws SQLException {
        return this.impl.isValid(timeout);
    }

    @Override
    public final String nativeSQL(String sql) throws SQLException {
        return this.impl.nativeSQL(sql);
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        this.ensureFluidControl();
        return this.wrap(this.impl.prepareCall(sql));
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.ensureFluidControl();
        return this.wrap(this.impl.prepareCall(sql, resultSetType, resultSetConcurrency));
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.ensureFluidControl();
        return this.wrap(this.impl.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        this.ensureFluidControl();
        PreparedStatement wrap = this.wrap(this.impl.prepareStatement(sql));
        return new IscPreparedStatement(wrap, sql, this.getConnDesc());
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureFluidControl();
        PreparedStatement wrap = this.wrap(this.impl.prepareStatement(sql, autoGeneratedKeys));
        return new IscPreparedStatement(wrap, sql, this.getConnDesc());
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.ensureFluidControl();
        PreparedStatement wrap = this.wrap(this.impl.prepareStatement(sql, columnIndexes));
        return new IscPreparedStatement(wrap, sql, this.getConnDesc());
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.ensureFluidControl();
        PreparedStatement wrap = this.wrap(this.impl.prepareStatement(sql, columnNames));
        return new IscPreparedStatement(wrap, sql, this.getConnDesc());
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.ensureFluidControl();
        PreparedStatement wrap = this.wrap(this.impl.prepareStatement(sql, resultSetType, resultSetConcurrency));
        return new IscPreparedStatement(wrap, sql, this.getConnDesc());
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.ensureFluidControl();
        PreparedStatement wrap = this.wrap(this.impl.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        return new IscPreparedStatement(wrap, sql, this.getConnDesc());
    }

    @Override
    public final void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.impl.releaseSavepoint(savepoint);
    }

    @Override
    public final void setCatalog(String catalog) throws SQLException {
        throw new UnsupportedOperationException("Unsupported - catalog");
    }

    @Override
    public final void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.impl.setClientInfo(properties);
    }

    @Override
    public final void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.impl.setClientInfo(name, value);
    }

    @Override
    public final void setHoldability(int holdability) throws SQLException {
        this.impl.setHoldability(holdability);
    }

    @Override
    public final void setReadOnly(boolean readOnly) throws SQLException {
        this.impl.setReadOnly(readOnly);
    }

    @Override
    public final Savepoint setSavepoint() throws SQLException {
        return this.impl.setSavepoint();
    }

    @Override
    public final Savepoint setSavepoint(String name) throws SQLException {
        return this.impl.setSavepoint(name);
    }

    @Override
    public final void setTransactionIsolation(int level) throws SQLException {
        this.impl.setTransactionIsolation(level);
    }

    @Override
    public final void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.impl.setTypeMap(map);
    }

    @Override
    public final boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.impl.isWrapperFor(iface);
    }

    @Override
    public final <T> T unwrap(Class<T> iface) throws SQLException {
        return this.impl.unwrap(iface);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.impl.abort(executor);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.impl.getNetworkTimeout();
    }

    @Override
    public String getSchema() throws SQLException {
        return this.impl.getSchema();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.impl.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.impl.setSchema(schema);
    }

    private final <E> E wrap(final E impl) {
        if (impl == null) {
            return null;
        }
        Class[] interfaces = ReflectionUtil.getInterfaces(impl);
        return (E)Proxy.newProxyInstance(impl.getClass().getClassLoader(), interfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return method.invoke(impl, args);
                }
                catch (Exception e) {
                    Throwable cause = e;
                    while (cause instanceof InvocationTargetException || cause instanceof UndeclaredThrowableException) {
                        cause = cause.getCause();
                    }
                    JdbcConnectionWrapper.this.rewrite(cause);
                    throw cause;
                }
            }
        });
    }
}

