/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apacheftp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.isc.iscb.platform.core.connector.ftp.util.FileType;
import kd.isc.iscb.platform.core.connector.ftp.util.IscFtpException;
import kd.isc.iscb.platform.core.connector.ftp.util.PathInfo;
import kd.isc.iscb.platform.core.connector.sunftp.FtpFile;
import kd.isc.iscb.platform.core.connector.sunftp.FtpUtil;
import kd.isc.iscb.util.misc.StringUtil;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import sun.net.ftp.FtpDirEntry;

public class ApacheFtpUtil {
    public static List<FtpFile> list(FTPClient client, String path) throws IOException {
        if (!ApacheFtpUtil.existDirectory(client, path)) {
            throw new IscFtpException(path + " not found Directory.");
        }
        ArrayList<FtpFile> files = new ArrayList<FtpFile>(16);
        FTPFile[] ftpFiles = client.listFiles(path);
        ApacheFtpUtil.checkReplyCode(client, path);
        for (FTPFile file : ftpFiles) {
            Date date = new Date(file.getTimestamp().getTimeInMillis());
            FtpFile ftp = new FtpFile(file.getName(), file.getSize(), null, null, date, ApacheFtpUtil.getType(file));
            files.add(ftp);
        }
        return files;
    }

    public static FtpDirEntry.Type getType(FTPFile file) {
        if (file.isFile()) {
            return FtpDirEntry.Type.FILE;
        }
        return FtpDirEntry.Type.DIR;
    }

    public static Object readFileContent(FTPClient client, PathInfo pathInfo, String fileName, long restartOffset) throws IOException {
        client.setRestartOffset(restartOffset);
        try (InputStream inputStream = client.retrieveFileStream(pathInfo.getDirPath() + fileName);){
            if (pathInfo.getFileType() == FileType.BIN) {
                byte[] byArray = FtpUtil.readBytes(inputStream);
                return byArray;
            }
            String string = FtpUtil.readString(pathInfo.getCharset(), inputStream);
            return string;
        }
    }

    public static void deleteFile(FTPClient client, String path) throws IOException {
        client.deleteFile(path);
        ApacheFtpUtil.checkReplyCode(client, path);
    }

    public static void rmdir(FTPClient client, String dirPath) throws IOException {
        List<FtpFile> dirs = ApacheFtpUtil.list(client, dirPath);
        if (dirs != null && dirs.size() > 0) {
            for (FtpFile apacheFtpFile : dirs) {
                String name = apacheFtpFile.getFileName();
                String childPath = dirPath + (dirPath.endsWith("/") ? "" : Character.valueOf('/')) + name;
                if (apacheFtpFile.getType() == FtpDirEntry.Type.DIR) {
                    if (".".equals(name) || "..".equals(name)) continue;
                    ApacheFtpUtil.rmdir(client, childPath);
                    continue;
                }
                ApacheFtpUtil.deleteFile(client, childPath);
            }
        }
        client.removeDirectory(dirPath);
        ApacheFtpUtil.checkReplyCode(client, dirPath);
    }

    public static void mkdir(FTPClient client, String dirPath) throws IOException {
        if (!dirPath.equals("/")) {
            String[] dirs = dirPath.split("/");
            StringBuilder childPath = new StringBuilder("/");
            for (String dir : dirs) {
                if (StringUtil.isEmpty((String)dir)) continue;
                childPath.append(childPath.toString().endsWith("/") ? "" : Character.valueOf('/')).append(dir);
                if (client.changeWorkingDirectory(childPath.toString()) || client.makeDirectory(childPath.toString())) continue;
                ApacheFtpUtil.checkReplyCode(client, dirPath);
            }
        }
        ApacheFtpUtil.checkReplyCode(client, dirPath);
    }

    public static boolean existDirectory(FTPClient client, String dirPath) throws IOException {
        if (!dirPath.equals("/")) {
            String[] dirs = dirPath.split("/");
            StringBuilder childPath = new StringBuilder("/");
            for (String dir : dirs) {
                if (StringUtil.isEmpty((String)dir)) continue;
                childPath.append(childPath.toString().endsWith("/") ? "" : Character.valueOf('/')).append(dir);
                if (client.changeWorkingDirectory(childPath.toString())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean existFile(FTPClient client, String dirPath, String fileName) throws IOException {
        FTPFile[] ftpFiles;
        for (FTPFile file : ftpFiles = client.listFiles(dirPath)) {
            if (!file.isFile() || !file.getName().equals(fileName)) continue;
            return true;
        }
        return false;
    }

    public static boolean exists(FTPClient client, String dirPath) throws IOException {
        if (dirPath.lastIndexOf(47) == dirPath.length() - 1) {
            return ApacheFtpUtil.existDirectory(client, dirPath);
        }
        String path = dirPath.substring(0, dirPath.lastIndexOf(47));
        String fileName = dirPath.substring(dirPath.lastIndexOf(47) + 1);
        return ApacheFtpUtil.existDirectory(client, path) && ApacheFtpUtil.existFile(client, path, fileName);
    }

    private static void checkReplyCode(FTPClient client, String dirPath) {
        if (!FTPReply.isPositiveCompletion((int)client.getReplyCode())) {
            throw new IscFtpException(dirPath + " " + client.getReplyString());
        }
    }
}

