/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.api.ApiClassify;
import kd.isc.iscb.platform.core.api.ApiUtil;
import kd.isc.iscb.util.dt.D;

public final class ApiInfo {
    private String dispatchUrl = "/kapi/app/iscb/IntegrateSchemaApiDispatcher";
    private Method method;
    private String queryString;
    private String contentType;
    private String charset;
    private String apiEntityName;
    private String apiNumber;

    public ApiInfo(Builder builder) {
        this.dispatchUrl = builder.dispatchUrl;
        this.method = builder.method;
        this.queryString = builder.queryString;
        this.contentType = builder.contentType;
        this.charset = builder.charset;
        this.apiEntityName = builder.apiEntityName;
        this.apiNumber = builder.apiNumber;
    }

    @Deprecated
    public ApiInfo() {
        this.method = Method.POST;
        this.contentType = "application/json";
        this.charset = "UTF-8";
    }

    @Deprecated
    public ApiInfo(String queryString) {
        this();
        this.queryString = "?" + queryString;
    }

    @Deprecated
    public ApiInfo(String dispatchUrl, String queryString) {
        this(queryString);
        this.dispatchUrl = dispatchUrl;
    }

    @Deprecated
    public ApiInfo(String dispatchUrl, Method method, String contentType, String charset, String queryString) {
        this.dispatchUrl = dispatchUrl;
        this.method = method;
        this.contentType = contentType;
        this.charset = charset;
        this.queryString = "?" + queryString;
    }

    @Deprecated
    public ApiInfo(String queryString, String apiNumber, String apiEntityName) {
        this(queryString);
        this.apiEntityName = apiEntityName;
        this.apiNumber = apiNumber;
    }

    @Deprecated
    public ApiInfo(String dispatchUrl, String queryString, String apiNumber, String apiEntityName) {
        this(queryString, apiNumber, apiEntityName);
        this.dispatchUrl = dispatchUrl;
    }

    public String toString() {
        return this.getUrl() + "\n" + this.getMethod() + "\n" + this.getContentType();
    }

    public String getContentType() {
        return String.format(ResManager.loadKDString((String)"\u5185\u5bb9\u683c\u5f0f\uff1a%1$s; charset=%2$s", (String)"ApiInfo_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.contentType, this.charset);
    }

    public String getMethod() {
        return String.format(ResManager.loadKDString((String)"\u8c03\u7528\u65b9\u6cd5\uff1a%s", (String)"ApiInfo_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.method.name());
    }

    public String getUrl() {
        if (D.s((Object)this.dispatchUrl) == null) {
            return this.queryString;
        }
        return "URL:" + this.dispatchUrl + (this.dispatchUrl.contains("?") ? "&" : "?") + this.queryString;
    }

    public String getNewUrl(DynamicObject api) {
        String url = ApiUtil.isVersion2Api(api) ? "URL:/kapi/v2/iscb/route/" : "URL:/kapi/app/iscb/";
        return url + ApiClassify.getPrefix(this.apiEntityName) + this.apiNumber;
    }

    public String getDispatchUrl() {
        return this.dispatchUrl;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getApiEntityName() {
        return this.apiEntityName;
    }

    public String getApiNumber() {
        return this.apiNumber;
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }

    public static class Builder {
        private String dispatchUrl = "/kapi/app/iscb/IntegrateSchemaApiDispatcher";
        private Method method = Method.POST;
        private String queryString;
        private String contentType = "application/json";
        private String charset = "UTF-8";
        private String apiEntityName;
        private String apiNumber;

        public Builder() {
        }

        public Builder(String url) {
            this.dispatchUrl = url;
        }

        public Builder setMethod(Method method) {
            this.method = method;
            return this;
        }

        public Builder setQueryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public Builder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public Builder setApiEntityNumber(String apiEntityName) {
            this.apiEntityName = apiEntityName;
            return this;
        }

        public Builder setApiNumber(String apiNumber) {
            this.apiNumber = apiNumber;
            return this;
        }

        public ApiInfo build() {
            return new ApiInfo(this);
        }
    }
}

