/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc;

import com.kingdee.bos.ctrl.print.io.KDFontMapper;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.apic.doc.external.style.CellStyle;
import kd.isc.iscb.platform.core.connector.apic.doc.external.style.TableStyle;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.FileUtil;

public class DocFileUtil {
    public static final String USER_HOME = System.getProperty("user.home");
    private static volatile BaseFont baseFont;
    private static final float[] TABLE_WIDTHS;

    public static BaseFont getBaseFont() {
        BaseFont font = baseFont;
        if (font != null) {
            return font;
        }
        return DocFileUtil.createBaseFont();
    }

    public static com.lowagie.text.Font getSpecificFont(float size, int style) {
        return DocFileUtil.getSpecificFont(size, style, null);
    }

    public static com.lowagie.text.Font getSpecificFont(float size, int style, Color color) {
        return new com.lowagie.text.Font(DocFileUtil.getBaseFont(), size, style, color);
    }

    private static synchronized BaseFont createBaseFont() {
        BaseFont font = baseFont;
        if (font != null) {
            return font;
        }
        Font kf = new Font("SimSun", 0, 12);
        baseFont = font = new KDFontMapper().awtToPdf(kf);
        return font;
    }

    public static File newTempFile() {
        return DocFileUtil.newTempFileByType("pdf");
    }

    private static File newTempFileByType(String type) {
        String parentPath = USER_HOME + File.separator + "api_doc";
        FileUtil.checkFilePath((String)parentPath);
        File file = new File(parentPath, UUID.randomUUID() + "." + type);
        File dir = file.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5939\uff1a%s", (String)"DocFileUtil_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), dir));
        }
        return file;
    }

    public static File newTempXmlFile() {
        return DocFileUtil.newTempFileByType("xml");
    }

    public static Element getRequestHeaderTable(float headerFontSize, float contentFontSize) {
        CellStyle cellHeaderStyle = new CellStyle(1, 5, 0.25f, 3.0f, 1, 1);
        CellStyle cellContentStyle = new CellStyle(0, 5, 0.25f, 3.0f, 1, 1);
        CellStyle cellCenterStyle = new CellStyle(1, 5, 0.25f, 3.0f, 1, 1);
        List<PdfPCell> icells = DocFileUtil.buildCells(new String[]{ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"DocFileUtil_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), "key", "value"}, cellHeaderStyle, DocFileUtil.getSpecificFont(headerFontSize, 1));
        TableStyle requestStyle = new TableStyle(icells, TABLE_WIDTHS, 100.0f, 1);
        PdfPTable iTable = requestStyle.buildElement();
        com.lowagie.text.Font tableContentFont = DocFileUtil.getSpecificFont(contentFontSize, 0);
        DocFileUtil.addCell(iTable, cellHeaderStyle, "1", tableContentFont);
        DocFileUtil.addCell(iTable, cellCenterStyle, "Content-Type", tableContentFont);
        DocFileUtil.addCell(iTable, cellContentStyle, "application/json; charset=UTF-8", tableContentFont);
        DocFileUtil.addCell(iTable, cellHeaderStyle, "2", tableContentFont);
        DocFileUtil.addCell(iTable, cellCenterStyle, "access_token", tableContentFont);
        DocFileUtil.addCell(iTable, cellCenterStyle, ResManager.loadKDString((String)"token\u7684\u503c", (String)"DocFileUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), tableContentFont);
        return iTable;
    }

    private static List<PdfPCell> buildCells(String[] texts, CellStyle style, com.lowagie.text.Font font) {
        ArrayList<PdfPCell> cells = new ArrayList<PdfPCell>(texts.length);
        for (String text : texts) {
            cells.add(style.buildElement(text, font));
        }
        return cells;
    }

    private static void addCell(PdfPTable table, CellStyle style, String text, com.lowagie.text.Font font) {
        table.addCell(style.buildElement(text, font));
    }

    static {
        TABLE_WIDTHS = new float[]{4.0f, 18.0f, 18.0f};
    }
}

