/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.apic.ApicError;
import kd.isc.iscb.platform.core.connector.apic.doc.ApiInfo;
import kd.isc.iscb.platform.core.connector.apic.doc.DocFileUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.AbstractDocGenerator;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.ExecuteApiDocGenerator;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.PullApiDocGenerator;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.PushApiDocGenerator;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.TransferApiDocGenerator;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class ExportDocForDataCopySchemaAPI {
    public static String generateDoc(DynamicObject schemaApi) {
        File file = DocFileUtil.newTempFile();
        OutputStream out = null;
        try {
            out = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            Document pdf = new Document(PageSize.A4);
            PdfWriter.getInstance((Document)pdf, (OutputStream)out);
            pdf.open();
            ExportDocForDataCopySchemaAPI.addInputsAndOutPuts(pdf, schemaApi);
            pdf.close();
        }
        catch (DocumentException | IOException e) {
            try {
                throw ApicError.PDF_WRITER_ERROR.wrap(e);
            }
            catch (Throwable throwable) {
                DbUtil.close(out);
                throw throwable;
            }
        }
        DbUtil.close((OutputStream)out);
        return file.getAbsolutePath();
    }

    private static void addInputsAndOutPuts(Document pdf, DynamicObject schemaApi) {
        String type = schemaApi.getString("type");
        ApiInfo apiInfo = new ApiInfo("api_number=" + schemaApi.get("number"), D.s((Object)schemaApi.get("number")), "isc_apic_by_dc_schema");
        AbstractDocGenerator generator = null;
        if ("PULL".equals(type)) {
            generator = new PullApiDocGenerator(pdf, schemaApi, apiInfo);
        } else if ("PUSH".equals(type)) {
            generator = new PushApiDocGenerator(pdf, schemaApi, apiInfo);
        } else if ("TRANSFER".equals(type)) {
            generator = new TransferApiDocGenerator(pdf, schemaApi, apiInfo);
        } else if ("EXECUTE".equals(type)) {
            generator = new ExecuteApiDocGenerator(pdf, schemaApi, apiInfo);
        } else {
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u63a5\u53e3\u7c7b\u578b-%s", (String)"ExportDocForDataCopySchemaAPI_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
        }
        generator.generatePdf();
    }
}

