/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.apic.ApicError;
import kd.isc.iscb.platform.core.connector.apic.doc.ApiInfo;
import kd.isc.iscb.platform.core.connector.apic.doc.DocFileUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.vc.VCExecuteApiDocGenerator;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class ExportDocForVCAPI {
    public static String generateDoc(DynamicObject vcApi) {
        File file = DocFileUtil.newTempFile();
        OutputStream out = null;
        try {
            out = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            Document pdf = new Document(PageSize.A4);
            PdfWriter.getInstance((Document)pdf, (OutputStream)out);
            pdf.open();
            ApiInfo apiInfo = new ApiInfo("/kapi/app/iscb/IntegrateVcApiDispatcher", "vc_api_num=" + vcApi.get("number"), D.s((Object)vcApi.get("number")), "isc_apic_by_vc");
            VCExecuteApiDocGenerator vcDocGenerator = new VCExecuteApiDocGenerator(pdf, vcApi, apiInfo);
            vcDocGenerator.generatePdf();
            pdf.close();
        }
        catch (DocumentException | IOException e) {
            try {
                throw ApicError.PDF_WRITER_ERROR.wrap(e);
            }
            catch (Throwable throwable) {
                DbUtil.close(out);
                throw throwable;
            }
        }
        DbUtil.close((OutputStream)out);
        return file.getAbsolutePath();
    }
}

