/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.apixml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.platform.core.api.ApiUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.ApiInfo;
import kd.isc.iscb.platform.core.connector.apic.doc.DocFileUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ApiToXmlPropStruct;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.Const;
import kd.isc.iscb.platform.core.util.ApiToXmlUtil;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.format.Format;
import kd.isc.iscb.util.misc.FileUtil;
import kd.isc.iscb.util.script.core.Reference;

public abstract class AbstractExportApiToXml
extends AbstractFormPlugin
implements Const {
    protected ApiInfo apiInfo;
    protected DynamicObject api;
    protected Map<String, Object> info = new HashMap<String, Object>(32);

    public AbstractExportApiToXml(DynamicObject api) {
        if (ApiUtil.isVersion2Api(api)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u53d1\u5e03\u5230\u5f00\u653e\u5e73\u53f02.0\u7248\u672c\u7684API\u6682\u4e0d\u652f\u6301\u5bfc\u51faWORD\u6587\u6863\uff0c\u5982\u6709\u9700\u8981\u53ef\u5bfc\u51faPDF\u6587\u6863\u3002", (String)"AbstractExportApiToXml_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        this.api = api;
    }

    public void export(IFormView view) {
        String fileName = this.getFileName();
        this.export(view, fileName);
    }

    private void export(IFormView view, String filename) {
        this.setInfo();
        this.exportApiWord(view, filename);
    }

    protected void setInfo() {
        this.setBasic();
        this.setInputAndOutput();
    }

    protected void setBasic() {
        String url = this.apiInfo.getNewUrl(this.api);
        if (this.api.getBoolean("auth_required")) {
            url = url + "?caller={{caller}}";
        }
        this.info.put("title", this.api.getString("name"));
        this.info.put("url", url);
        this.info.put("call_method", this.apiInfo.getMethod());
        this.info.put("content_format", this.apiInfo.getContentType());
        this.info.put("getToken", ResManager.loadKDString((String)"\u83b7\u53d6token\u8be6\u89c1\uff1a", (String)"AbstractExportApiToXml_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("params", ResManager.loadKDString((String)"\u53c2\u6570", (String)"AbstractExportApiToXml_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("seq", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"AbstractExportApiToXml_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("fieldName", ResManager.loadKDString((String)"\u5b57\u6bb5\u540d", (String)"AbstractExportApiToXml_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("fieldType", ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b", (String)"AbstractExportApiToXml_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("fieldDesc", ResManager.loadKDString((String)"\u5b57\u6bb5\u63cf\u8ff0", (String)"AbstractExportApiToXml_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("fieldOutput", ResManager.loadKDString((String)"\u8f93\u51fa\uff1a", (String)"AbstractExportApiToXml_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("fieldPK", ResManager.loadKDString((String)"\u4e3b\u952e", (String)"AbstractExportApiToXml_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("fieldOpType", ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b", (String)"AbstractExportApiToXml_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("fieldError", ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"AbstractExportApiToXml_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("inputExampleDesc", ResManager.loadKDString((String)"\u8f93\u5165\u6837\u4f8b\uff1a", (String)"AbstractExportApiToXml_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("outputExampleDesc", ResManager.loadKDString((String)"\u8f93\u51fa\u6837\u4f8b\uff1a", (String)"AbstractExportApiToXml_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("errorExampleDesc", ResManager.loadKDString((String)"\u5931\u8d25\u6837\u4f8b\uff1a", (String)"AbstractExportApiToXml_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("headDesc", ResManager.loadKDString((String)"\u8bf7\u6c42\u5934", (String)"AbstractExportApiToXml_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("inputTitle", ResManager.loadKDString((String)"\u8f93\u5165", (String)"AbstractExportApiToXml_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("arrayTitle", ResManager.loadKDString((String)"\u6570\u7ec4", (String)"AbstractExportApiToXml_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("requiredTitle", ResManager.loadKDString((String)"\u5fc5\u586b", (String)"AbstractExportApiToXml_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("defaultDesc", ResManager.loadKDString((String)"\u9ed8\u8ba4\u503c", (String)"AbstractExportApiToXml_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("resultUrl", ResManager.loadKDString((String)"\u7ed3\u679c\u67e5\u8be2URL\uff1a", (String)"AbstractExportApiToXml_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("inputDesc", ResManager.loadKDString((String)"\uff08\u5907\u6ce8\uff1a\u8f93\u5165\u7684\u96c6\u6210\u5bf9\u8c61\u662fmap\u7ed3\u6784\uff0c\u5206\u5f55\u662flist\u7ed3\u6784\uff0c\u96c6\u6210\u5bf9\u8c61\u5185\u8f93\u5165\u53c2\u6570\u53ef\u6309\u5b9e\u9645\u9700\u6c42\u586b\u5199\uff09", (String)"AbstractExportApiToXml_23", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("normalDesc", ResManager.loadKDString((String)"\u63cf\u8ff0", (String)"AbstractExportApiToXml_24", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("chaxunshurujieguo", ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u8f93\u5165", (String)"AbstractExportApiToXml_25", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("chaxunrizhihangshu", ResManager.loadKDString((String)"\u67e5\u8be2\u65e5\u5fd7\u884c\u6570", (String)"AbstractExportApiToXml_26", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("chaxunjieguoshuchu", ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u8f93\u51fa", (String)"AbstractExportApiToXml_27", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("jieguochaxun", ResManager.loadKDString((String)"\u7ed3\u679c\u67e5\u8be2", (String)"AbstractExportApiToXml_28", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("outputDesc", ResManager.loadKDString((String)"\uff08\u5907\u6ce8\uff1a\u82e5\u8f93\u51fa\u96c6\u6210\u5bf9\u8c61\uff0c\u90e8\u5206\u5c5e\u6027\u5217\u5728\u670d\u52a1\u6d41\u7a0b\u4e2d\u672a\u8d4b\u503c\u53ef\u80fd\u4e3a\u7a7a\uff09", (String)"AbstractExportApiToXml_29", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("paramsEntry", ResManager.loadKDString((String)"\u53c2\u6570\u5206\u5f55", (String)"AbstractExportApiToXml_30", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("fieldTitle", ResManager.loadKDString((String)"\u6807\u9898", (String)"AbstractExportApiToXml_31", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("houxuanjian", ResManager.loadKDString((String)"\u5019\u9009\u952e", (String)"AbstractExportApiToXml_32", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("fanhuijieguoziduanshuoming", ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u5b57\u6bb5\u8bf4\u660e\uff1a", (String)"AbstractExportApiToXml_33", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("meijujiegou", ResManager.loadKDString((String)"\u679a\u4e3e\u7c7b\u578b\u6570\u636e\u7ed3\u6784\uff1a", (String)"AbstractExportApiToXml_34", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("beizhu", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"AbstractExportApiToXml_35", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private void setInputAndOutput() {
        this.setInputTable();
        this.setOutputTable();
    }

    protected int setInputColum(String str, Map<String, Object> requires, Map<String, ApiToXmlPropStruct> apiStruct, int ik, int deep) {
        int line = 0;
        for (Map.Entry<String, Object> entry : requires.entrySet()) {
            ApiToXmlPropStruct apiToXmlPropStruct;
            String s = str == null ? entry.getKey() : str + '.' + entry.getKey();
            ApiToXmlPropStruct apiToXmlPropStruct2 = apiToXmlPropStruct = apiStruct.get(s) == null ? new ApiToXmlPropStruct(s, null, null) : apiStruct.get(s);
            if (entry.getValue() instanceof Integer && ApiToXmlUtil.isRef(apiStruct.get(s).getDataType())) {
                apiStruct.get(s).setDesc();
            }
            this.setInput(apiToXmlPropStruct, ++ik, deep, line++, requires.size());
            if (!(entry.getValue() instanceof Map)) continue;
            ik = this.setInputColum(s, (Map)entry.getValue(), apiStruct, ik, ++deep);
            --deep;
        }
        return ik;
    }

    protected int setOutputColum(String str, Map<String, Object> requires, Map<String, ApiToXmlPropStruct> apiStruct, int ik, int deep) {
        int line = 0;
        for (Map.Entry<String, Object> entry : requires.entrySet()) {
            ApiToXmlPropStruct apiToXmlPropStruct;
            String s = str == null ? entry.getKey() : str + '.' + entry.getKey();
            ApiToXmlPropStruct apiToXmlPropStruct2 = apiToXmlPropStruct = apiStruct.get(s) == null ? new ApiToXmlPropStruct(s, null, null) : apiStruct.get(s);
            if (entry.getValue() instanceof Integer && ApiToXmlUtil.isRef(apiStruct.get(s).getDataType())) {
                apiStruct.get(s).setDesc();
            }
            this.setOutput(apiToXmlPropStruct, ++ik, deep, line++, requires.size());
            if (!(entry.getValue() instanceof Map)) continue;
            ik = this.setOutputColum(s, (Map)entry.getValue(), apiStruct, ik, ++deep);
            --deep;
        }
        return ik;
    }

    protected void setInput(ApiToXmlPropStruct it, int ik, int deep, int line, int size) {
        ArrayList input = (ArrayList)this.info.get("input_table");
        if (input == null) {
            input = new ArrayList(8);
        }
        HashMap<String, Object> item = new HashMap<String, Object>(7);
        item.put("index", ik);
        item.put("field", ApiToXmlUtil.getPrefix(deep) + ApiToXmlUtil.getTabChar(deep, line, size) + ApiToXmlUtil.formatName(null, it.getName()));
        item.put("dataType", ApiToXmlUtil.translateType(it.getDataType()));
        item.put("desc", ApiToXmlUtil.formatDesc(it.getDesc()));
        item.put("isArray", it.isTrueOne() ? ResManager.loadKDString((String)"\u662f", (String)"AbstractExportApiToXml_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"AbstractExportApiToXml_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        item.put("need", it.isTrueTwo() ? ResManager.loadKDString((String)"\u662f", (String)"AbstractExportApiToXml_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"AbstractExportApiToXml_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        item.put("defaultValue", it.getFlexFour());
        input.add(item);
        this.info.put("input_table", input);
    }

    protected void setOutput(ApiToXmlPropStruct it, int ik, int deep, int line, int size) {
        ArrayList output = (ArrayList)this.info.get("output_table");
        if (output == null) {
            output = new ArrayList(8);
        }
        HashMap<String, Object> item = new HashMap<String, Object>(7);
        item.put("index", ik);
        item.put("field", ApiToXmlUtil.getPrefix(deep) + ApiToXmlUtil.getTabChar(deep, line, size) + ApiToXmlUtil.formatName(null, it.getName()));
        item.put("dataType", ApiToXmlUtil.translateType(it.getDataType()));
        item.put("desc", ApiToXmlUtil.formatDesc(it.getDesc()));
        item.put("isArray", it.isTrueOne() ? ResManager.loadKDString((String)"\u662f", (String)"AbstractExportApiToXml_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"AbstractExportApiToXml_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        output.add(item);
        this.info.put("output_table", output);
    }

    protected void setTable(DynamicObjectCollection params, String field, DynamicObject meta, boolean isInput) {
        ArrayList<DynamicObject> supplier = new ArrayList<DynamicObject>();
        Map<String, ApiToXmlPropStruct> apiStruct = this.setApiStruct(params, isInput, supplier);
        Map<String, Object> requires = ApiToXmlUtil.existPuts(meta, field, supplier);
        if (isInput) {
            this.setInputColum(null, requires, apiStruct, 0, 0);
            this.setSample(requires, "inputSample", meta, isInput);
        } else {
            this.setOutputColum(null, requires, apiStruct, 0, 0);
            this.setSample(requires, "outputSample", meta, isInput);
        }
    }

    private Map<String, ApiToXmlPropStruct> setApiStruct(DynamicObjectCollection puts, boolean isInput, List<DynamicObject> supplier) {
        HashMap<String, ApiToXmlPropStruct> apiStruct = new HashMap<String, ApiToXmlPropStruct>(puts.size());
        if (isInput) {
            this.setInputApiStruct(puts, apiStruct, supplier);
        } else {
            this.setOutputApiStruct(puts, apiStruct, supplier);
        }
        return apiStruct;
    }

    private void exportApiWord(IFormView view, String fileName) {
        File file = this.getWordFile(fileName);
        ExportAndImportFormUtil.download(view, file.getAbsolutePath(), ExportAndImportFormUtil.getDownloadFileName(this.api) + ".doc");
    }

    private File getWordFile(String fileName) {
        String xml = this.readXml(fileName);
        HashMap<String, Reference> ctx = new HashMap<String, Reference>(1);
        ctx.put("info", Reference.create((String)"info"));
        Format format = Format.parse((String)xml, ctx);
        HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>(1);
        data.put("info", this.info);
        String result = format.translate(data);
        return this.outputXml(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readXml(String fileName) {
        String xml;
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(fileName);
        if (in == null) {
            throw new IscBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8d44\u6e90\u6587\u4ef6\uff01", (String)"AbstractExportApiToXml_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        try {
            xml = FileUtil.read((InputStream)in);
        }
        finally {
            DbUtil.close((InputStream)in);
        }
        return xml;
    }

    private File outputXml(String string) {
        File file;
        File file2 = DocFileUtil.newTempXmlFile();
        OutputStream out = null;
        try {
            out = Files.newOutputStream(file2.toPath(), new OpenOption[0]);
            out.write(string.getBytes(StandardCharsets.UTF_8));
            file = file2;
        }
        catch (IOException e) {
            try {
                throw CommonError.OUTPUT_WRITER_FAILURE.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(out);
                throw throwable;
            }
        }
        DbUtil.close((OutputStream)out);
        return file;
    }

    protected abstract String getFileName();

    protected abstract void setInputTable();

    protected abstract void setOutputTable();

    protected abstract void setInputApiStruct(DynamicObjectCollection var1, Map<String, ApiToXmlPropStruct> var2, List<DynamicObject> var3);

    protected abstract void setOutputApiStruct(DynamicObjectCollection var1, Map<String, ApiToXmlPropStruct> var2, List<DynamicObject> var3);

    protected abstract void setSample(Map<String, Object> var1, String var2, DynamicObject var3, boolean var4);
}

