/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.apixml;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.apic.doc.ApiInfo;
import kd.isc.iscb.platform.core.connector.apic.doc.JsonSampleUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.AbstractExportApiToXml;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ApiToXmlPropStruct;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ExportTriggerApiToXml;
import kd.isc.iscb.platform.core.util.ApiToXmlUtil;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.dt.D;

public class ExportSchemaApiToXml
extends AbstractExportApiToXml {
    private final String type;
    private final DynamicObject schema;
    private final DynamicObject srcMeta;
    private final DynamicObject tarMeta;

    public ExportSchemaApiToXml(DynamicObject api) {
        super(api);
        this.type = this.api.getString("type");
        this.schema = BusinessDataServiceHelper.loadSingle((Object)this.api.get("schema_id"), (String)"isc_data_copy");
        this.apiInfo = new ApiInfo("/kapi/app/iscb/dc", "", D.s((Object)api.get("number")), "isc_apic_by_dc_schema");
        this.srcMeta = BusinessDataServiceHelper.loadSingle((Object)this.schema.getDynamicObject("source_schema").getPkValue(), (String)"isc_metadata_schema");
        this.tarMeta = BusinessDataServiceHelper.loadSingle((Object)this.schema.getDynamicObject("target_schema").getPkValue(), (String)"isc_metadata_schema");
    }

    @Override
    protected String getFileName() {
        String fileName;
        switch (this.api.getString("type")) {
            case "PULL": {
                fileName = "xml/schemaPullTemplete.xml";
                break;
            }
            case "PUSH": {
                fileName = "xml/schemaPushTemplete.xml";
                break;
            }
            case "TRANSFER": {
                fileName = "xml/schemaTransferTemplete.xml";
                break;
            }
            case "EXECUTE": {
                fileName = "xml/schemaExecuteTemplete.xml";
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u63a5\u53e3\u7c7b\u578b-%s", (String)"ExportSchemaApiToXml_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.api.getString("type")));
            }
        }
        return fileName;
    }

    @Override
    protected void setInputTable() {
        switch (this.type) {
            case "EXECUTE": 
            case "PULL": {
                DynamicObjectCollection params = this.schema.getDynamicObjectCollection("param_entries");
                this.setTable(params, "params_name", null, ApiToXmlUtil.isInput("params_name"));
                break;
            }
            case "TRANSFER": 
            case "PUSH": {
                DynamicObjectCollection params = this.schema.getDynamicObjectCollection("mapping_entries");
                this.setTable(params, "mapping_src_column", this.srcMeta, ApiToXmlUtil.isInput("mapping_src_column"));
                break;
            }
        }
    }

    @Override
    protected void setInputApiStruct(DynamicObjectCollection inputs, Map<String, ApiToXmlPropStruct> apiStruct, List<DynamicObject> supplier) {
        switch (this.type) {
            case "PULL": 
            case "EXECUTE": {
                ExportTriggerApiToXml.setExecuteInputApiStruct(inputs, apiStruct, supplier);
                break;
            }
            case "PUSH": 
            case "TRANSFER": {
                ExportTriggerApiToXml.setPushInputApiStruct(inputs, apiStruct, supplier, this.srcMeta, this.schema);
                break;
            }
        }
    }

    @Override
    protected void setOutputApiStruct(DynamicObjectCollection outputs, Map<String, ApiToXmlPropStruct> apiStruct, List<DynamicObject> supplier) {
        switch (this.type) {
            case "PULL": 
            case "TRANSFER": {
                ExportSchemaApiToXml.setTrOrPuOutputApiStruct(outputs, apiStruct, supplier, this.tarMeta);
                break;
            }
        }
    }

    public static void setTrOrPuOutputApiStruct(DynamicObjectCollection outputs, Map<String, ApiToXmlPropStruct> apiStruct, List<DynamicObject> supplier, DynamicObject meta) {
        for (DynamicObject it : outputs) {
            if (ApiToXmlUtil.hasNoMapping(it, "mapping_src_column")) continue;
            String mappingTarColumn = it.getString("mapping_tar_column");
            String dataType = ApiToXmlUtil.getProperty(meta, mappingTarColumn, "data_type");
            String tarDesc = ApiToXmlUtil.getProperty(meta, mappingTarColumn, "prop_label");
            apiStruct.put(mappingTarColumn, new ApiToXmlPropStruct(mappingTarColumn, dataType, tarDesc));
            if (ApiToXmlUtil.isEntries(dataType)) continue;
            supplier.add(it);
        }
    }

    @Override
    protected void setOutputTable() {
        switch (this.type) {
            case "PULL": 
            case "TRANSFER": {
                DynamicObjectCollection params = this.schema.getDynamicObjectCollection("mapping_entries");
                this.setTable(params, "mapping_tar_column", this.tarMeta, ApiToXmlUtil.isInput("mapping_tar_column"));
                break;
            }
            case "PUSH": 
            case "EXECUTE": {
                break;
            }
        }
    }

    @Override
    protected void setSample(Map<String, Object> requires, String sampleName, DynamicObject meta, boolean isInput) {
        String sample = null;
        sample = isInput ? this.setInputSampleData(requires, meta, sample) : this.setOutputSampleData(requires, meta, sample);
        sample = sample != null ? sample.replace("\n", "</w:t></w:r>\u3000</w:p><w:p><w:r><w:t>\u3000\u3000") : null;
        this.info.put(sampleName, sample);
    }

    private String setOutputSampleData(Map<String, Object> requires, DynamicObject meta, String sample) {
        switch (this.type) {
            case "PULL": 
            case "TRANSFER": {
                JSONObject data = JsonSampleUtil.parseRequires(meta.getLong("id"), requires);
                sample = JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replace("\t", "    ");
                break;
            }
        }
        return sample;
    }

    private String setInputSampleData(Map<String, Object> requires, DynamicObject meta, String sample) {
        switch (this.type) {
            case "TRANSFER": 
            case "PUSH": {
                JSONObject data = JsonSampleUtil.parseRequires(meta.getLong("id"), requires);
                sample = JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replace("\t", "    ");
                break;
            }
            case "PULL": 
            case "EXECUTE": {
                sample = JSON.toJSONString(requires, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replace("\t", "    ");
                break;
            }
        }
        return sample;
    }

    @Override
    protected void setInput(ApiToXmlPropStruct it, int ik, int deep, int line, int size) {
        ArrayList input = (ArrayList)this.info.get("input_table");
        if (input == null) {
            input = new ArrayList(8);
        }
        HashMap<String, Object> item = new HashMap<String, Object>(7);
        item.put("index", ik);
        item.put("field", ApiToXmlUtil.getPrefix(deep) + ApiToXmlUtil.getTabChar(deep, line, size) + ApiToXmlUtil.formatName(this.srcMeta, it.getName()));
        String dataType = CommonUtil.isEmpty(it.getDataType()) ? ApiToXmlUtil.getProperty(this.srcMeta, it.getName(), "data_type") : it.getDataType();
        item.put("dataType", dataType);
        String desc = CommonUtil.isEmpty(it.getDesc()) ? ApiToXmlUtil.getProperty(this.srcMeta, it.getName(), "prop_label") : it.getDesc();
        item.put("desc", ApiToXmlUtil.formatDesc(desc));
        input.add(item);
        this.info.put("input_table", input);
    }

    @Override
    protected void setOutput(ApiToXmlPropStruct it, int ik, int deep, int line, int size) {
        ArrayList output = (ArrayList)this.info.get("output_table");
        if (output == null) {
            output = new ArrayList(8);
        }
        HashMap<String, Object> item = new HashMap<String, Object>(7);
        item.put("index", ik);
        item.put("field", ApiToXmlUtil.getPrefix(deep) + ApiToXmlUtil.getTabChar(deep, line, size) + ApiToXmlUtil.formatName(this.tarMeta, it.getName()));
        String dataType = CommonUtil.isEmpty(it.getDataType()) ? ApiToXmlUtil.getProperty(this.tarMeta, it.getName(), "data_type") : it.getDataType();
        item.put("dataType", dataType);
        String desc = CommonUtil.isEmpty(it.getDesc()) ? ApiToXmlUtil.getProperty(this.tarMeta, it.getName(), "prop_label") : it.getDesc();
        item.put("desc", ApiToXmlUtil.formatDesc(desc));
        output.add(item);
        this.info.put("output_table", output);
    }
}

