/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.apixml;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.api.ApiUtil;
import kd.isc.iscb.platform.core.apic.ScriptApiMeta;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.AbstractExportApiToXml;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ApiToXmlPropStruct;
import kd.isc.iscb.platform.core.connector.apic.doc.external.CommonApiDocBuilder;
import kd.isc.iscb.platform.core.util.ApiToXmlUtil;

public class ExportScriptApiToXml
extends AbstractExportApiToXml {
    private final ScriptApiMeta smeta;

    public ExportScriptApiToXml(DynamicObject api) {
        super(api);
        this.smeta = ScriptApiMeta.getByNumber(this.api.getString("number"));
    }

    @Override
    protected void setBasic() {
        this.info.put("headDesc", ResManager.loadKDString((String)"\u8bf7\u6c42\u5934", (String)"AbstractExportApiToXml_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("inputTitle", ResManager.loadKDString((String)"\u8f93\u5165", (String)"AbstractExportApiToXml_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("fieldOutput", ResManager.loadKDString((String)"\u8f93\u51fa\uff1a", (String)"AbstractExportApiToXml_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("inputExampleDesc", ResManager.loadKDString((String)"\u8f93\u5165\u6837\u4f8b\uff1a", (String)"AbstractExportApiToXml_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("outputExampleDesc", ResManager.loadKDString((String)"\u8f93\u51fa\u6837\u4f8b\uff1a", (String)"AbstractExportApiToXml_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("seq", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"AbstractExportApiToXml_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("fieldName", ResManager.loadKDString((String)"\u5b57\u6bb5\u540d", (String)"AbstractExportApiToXml_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("fieldType", ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b", (String)"AbstractExportApiToXml_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("fieldDesc", ResManager.loadKDString((String)"\u5b57\u6bb5\u63cf\u8ff0", (String)"AbstractExportApiToXml_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("defaultDesc", ResManager.loadKDString((String)"\u9ed8\u8ba4\u503c", (String)"AbstractExportApiToXml_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("arrayTitle", ResManager.loadKDString((String)"\u6570\u7ec4", (String)"AbstractExportApiToXml_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("requiredTitle", ResManager.loadKDString((String)"\u5fc5\u586b", (String)"AbstractExportApiToXml_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("getToken", ResManager.loadKDString((String)"\u83b7\u53d6token\u8be6\u89c1\uff1a", (String)"AbstractExportApiToXml_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("number", String.format(ResManager.loadKDString((String)"\u7f16\u7801\uff1a%s", (String)"ExportScriptApiToXml_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.smeta.getNumber()));
        this.info.put("auth_required", String.format(ResManager.loadKDString((String)"\u9700\u8981\u6388\u6743\uff1a%s", (String)"ExportScriptApiToXml_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.smeta.isAuthRequired() ? ResManager.loadKDString((String)"\u662f", (String)"ExportScriptApiToXml_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ExportScriptApiToXml_13", (String)"isc-iscb-platform-core", (Object[])new Object[0])));
        this.info.put("record_log", String.format(ResManager.loadKDString((String)"\u8bb0\u5f55\u65e5\u5fd7\uff1a%s", (String)"ExportScriptApiToXml_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.smeta.isRecordLog() ? ResManager.loadKDString((String)"\u662f", (String)"ExportScriptApiToXml_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ExportScriptApiToXml_13", (String)"isc-iscb-platform-core", (Object[])new Object[0])));
        this.info.put("description", ResManager.loadKDString((String)"\u5907\u6ce8\uff1a", (String)"ExportScriptApiToXml_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("description_content", this.api.getString("description"));
        this.info.put("title", this.api.getString("name"));
        String url = ApiUtil.isVersion2Api(this.smeta.getDynamicObject()) ? "URL:/kapi/v2/iscb/route/script_" + this.api.get("number") : "URL:/kapi/app/iscb/script_" + this.api.get("number");
        if (this.smeta.isAuthRequired()) {
            url = url + "?caller={{caller}}";
        }
        this.info.put("url", url);
        this.info.put("call_method", ResManager.loadKDString((String)"\u8c03\u7528\u65b9\u6cd5\uff1aPOST", (String)"ExportScriptApiToXml_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.info.put("content_format", ResManager.loadKDString((String)"\u5185\u5bb9\u683c\u5f0f\uff1aapplication/json; charset=UTF-8", (String)"ExportScriptApiToXml_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    protected void setInputApiStruct(DynamicObjectCollection inputs, Map<String, ApiToXmlPropStruct> apiStruct, List<DynamicObject> supplier) {
        for (DynamicObject it : inputs) {
            String inputField = it.getString("input_field");
            String inputDataType = it.getString("input_data_type");
            String inputDescription = it.getString("input_description");
            Boolean isArray = it.getBoolean("input_is_array");
            Boolean need = it.getBoolean("required");
            String defaultValue = it.getString("default_value");
            apiStruct.put(inputField, new ApiToXmlPropStruct(inputField, inputDataType, inputDescription, isArray, need, defaultValue));
            if (ApiToXmlUtil.isEntries(inputDataType)) continue;
            supplier.add(it);
        }
    }

    @Override
    protected void setOutputApiStruct(DynamicObjectCollection outputs, Map<String, ApiToXmlPropStruct> apiStruct, List<DynamicObject> supplier) {
        for (DynamicObject it : outputs) {
            String outputField = it.getString("output_field");
            String outputDataType = it.getString("output_data_type");
            String outputDescription = it.getString("output_description");
            Boolean isArray = it.getBoolean("output_is_array");
            apiStruct.put(outputField, new ApiToXmlPropStruct(outputField, outputDataType, outputDescription, isArray));
            if (ApiToXmlUtil.isEntries(outputDataType)) continue;
            supplier.add(it);
        }
    }

    @Override
    protected String getFileName() {
        return "xml/scriptAndExternalTemplete.xml";
    }

    @Override
    protected void setInputTable() {
        DynamicObjectCollection params = this.api.getDynamicObjectCollection("inputs");
        this.setTable(params, "input_field", null, ApiToXmlUtil.isInput("input_field"));
    }

    @Override
    protected void setOutputTable() {
        DynamicObjectCollection params = this.api.getDynamicObjectCollection("outputs");
        this.setTable(params, "output_field", null, ApiToXmlUtil.isInput("output_field"));
    }

    @Override
    protected void setSample(Map<String, Object> requires, String sampleName, DynamicObject meta, boolean isInput) {
        String sample = isInput ? CommonApiDocBuilder.getInstance().getInputParamSimpleString(this.smeta.getInputs()) : CommonApiDocBuilder.getInstance().getOutputParamSimpleString(this.smeta.getDynamicObject(), this.smeta.getOutputs());
        sample = sample.replace("\n", "</w:t></w:r>\u3000</w:p><w:p><w:r><w:t>\u3000\u3000");
        this.info.put(sampleName, sample);
    }
}

