/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.meta;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.util.Iterator;
import java.util.Map;
import kd.isc.iscb.platform.core.apic.ApicError;
import kd.isc.iscb.platform.core.connector.apic.doc.DocFileUtil;

public abstract class AbstractPdfTableFormatter {
    protected PdfPTable createTableWithHeader() {
        Map<String, Float> header = this.getHeaderInfo();
        PdfPTable table = new PdfPTable(header.size());
        this.setWidths(table, header);
        table.setWidthPercentage(100.0f);
        Font font = DocFileUtil.getSpecificFont(12.0f, 1);
        for (String key : header.keySet()) {
            this.addCell(table, font, key);
        }
        table.setHeaderRows(1);
        return table;
    }

    private void setWidths(PdfPTable table, Map<String, Float> header) {
        try {
            float[] widths = new float[header.size()];
            int i = 0;
            Iterator<Float> iter = header.values().iterator();
            while (iter.hasNext()) {
                widths[i++] = iter.next().floatValue();
            }
            table.setWidths(widths);
        }
        catch (DocumentException e) {
            throw ApicError.PDF_WRITER_ERROR.wrap((Throwable)e);
        }
    }

    private void addCell(PdfPTable table, Font font, String key) {
        PdfPCell cell = new PdfPCell();
        cell.setBorderWidth(0.25f);
        cell.setPadding(3.0f);
        cell.setRowspan(1);
        cell.setColspan(1);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        Phrase phrase = new Phrase();
        phrase.setFont(font);
        if (key != null) {
            phrase.add((Element)new Chunk(key, font));
        }
        cell.setPhrase(phrase);
        table.addCell(cell);
    }

    protected abstract Map<String, Float> getHeaderInfo();

    public abstract PdfPTable getTableWithHeader();
}

