/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.microservice;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.apic.ApicError;
import kd.isc.iscb.platform.core.connector.apic.doc.ApiInfo;
import kd.isc.iscb.platform.core.connector.apic.doc.DocFileUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.PdfGenerator;
import kd.isc.iscb.platform.core.util.ApiToXmlUtil;
import kd.isc.iscb.util.dt.D;

public class MicroServiceApiDocGenerator
implements PdfGenerator {
    private static final float[] TABLEWIDTH = new float[]{12.0f, 50.0f, 50.0f, 45.0f};
    private final DynamicObject microService;
    private final ApiInfo apiInfo;
    protected Document pdf;

    public MicroServiceApiDocGenerator(Document pdf, DynamicObject microService, ApiInfo apiInfo) {
        this.pdf = pdf;
        this.microService = microService;
        this.apiInfo = apiInfo;
    }

    @Override
    public void generatePdf() {
        try {
            this.addBasic();
            this.addInput();
            this.addOutput();
        }
        catch (DocumentException e) {
            throw ApicError.PDF_WRITER_ERROR.wrap((Throwable)e);
        }
    }

    private void addOutput() throws DocumentException {
        DynamicObjectCollection dynamicObjects = this.microService.getDynamicObjectCollection("outputs");
        if (dynamicObjects.isEmpty()) {
            return;
        }
        this.addInputAndOutputTitle(ResManager.loadKDString((String)"\u8f93\u51fa:", (String)"MicroServiceApiDocGenerator_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        PdfPTable table = this.getOutputPdfPTable(dynamicObjects);
        this.pdf.add((Element)table);
    }

    private PdfPTable getOutputPdfPTable(DynamicObjectCollection dynamicObjects) throws DocumentException {
        PdfPTable table = this.createHeader();
        Font font = DocFileUtil.getSpecificFont(12.0f, 0);
        int index = 0;
        for (DynamicObject entry : dynamicObjects) {
            index = this.setOutputTable(table, index, font, entry);
        }
        return table;
    }

    private void addInputAndOutputTitle(String text) throws DocumentException {
        this.addNormalText(text);
    }

    private void addNormalText(String text) throws DocumentException {
        BaseFont baseFont = DocFileUtil.getBaseFont();
        Font font = new Font(baseFont, 14.0f, 0);
        this.addText(text, font, 0);
    }

    private void addInput() throws DocumentException {
        DynamicObjectCollection dynamicObjects = this.microService.getDynamicObjectCollection("inputs");
        if (dynamicObjects.isEmpty()) {
            return;
        }
        this.addInputAndOutputTitle(ResManager.loadKDString((String)"\u8f93\u5165\uff1a", (String)"MicroServiceApiDocGenerator_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        PdfPTable table = this.createHeader();
        int index = 0;
        Font font = DocFileUtil.getSpecificFont(12.0f, 0);
        for (DynamicObject entry : dynamicObjects) {
            index = this.setInputTable(table, index, font, entry);
        }
        this.pdf.add((Element)table);
    }

    private int setInputTable(PdfPTable table, int index, Font font, DynamicObject var) {
        this.addCell(table, font, String.valueOf(++index), 1);
        this.addCell(table, font, D.s((Object)var.get("input_field")), 0);
        this.addCell(table, font, ApiToXmlUtil.translateType(D.s((Object)var.get("input_data_type"))), 0);
        this.addCell(table, font, D.s((Object)var.get("input_description")), 0);
        return index;
    }

    private int setOutputTable(PdfPTable table, int index, Font font, DynamicObject var) {
        this.addCell(table, font, String.valueOf(++index), 1);
        this.addCell(table, font, D.s((Object)var.get("output_field")), 0);
        this.addCell(table, font, ApiToXmlUtil.translateType(D.s((Object)var.get("output_data_type"))), 0);
        this.addCell(table, font, D.s((Object)var.get("output_description")), 0);
        return index;
    }

    private PdfPTable createHeader() throws DocumentException {
        PdfPTable table = new PdfPTable(4);
        table.setWidths(TABLEWIDTH);
        table.setWidthPercentage(100.0f);
        Font font = DocFileUtil.getSpecificFont(12.0f, 1);
        this.addCell(table, font, ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"MicroServiceApiDocGenerator_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        this.addCell(table, font, ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"MicroServiceApiDocGenerator_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        this.addCell(table, font, ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b", (String)"MicroServiceApiDocGenerator_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        this.addCell(table, font, ResManager.loadKDString((String)"\u63cf\u8ff0", (String)"MicroServiceApiDocGenerator_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        table.setHeaderRows(1);
        return table;
    }

    private void addCell(PdfPTable table, Font font, String text, int align) {
        PdfPCell cell = new PdfPCell();
        cell.setBorderWidth(0.25f);
        cell.setPadding(3.0f);
        cell.setRowspan(1);
        cell.setColspan(1);
        cell.setHorizontalAlignment(align);
        cell.setVerticalAlignment(5);
        Phrase phrase = new Phrase();
        phrase.setFont(font);
        if (text != null) {
            phrase.add((Element)new Chunk(text, font));
        }
        cell.setPhrase(phrase);
        table.addCell(cell);
    }

    private void addBasic() throws DocumentException {
        this.addTitle();
        this.addurl();
        this.addMethod();
        this.addContentType();
        this.addInfo();
    }

    private void addurl() throws DocumentException {
        String url = String.format(ResManager.loadKDString((String)"API\u8c03\u7528:%s", (String)"MicroServiceApiDocGenerator_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.apiInfo.getNewUrl(this.microService));
        if (this.microService.getBoolean("auth_required")) {
            url = url + "?caller={{caller}}";
        }
        this.addNormalText(url);
    }

    private void addMethod() throws DocumentException {
        this.addNormalText(this.apiInfo.getMethod());
    }

    private void addContentType() throws DocumentException {
        this.addNormalText(ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u90e8\uff1a", (String)"MicroServiceApiDocGenerator_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        Element table = DocFileUtil.getRequestHeaderTable(12.0f, 12.0f);
        this.pdf.add(table);
        this.addNormalText(ResManager.loadKDString((String)"\u83b7\u53d6token\u8be6\u89c1\uff1ahttps://dev.kingdee.com/index/docsNew/6668c5c0-b547-4f55-8f74-cc6ea2f5c65c", (String)"CommonApiDocBuilder_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private String getServiceType(String type) {
        switch (type) {
            case "bos": {
                return ResManager.loadKDString((String)"\u5e73\u53f0", (String)"MicroServiceApiDocGenerator_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "biz": {
                return ResManager.loadKDString((String)"\u4e1a\u52a1", (String)"MicroServiceApiDocGenerator_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "isv": {
                return ResManager.loadKDString((String)"\u4e8c\u5f00", (String)"MicroServiceApiDocGenerator_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
        }
        return type;
    }

    private void addInfo() throws DocumentException {
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u7c7b\u578b\uff1a%s", (String)"MicroServiceApiDocGenerator_23", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.getServiceType(this.microService.getString("service_type"))));
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u4e91ID\u6216\u5de5\u5382\u7c7b\u524d\u7f00\uff08cloudId\uff09\uff1a%s", (String)"MicroServiceApiDocGenerator_24", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.microService.get("cloudid")));
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u5e94\u7528ID\uff08appId\uff09\uff1a%s", (String)"MicroServiceApiDocGenerator_25", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.microService.get("appid")));
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u540d\u79f0\uff08serviceName\uff09\uff1a%s", (String)"MicroServiceApiDocGenerator_26", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.microService.get("service_name")));
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u65b9\u6cd5\u540d\uff08method\uff09\uff1a%s", (String)"MicroServiceApiDocGenerator_27", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.microService.get("method")));
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u63cf\u8ff0\uff1a%s", (String)"MicroServiceApiDocGenerator_28", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.microService.get("remark")));
        String version = this.microService.getString("openapi_version");
        if (!D.x((Object)this.microService.get("not_publish"))) {
            if ("2".equals(version)) {
                this.addNormalText(ResManager.loadKDString((String)"\u5f00\u653e\u5e73\u53f0\u7248\u672c\uff1a2.0", (String)"MicroServiceApiDocGenerator_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                this.addNormalText(String.format(ResManager.loadKDString((String)"\u547d\u540d\u7a7a\u95f4\uff1a%s", (String)"MicroServiceApiDocGenerator_29", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.microService.get("namespace")));
                this.addNormalText(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u540d\uff1a%s", (String)"MicroServiceApiDocGenerator_30", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.microService.get("wsinputparam")));
                this.addNormalText(String.format(ResManager.loadKDString((String)"\u8f93\u51fa\u53c2\u6570\u540d\uff1a%s", (String)"MicroServiceApiDocGenerator_31", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.microService.get("wsoutputparam")));
            } else {
                this.addNormalText(ResManager.loadKDString((String)"\u5f00\u653e\u5e73\u53f0\u7248\u672c\uff1a1.0", (String)"MicroServiceApiDocGenerator_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
        }
    }

    private void addTitle() throws DocumentException {
        BaseFont baseFont = DocFileUtil.getBaseFont();
        Font font = new Font(baseFont, 16.0f, 0);
        this.addText(this.microService.getString("name"), font, 1);
    }

    private void addText(String text, Font font, int align) throws DocumentException {
        Paragraph p = new Paragraph();
        p.setFont(font);
        if (text != null) {
            p.add((Element)new Chunk(text, font));
        }
        p.setSpacingAfter(10.0f);
        p.setAlignment(align);
        this.pdf.add((Element)p);
    }
}

