/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.serviceflow;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.api.openapi.v2.IscApiUtil;
import kd.isc.iscb.platform.core.apic.ApicError;
import kd.isc.iscb.platform.core.connector.apic.doc.ApiInfo;
import kd.isc.iscb.platform.core.connector.apic.doc.DocFileUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.JsonSampleUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.PdfGenerator;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.util.ApiToXmlUtil;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Variable;
import kd.isc.iscb.util.flow.core.i.model.VariableImpl;

public class ServiceFlowApiDocGenerator
implements PdfGenerator {
    private static final String SUCCESS = "success";
    private static final float[] TABLEWIDTH = new float[]{12.0f, 70.0f, 50.0f, 25.0f, 20.0f};
    private final DynamicObject sfApi;
    private final ApiInfo apiInfo;
    protected Document pdf;

    public ServiceFlowApiDocGenerator(Document pdf, DynamicObject sfApi, ApiInfo apiInfo) {
        this.pdf = pdf;
        this.sfApi = sfApi;
        this.apiInfo = apiInfo;
    }

    public static void setSampleStructByIsVariant(Map<String, Object> input, Variable var, String defaultValue) {
        boolean isVariant = ApiToXmlUtil.isVariant(var.getType().toString());
        if (!((VariableImpl)var).isArray()) {
            if (isVariant) {
                input.put(var.getName(), ApiToXmlUtil.getMap());
            } else {
                input.put(var.getName(), defaultValue);
            }
        } else {
            ArrayList<Object> l = new ArrayList<Object>(1);
            if (isVariant) {
                l.add(ApiToXmlUtil.getMap());
            } else {
                l.add(defaultValue);
            }
            input.put(var.getName(), l);
        }
    }

    @Override
    public void generatePdf() {
        try {
            this.addBasic();
            this.addInput();
            this.addOutput();
            this.addSample();
        }
        catch (DocumentException e) {
            throw ApicError.PDF_WRITER_ERROR.wrap((Throwable)e);
        }
    }

    private void addBasic() throws DocumentException {
        this.addTitle();
        this.addurl();
        this.addMethod();
        this.addContentType();
    }

    private void addTitle() throws DocumentException {
        BaseFont baseFont = DocFileUtil.getBaseFont();
        Font font = new Font(baseFont, 16.0f, 0);
        this.addText(this.sfApi.getString("name"), font, 1);
    }

    private void addContentType() throws DocumentException {
        this.addNormalText(ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u90e8\uff1a", (String)"ServiceFlowApiDocGenerator_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        Element table = DocFileUtil.getRequestHeaderTable(12.0f, 12.0f);
        this.pdf.add(table);
        this.addNormalText(ResManager.loadKDString((String)"\u83b7\u53d6token\u8be6\u89c1\uff1ahttps://dev.kingdee.com/index/docsNew/6668c5c0-b547-4f55-8f74-cc6ea2f5c65c", (String)"CommonApiDocBuilder_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private void addMethod() throws DocumentException {
        this.addNormalText(this.apiInfo.getMethod());
    }

    private void addurl() throws DocumentException {
        String url = String.format(ResManager.loadKDString((String)"API\u8c03\u7528:%s", (String)"ServiceFlowApiDocGenerator_29", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.apiInfo.getNewUrl(this.sfApi));
        if (this.sfApi.getBoolean("auth_required")) {
            url = url + "?caller={{caller}}";
        }
        this.addNormalText(url);
        if (this.sfApi.getBoolean("asyn")) {
            this.addNormalText(ResManager.loadKDString((String)"\u7ed3\u679c\u67e5\u8be2URL:/kapi/app/iscb/SFApiOutputDispatcher", (String)"ServiceFlowApiDocGenerator_30", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    private void addInput() throws DocumentException {
        long flowId = ServiceFlowParser.findReleasedFlowId(this.sfApi.getLong("service_flow_id"));
        List variables = ServiceFlowParser.getFlow(flowId).getInputVariables();
        if (CollectionUtils.isEmpty(variables)) {
            return;
        }
        this.addInputAndOutputTitle(ResManager.loadKDString((String)"\u8f93\u5165\uff1a\uff08\u5907\u6ce8\uff1a\u8f93\u5165\u7684\u96c6\u6210\u5bf9\u8c61\u662fmap\u7ed3\u6784\uff0c\u5206\u5f55\u662flist\u7ed3\u6784\uff0c\u96c6\u6210\u5bf9\u8c61\u5185\u8f93\u5165\u53c2\u6570\u53ef\u6309\u5b9e\u9645\u9700\u6c42\u586b\u5199\uff09", (String)"ServiceFlowApiDocGenerator_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        PdfPTable table = this.createHeader();
        int index = 0;
        int line = 0;
        Font font = DocFileUtil.getSpecificFont(12.0f, 0);
        for (Variable var : variables) {
            index = this.setTableByVariable(table, index, font, var, line++, 0, variables.size());
            if (!ApiToXmlUtil.isVariant(D.s((Object)var.getType()))) continue;
            index = this.addInputOfVariant(table, index, font, var);
        }
        this.pdf.add((Element)table);
    }

    private int addInputOfVariant(PdfPTable table, int index, Font font, Variable var) {
        Map varDefine = (Map)var.getAttribute("define");
        if ("isc_metadata_schema".equalsIgnoreCase(D.s(varDefine.get("category")))) {
            DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)D.s(varDefine.get("type")), (String)"isc_metadata_schema");
            return this.setTableByMeta(table, index, font, item, 1);
        }
        return index;
    }

    private int setTableByVariable(PdfPTable table, int index, Font font, Variable var, int line, int deep, int size) {
        this.addCell(table, font, String.valueOf(++index), 1);
        this.addCell(table, font, ApiToXmlUtil.getPrefix(deep) + ApiToXmlUtil.getTabChar(deep, line, size) + var.getName(), 0);
        this.addCell(table, font, var.getTitle(), 0);
        this.addCell(table, font, ApiToXmlUtil.translateType(D.s((Object)var.getType())), 0);
        this.addCell(table, font, ((VariableImpl)var).isArray() ? "Y" : "", 0);
        return index;
    }

    private int setTableByMeta(PdfPTable table, int index, Font font, DynamicObject meta, int deep) {
        DynamicObjectCollection list = meta.getDynamicObjectCollection("prop_entryentity");
        int l = 0;
        for (DynamicObject metaEntry : list) {
            index = this.setTableColum(table, index, font, metaEntry, l++, deep, list.size());
            if (!ApiToXmlUtil.isEntries(metaEntry.getString("data_type"))) continue;
            DynamicObject metaEntries = JsonSampleUtil.findMetaByDataSchema(meta, metaEntry.getString("data_schema"));
            DynamicObjectCollection entryList = metaEntries.getDynamicObjectCollection("prop_entryentity");
            int line = 0;
            for (DynamicObject entry : entryList) {
                index = this.setTableColum(table, index, font, entry, line++, deep + 1, entryList.size());
            }
        }
        return index;
    }

    private int setTableColum(PdfPTable table, int index, Font font, DynamicObject entry, int line, int deep, int size) {
        this.addCell(table, font, String.valueOf(++index), 1);
        this.addCell(table, font, ApiToXmlUtil.getPrefix(deep) + ApiToXmlUtil.getTabChar(deep, line, size) + entry.getString("prop_name"), 0);
        this.addCell(table, font, entry.getString("prop_label"), 0);
        this.addCell(table, font, ApiToXmlUtil.translateType(entry.getString("data_type")), 0);
        this.addCell(table, font, null, 0);
        return index;
    }

    private void addOutput() throws DocumentException {
        boolean asyn = this.sfApi.getBoolean("asyn");
        if (asyn) {
            this.addInputAndOutputTitle(ResManager.loadKDString((String)"\u8f93\u51fa\u6d41\u7a0b\u5b9e\u4f8bid", (String)"ServiceFlowApiDocGenerator_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            PdfPTable table = this.getAsynOutputPdfPTable();
            this.pdf.add((Element)table);
        } else {
            PdfPTable table = this.getSyncOutputPdfPTable();
            this.pdf.add((Element)table);
        }
    }

    private void addQueryOutputTable() throws DocumentException {
        this.addInputAndOutputTitle(ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u8f93\u51fa\uff1a", (String)"ServiceFlowApiDocGenerator_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        PdfPTable table = this.createHeader();
        int index = 0;
        Font font = DocFileUtil.getSpecificFont(12.0f, 0);
        this.addCell(table, font, String.valueOf(++index), 1);
        this.addCell(table, font, "id", 0);
        this.addCell(table, font, ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bid", (String)"ServiceFlowApiDocGenerator_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 0);
        this.addCell(table, font, ResManager.loadKDString((String)"\u957f\u6574\u6570", (String)"ServiceFlowApiDocGenerator_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 0);
        this.addCell(table, font, "", 0);
        this.addCell(table, font, String.valueOf(++index), 1);
        this.addCell(table, font, "number", 0);
        this.addCell(table, font, ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u7f16\u7801", (String)"ServiceFlowApiDocGenerator_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 0);
        this.addCell(table, font, ResManager.loadKDString((String)"\u5b57\u7b26\u4e32", (String)"ServiceFlowApiDocGenerator_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 0);
        this.addCell(table, font, "", 0);
        this.addCell(table, font, String.valueOf(++index), 1);
        this.addCell(table, font, "state", 0);
        this.addCell(table, font, ResManager.loadKDString((String)"\u6d41\u7a0b\u72b6\u6001", (String)"ServiceFlowApiDocGenerator_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 0);
        this.addCell(table, font, ResManager.loadKDString((String)"\u5b57\u7b26\u4e32", (String)"ServiceFlowApiDocGenerator_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 0);
        this.addCell(table, font, "", 0);
        this.addCell(table, font, String.valueOf(++index), 1);
        this.addCell(table, font, "output", 0);
        this.addCell(table, font, ResManager.loadKDString((String)"\u8f93\u51fa\u53d8\u91cf", (String)"ServiceFlowApiDocGenerator_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 0);
        this.addCell(table, font, ResManager.loadKDString((String)"\u8f93\u51fa\u7ed3\u6784", (String)"ServiceFlowApiDocGenerator_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 0);
        this.addCell(table, font, "", 0);
        this.setOutputVariablesTable(table, index, font);
        this.pdf.add((Element)table);
    }

    private void addQueryInputTable() throws DocumentException {
        this.addInputAndOutputTitle(ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u8f93\u5165\uff1a", (String)"ServiceFlowApiDocGenerator_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        PdfPTable table = this.createHeader();
        Font font = DocFileUtil.getSpecificFont(12.0f, 0);
        this.addCell(table, font, String.valueOf(1), 1);
        this.addCell(table, font, "id", 0);
        this.addCell(table, font, ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bid", (String)"ServiceFlowApiDocGenerator_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 0);
        this.addCell(table, font, ResManager.loadKDString((String)"\u957f\u6574\u6570", (String)"ServiceFlowApiDocGenerator_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 0);
        this.addCell(table, font, "", 0);
        this.addCell(table, font, String.valueOf(2), 1);
        this.addCell(table, font, "limit", 0);
        this.addCell(table, font, ResManager.loadKDString((String)"\u67e5\u8be2\u65e5\u5fd7\u884c\u6570", (String)"ServiceFlowApiDocGenerator_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 0);
        this.addCell(table, font, ResManager.loadKDString((String)"\u6574\u6570", (String)"ServiceFlowApiDocGenerator_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 0);
        this.addCell(table, font, "", 0);
        this.pdf.add((Element)table);
    }

    private PdfPTable getSyncOutputPdfPTable() throws DocumentException {
        this.addInputAndOutputTitle(ResManager.loadKDString((String)"\u8f93\u51fa\uff1a\uff08\u5907\u6ce8\uff1a\u82e5\u8f93\u51fa\u96c6\u6210\u5bf9\u8c61\uff0c\u90e8\u5206\u5c5e\u6027\u5217\u5728\u670d\u52a1\u6d41\u7a0b\u4e2d\u672a\u8d4b\u503c\u53ef\u80fd\u4e3a\u7a7a\uff09", (String)"ServiceFlowApiDocGenerator_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        PdfPTable table = this.createHeader();
        int index = 0;
        Font font = DocFileUtil.getSpecificFont(12.0f, 0);
        index = this.setIdAndOutput(table, index, font);
        this.setOutputVariablesTable(table, index, font);
        return table;
    }

    private void setOutputVariablesTable(PdfPTable table, int index, Font font) {
        long flowId = ServiceFlowParser.findReleasedFlowId(this.sfApi.getLong("service_flow_id"));
        List variables = ServiceFlowParser.getFlow(flowId).getOutputVariables();
        int line = 0;
        for (Variable var : variables) {
            index = this.setTableByVariable(table, index, font, var, line++, 1, variables.size());
            boolean isVariant = ApiToXmlUtil.isVariant(D.s((Object)var.getType()));
            if (!isVariant) continue;
            index = this.addOutputOfVariant(table, index, font, var);
        }
    }

    private int addOutputOfVariant(PdfPTable table, int index, Font font, Variable var) {
        Map varDefine = (Map)var.getAttribute("define");
        if ("isc_metadata_schema".equalsIgnoreCase(D.s(varDefine.get("category")))) {
            DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)D.s(varDefine.get("type")), (String)"isc_metadata_schema");
            return this.setTableByMeta(table, index, font, item, 2);
        }
        return index;
    }

    private PdfPTable getAsynOutputPdfPTable() throws DocumentException {
        PdfPTable table = this.createHeader();
        Font font = DocFileUtil.getSpecificFont(12.0f, 0);
        this.addCell(table, font, String.valueOf(1), 1);
        this.addCell(table, font, "id", 0);
        this.addCell(table, font, ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bid", (String)"ServiceFlowApiDocGenerator_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 0);
        this.addCell(table, font, ResManager.loadKDString((String)"\u957f\u6574\u6570", (String)"ServiceFlowApiDocGenerator_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 0);
        this.addCell(table, font, "", 0);
        return table;
    }

    private int setIdAndOutput(PdfPTable table, int index, Font font) {
        this.addCell(table, font, String.valueOf(++index), 1);
        this.addCell(table, font, "id", 0);
        this.addCell(table, font, ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bid", (String)"ServiceFlowApiDocGenerator_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 0);
        this.addCell(table, font, ResManager.loadKDString((String)"\u957f\u6574\u6570", (String)"ServiceFlowApiDocGenerator_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 0);
        this.addCell(table, font, "", 0);
        this.addCell(table, font, String.valueOf(++index), 1);
        this.addCell(table, font, "output", 0);
        this.addCell(table, font, ResManager.loadKDString((String)"\u8f93\u51fa\u53c2\u6570", (String)"ServiceFlowApiDocGenerator_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 0);
        this.addCell(table, font, ResManager.loadKDString((String)"\u8f93\u51fa\u7ed3\u6784", (String)"ServiceFlowApiDocGenerator_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 0);
        this.addCell(table, font, "", 0);
        return index;
    }

    private PdfPTable createHeader() throws DocumentException {
        PdfPTable table = new PdfPTable(5);
        table.setWidths(TABLEWIDTH);
        table.setWidthPercentage(100.0f);
        Font font = DocFileUtil.getSpecificFont(12.0f, 1);
        this.addCell(table, font, ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"ServiceFlowApiDocGenerator_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        this.addCell(table, font, ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"ServiceFlowApiDocGenerator_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        this.addCell(table, font, ResManager.loadKDString((String)"\u63cf\u8ff0", (String)"ServiceFlowApiDocGenerator_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        this.addCell(table, font, ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b", (String)"ServiceFlowApiDocGenerator_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        this.addCell(table, font, ResManager.loadKDString((String)"\u662f\u5426\u591a\u503c", (String)"ServiceFlowApiDocGenerator_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        table.setHeaderRows(1);
        return table;
    }

    private void addInputAndOutputTitle(String text) throws DocumentException {
        this.addNormalText(text);
    }

    private void addSample() throws DocumentException {
        this.addInputSample();
        this.addOutputSample();
    }

    private void addInputSample() throws DocumentException {
        long flowId = ServiceFlowParser.findReleasedFlowId(this.sfApi.getLong("service_flow_id"));
        List variables = ServiceFlowParser.getFlow(flowId).getInputVariables();
        HashMap<String, Object> input = new HashMap<String, Object>();
        this.setSampleStruct(variables, input);
        String s1 = JSON.toJSONString(input, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u6837\u4f8b\uff1a", (String)"ServiceFlowApiDocGenerator_36", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]) + "\n" + s1.replaceAll("\t", "    "));
    }

    private void setSampleStruct(List<? extends Variable> variables, Map<String, Object> input) {
        for (Variable variable : variables) {
            String defaultValue = D.s((Object)variable.getInitValue()) == null ? null : ((String[])variable.getInitValue())[0];
            ServiceFlowApiDocGenerator.setSampleStructByIsVariant(input, variable, defaultValue);
        }
    }

    private void addOutputSample() throws DocumentException {
        long flowId = ServiceFlowParser.findReleasedFlowId(this.sfApi.getLong("service_flow_id"));
        if (this.sfApi.getBoolean("asyn")) {
            this.addAsynInstIdSample();
            this.addErrorSample();
            this.addQueryInputTable();
            this.addQueryOutputTable();
            this.addAsynStateInputSample();
            this.addAsynStateOutputSample(flowId);
        } else {
            this.addSyncOutputSample(flowId);
            this.addErrorSample();
        }
    }

    private void addSyncOutputSample(long flowId) throws DocumentException {
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        Map<String, Object> m = this.getOutputMap(flowId);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("id", 1);
        map.put("output", m);
        output.put("data", map);
        IscApiUtil.setOutputByVersion(output, this.sfApi);
        String s1 = JSON.toJSONString(output, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u8f93\u51fa\u6837\u4f8b\uff1a", (String)"ServiceFlowApiDocGenerator_38", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]) + "\n" + s1.replaceAll("\t", "    "));
    }

    private void addAsynStateInputSample() throws DocumentException {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        data.put("id", "1");
        data.put("limit", "1");
        String s = JSON.toJSONString(data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6d41\u7a0b\u5b9e\u4f8b\u7ed3\u679c\u8f93\u5165\uff1a", (String)"ServiceFlowApiDocGenerator_39", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]) + "\n" + s.replaceAll("\t", "    "));
    }

    private void addAsynStateOutputSample(long flowId) throws DocumentException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("id", "1");
        result.put("number", "num1");
        result.put("state", "complete");
        Map<String, Object> output = this.getOutputMap(flowId);
        result.put("output", output);
        result.put("log", "if limit>0,the log will be displayed.");
        String s2 = JSON.toJSONString(result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6d41\u7a0b\u5b9e\u4f8b\u7ed3\u679c\u8f93\u51fa\uff1a", (String)"ServiceFlowApiDocGenerator_40", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]) + "\n" + s2.replaceAll("\t", "    "));
    }

    private void addAsynInstIdSample() throws DocumentException {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put("id", 1);
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        output.put("data", map);
        IscApiUtil.setOutputByVersion(output, this.sfApi);
        String s1 = JSON.toJSONString(output, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u8f93\u51fa\u6837\u4f8b\uff1a", (String)"ServiceFlowApiDocGenerator_38", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]) + "\n" + s1.replaceAll("\t", "    "));
    }

    private Map<String, Object> getOutputMap(long flowId) {
        List variables = ServiceFlowParser.getFlow(flowId).getOutputVariables();
        HashMap<String, Object> m = new HashMap<String, Object>(variables.size());
        this.setSampleStruct(variables, m);
        return m;
    }

    private void addErrorSample() throws DocumentException {
        LinkedHashMap<String, Object> errorOutput = new LinkedHashMap<String, Object>();
        IscApiUtil.setErrorByVersion(errorOutput, this.sfApi);
        errorOutput.put("errorCode", "500");
        errorOutput.put("message", ResManager.loadKDString((String)"\u9519\u8bef\u5806\u6808\u8be6\u60c5", (String)"ServiceFlowApiDocGenerator_27", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        errorOutput.remove("data");
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u5931\u8d25\u6837\u4f8b\uff1a", (String)"ServiceFlowApiDocGenerator_41", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]) + "\n" + JSON.toJSONString(errorOutput, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replaceAll("\t", "    "));
    }

    private void addCell(PdfPTable table, Font font, String text, int align) {
        PdfPCell cell = new PdfPCell();
        cell.setBorderWidth(0.25f);
        cell.setPadding(3.0f);
        cell.setRowspan(1);
        cell.setColspan(1);
        cell.setHorizontalAlignment(align);
        cell.setVerticalAlignment(5);
        Phrase phrase = new Phrase();
        phrase.setFont(font);
        if (text != null) {
            phrase.add((Element)new Chunk(text, font));
        }
        cell.setPhrase(phrase);
        table.addCell(cell);
    }

    private void addNormalText(String text) throws DocumentException {
        BaseFont baseFont = DocFileUtil.getBaseFont();
        Font font = new Font(baseFont, 14.0f, 0);
        this.addText(text, font, 0);
    }

    private void addText(String text, Font font, int align) throws DocumentException {
        Paragraph p = new Paragraph();
        p.setFont(font);
        if (text != null) {
            p.add((Element)new Chunk(text, font));
        }
        p.setSpacingAfter(10.0f);
        p.setAlignment(align);
        this.pdf.add((Element)p);
    }
}

