/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.trigger;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.PdfPTable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.apic.ApicError;
import kd.isc.iscb.platform.core.connector.apic.doc.ApiInfo;
import kd.isc.iscb.platform.core.connector.apic.doc.DocFileUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ApiToXmlPropStruct;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ExportTriggerApiToXml;
import kd.isc.iscb.platform.core.connector.apic.doc.trigger.AbstractTriggerDocGenerator;

public class TriggerExecuteApiDocGenerator
extends AbstractTriggerDocGenerator {
    private static final String PARAMS_ENTRYENTITY = "params_entryentity";
    private static final float[] WIDTHS = new float[]{8.0f, 25.0f, 67.0f};

    public TriggerExecuteApiDocGenerator(Document pdf, DynamicObject triggerApi, ApiInfo apiInfo) {
        super(pdf, triggerApi, apiInfo);
    }

    @Override
    public Map<String, ApiToXmlPropStruct> setApiStruct(DynamicObjectCollection puts, boolean isInput, List<DynamicObject> supplier) {
        HashMap<String, ApiToXmlPropStruct> apiStruct = new HashMap<String, ApiToXmlPropStruct>(puts.size());
        ExportTriggerApiToXml.setExecuteInputApiStruct(puts, apiStruct, supplier);
        return apiStruct;
    }

    @Override
    public void generatePdf() {
        try {
            this.addBasic();
            this.addInput();
            this.addOutput();
            this.addSample();
        }
        catch (DocumentException e) {
            throw ApicError.PDF_WRITER_ERROR.wrap((Throwable)e);
        }
    }

    private void addSample() throws DocumentException {
        this.addParamInputSample();
        this.addTargetExecutionOutputSample();
        this.addErrorSample();
    }

    @Override
    protected void addParamInputSample() throws DocumentException {
        DynamicObjectCollection params = this.trigger.getDynamicObjectCollection(PARAMS_ENTRYENTITY);
        if (params.isEmpty()) {
            this.addNormalText(ResManager.loadKDString((String)"\u8f93\u5165\u6837\u4f8b\uff1a{", (String)"TriggerExecuteApiDocGenerator_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"}", (String)"TriggerExecuteApiDocGenerator_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        } else {
            LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
            for (DynamicObject item : params) {
                String name = item.getString("params_name");
                map.put(name, 1);
            }
            String s = JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
            this.addNormalText(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u6837\u4f8b\uff1a", (String)"TriggerExecuteApiDocGenerator_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]) + "\n" + s.replaceAll("\t", "    "));
        }
    }

    private void addInput() throws DocumentException {
        DynamicObjectCollection params = this.schema.getDynamicObjectCollection("param_entries");
        this.setTable(params, "params_name", true);
    }

    private void addOutput() throws DocumentException {
        this.addInputAndOutputTitle(ResManager.loadKDString((String)"\u8f93\u51fa\uff1a", (String)"TriggerExecuteApiDocGenerator_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        PdfPTable table = this.createHeader(this.pdf);
        int index = 0;
        Font font = DocFileUtil.getSpecificFont(12.0f, 0);
        TriggerExecuteApiDocGenerator.addCell(table, font, String.valueOf(++index), 1);
        TriggerExecuteApiDocGenerator.addCell(table, font, "data", 1);
        TriggerExecuteApiDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u4efb\u52a1ID", (String)"TriggerExecuteApiDocGenerator_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        this.pdf.add((Element)table);
    }

    private PdfPTable createHeader(Document pdf) throws DocumentException {
        PdfPTable table = new PdfPTable(3);
        table.setWidths(WIDTHS);
        table.setWidthPercentage(100.0f);
        Font font = DocFileUtil.getSpecificFont(12.0f, 1);
        TriggerExecuteApiDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"TriggerExecuteApiDocGenerator_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        TriggerExecuteApiDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"TriggerExecuteApiDocGenerator_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        TriggerExecuteApiDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u63cf\u8ff0", (String)"TriggerExecuteApiDocGenerator_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        table.setHeaderRows(1);
        return table;
    }
}

