/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.vc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.util.LinkedHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.api.openapi.v2.IscApiUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.ApiInfo;
import kd.isc.iscb.platform.core.connector.apic.doc.DocFileUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.PdfGenerator;

public abstract class AbstractVCDocGenerator
implements PdfGenerator {
    private static final String SUCCESS = "success";
    protected Document pdf;
    protected DynamicObject vcApi;
    protected DynamicObject vc;
    private ApiInfo apiInfo;

    public AbstractVCDocGenerator(Document pdf, DynamicObject vcApi, ApiInfo apiInfo) {
        this.pdf = pdf;
        this.vcApi = vcApi;
        this.apiInfo = apiInfo;
        this.vc = BusinessDataServiceHelper.loadSingle((Object)vcApi.get("value_conver_rule.id"), (String)"isc_value_conver_rule");
    }

    protected void addBasic() throws DocumentException {
        this.addTitle();
        this.addURL();
        this.addMethod();
        this.addContentType();
    }

    protected void addTitle() throws DocumentException {
        BaseFont baseFont = DocFileUtil.getBaseFont();
        Font font = new Font(baseFont, 16.0f, 0);
        this.addText(this.vcApi.getString("name"), font, 1);
    }

    private void addContentType() throws DocumentException {
        this.addNormalText(ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u90e8\uff1a", (String)"AbstractVCDocGenerator_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.pdf.add(DocFileUtil.getRequestHeaderTable(12.0f, 12.0f));
        this.addNormalText(ResManager.loadKDString((String)"\u83b7\u53d6token\u8be6\u89c1\uff1ahttps://dev.kingdee.com/index/docsNew/6668c5c0-b547-4f55-8f74-cc6ea2f5c65c", (String)"CommonApiDocBuilder_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private void addMethod() throws DocumentException {
        this.addNormalText(this.apiInfo.getMethod());
    }

    private void addURL() throws DocumentException {
        String url = this.apiInfo.getNewUrl(this.vcApi);
        if (this.vcApi.getBoolean("auth_required")) {
            url = url + "?caller={{caller}}";
        }
        this.addNormalText(url);
    }

    protected void addNormalText(String text) throws DocumentException {
        BaseFont baseFont = DocFileUtil.getBaseFont();
        Font font = new Font(baseFont, 14.0f, 0);
        this.addText(text, font, 0);
    }

    protected void addText(String text, Font font, int align) throws DocumentException {
        Paragraph p = new Paragraph();
        p.setFont(font);
        if (text != null) {
            p.add((Element)new Chunk(text, font));
        }
        p.setSpacingAfter(10.0f);
        p.setAlignment(align);
        this.pdf.add((Element)p);
    }

    protected void addInputAndOutputTitle(String text) throws DocumentException {
        this.addNormalText(text);
    }

    protected static void addCell(PdfPTable table, Font font, String text, int align) {
        PdfPCell cell = new PdfPCell();
        cell.setBorderWidth(0.25f);
        cell.setPadding(3.0f);
        cell.setRowspan(1);
        cell.setColspan(1);
        cell.setHorizontalAlignment(align);
        cell.setVerticalAlignment(5);
        Phrase phrase = new Phrase();
        phrase.setFont(font);
        if (text != null) {
            phrase.add((Element)new Chunk(text, font));
        }
        cell.setPhrase(phrase);
        table.addCell(cell);
    }

    protected void addErrorSample() throws DocumentException {
        LinkedHashMap<String, Object> errorOutput = new LinkedHashMap<String, Object>();
        IscApiUtil.setErrorByVersion(errorOutput, this.vcApi);
        errorOutput.put("errorCode", "500");
        errorOutput.put("message", ResManager.loadKDString((String)"\u9519\u8bef\u5806\u6808\u8be6\u60c5", (String)"AbstractVCDocGenerator_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        errorOutput.remove("data");
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u5931\u8d25\u6837\u4f8b\uff1a", (String)"AbstractVCDocGenerator_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]) + "\n" + JSON.toJSONString(errorOutput, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replaceAll("\t", "    "));
    }

    protected void addInputSample() throws DocumentException {
        LinkedHashMap<String, Object> input = new LinkedHashMap<String, Object>();
        input.put("value", this.vcApi.get("value"));
        String s1 = JSON.toJSONString(input, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u6837\u4f8b\uff1a", (String)"AbstractVCDocGenerator_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]) + "\n" + s1.replaceAll("\t", "    "));
    }

    protected void addOutputSample() throws DocumentException {
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        output.put("data", 1);
        IscApiUtil.setOutputByVersion(output, this.vcApi);
        String s2 = JSON.toJSONString(output, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
        this.addNormalText(String.format(ResManager.loadKDString((String)"\u8f93\u51fa\u6837\u4f8b\uff1a", (String)"AbstractVCDocGenerator_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]) + "\n" + s2.replaceAll("\t", "    "));
    }
}

