/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.apic.doc.vc;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.PdfPTable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.apic.ApicError;
import kd.isc.iscb.platform.core.connector.apic.doc.ApiInfo;
import kd.isc.iscb.platform.core.connector.apic.doc.DocFileUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.vc.AbstractVCDocGenerator;
import kd.isc.iscb.util.dt.D;

public class VCExecuteApiDocGenerator
extends AbstractVCDocGenerator {
    private static final float[] WIDTHS = new float[]{8.0f, 25.0f, 67.0f};

    public VCExecuteApiDocGenerator(Document pdf, DynamicObject vcApi, ApiInfo apiInfo) {
        super(pdf, vcApi, apiInfo);
    }

    @Override
    public void generatePdf() {
        try {
            this.addBasic();
            this.addInput();
            this.addOutput();
            this.addSample();
        }
        catch (DocumentException e) {
            throw ApicError.PDF_WRITER_ERROR.wrap((Throwable)e);
        }
    }

    private void addSample() throws DocumentException {
        this.addInputSample();
        this.addOutputSample();
        this.addErrorSample();
    }

    private void addInput() throws DocumentException {
        this.addInputAndOutputTitle(ResManager.loadKDString((String)"\u8f93\u5165\uff1a", (String)"VCExecuteApiDocGenerator_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        PdfPTable table = this.createHeader(this.pdf);
        int index = 1;
        Font font = DocFileUtil.getSpecificFont(12.0f, 0);
        VCExecuteApiDocGenerator.addCell(table, font, D.s((Object)index), 1);
        VCExecuteApiDocGenerator.addCell(table, font, "value", 1);
        VCExecuteApiDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u6e90\u5355\u503c", (String)"VCExecuteApiDocGenerator_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        this.pdf.add((Element)table);
    }

    private void addOutput() throws DocumentException {
        this.addInputAndOutputTitle(ResManager.loadKDString((String)"\u8f93\u51fa\uff1a", (String)"VCExecuteApiDocGenerator_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        PdfPTable table = this.createHeader(this.pdf);
        int index = 1;
        Font font = DocFileUtil.getSpecificFont(12.0f, 0);
        VCExecuteApiDocGenerator.addCell(table, font, D.s((Object)index), 1);
        VCExecuteApiDocGenerator.addCell(table, font, "data", 1);
        VCExecuteApiDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u8f6c\u6362\u7ed3\u679c", (String)"VCExecuteApiDocGenerator_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        this.pdf.add((Element)table);
    }

    private PdfPTable createHeader(Document pdf) throws DocumentException {
        PdfPTable table = new PdfPTable(3);
        table.setWidths(WIDTHS);
        table.setWidthPercentage(100.0f);
        Font font = DocFileUtil.getSpecificFont(12.0f, 1);
        VCExecuteApiDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"VCExecuteApiDocGenerator_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        VCExecuteApiDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"VCExecuteApiDocGenerator_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        VCExecuteApiDocGenerator.addCell(table, font, ResManager.loadKDString((String)"\u63cf\u8ff0", (String)"VCExecuteApiDocGenerator_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), 1);
        table.setHeaderRows(1);
        return table;
    }
}

