/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.curdb;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;

public final class CurrentDBConnectionWrapper
implements Connection {
    private Connection impl;

    public CurrentDBConnectionWrapper(Connection impl) {
        this.impl = impl;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.impl.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.isReadOnlyCurrentDB(sql);
        return this.impl.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.isReadOnlyCurrentDB(sql);
        return this.impl.prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.isReadOnlyCurrentDB(sql);
        return this.impl.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.impl.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.impl.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.impl.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.impl.rollback();
    }

    @Override
    public void close() {
        ConnectorUtil.close(this.impl);
        this.impl = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.impl.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.impl.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.impl.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.impl.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new UnsupportedOperationException("Unsupported - catalog");
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.impl.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.impl.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.impl.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.impl.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.impl.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.impl.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.isReadOnlyCurrentDB(sql);
        return this.impl.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.isReadOnlyCurrentDB(sql);
        return this.impl.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.impl.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.impl.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.impl.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.impl.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.impl.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.impl.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.impl.rollback();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.impl.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.impl.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.isReadOnlyCurrentDB(sql);
        return this.impl.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.isReadOnlyCurrentDB(sql);
        return this.impl.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.isReadOnlyCurrentDB(sql);
        return this.impl.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.isReadOnlyCurrentDB(sql);
        return this.impl.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.isReadOnlyCurrentDB(sql);
        return this.impl.prepareStatement(sql, columnNames);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.impl.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.impl.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.impl.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.impl.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.impl.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.impl.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.impl.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.impl.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.impl.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.impl.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.impl.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.impl.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.impl.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.impl.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.impl.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.impl.getNetworkTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.impl.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.impl.isWrapperFor(iface);
    }

    private void isReadOnlyCurrentDB(String sql) {
        String six = sql.trim().toUpperCase();
        if (!six.startsWith("SELECT")) {
            throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u8fde\u63a5\u7c7b\u578b\u4e3a\u3010\u5f53\u524d\u6570\u636e\u5e93\u3011\uff0c\u53ea\u5141\u8bb8\u8bfb\u53d6\uff0c\u4e0d\u5141\u8bb8\u5199\u5165\u3002", (String)"CurrentDBConnectionWrapper_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }
}

