/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.eas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.connector.ConnectorVersion;
import kd.isc.iscb.platform.core.connector.eas.EasProxyContext;
import kd.isc.iscb.util.connector.PermissionMode;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Base64;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.encoding.EncryptUtil;
import org.bouncycastle.crypto.digests.SM3Digest;

public class Util {
    private static final String PARAM_COMMAND = "command";
    private static final String FIELD_USER = "user";
    private static final String FIELD_SECRET = "password";
    private static final String FIELD_DATA_CENTER = "data_center";
    private static final String FIELD_SERVER_PORT = "server_port";
    private static final String FIELD_SERVER_IP = "server_ip";

    public static String getEasAccessKey(DynamicObject cfg) {
        long proxy_user_id = cfg.getLong("ierp_proxy_user_id");
        if (proxy_user_id <= 0L) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5fc5\u987b\u6307\u5b9a\u201c\u82cd\u7a79\u4ee3\u7406\u7528\u6237\u201d\u624d\u80fd\u751f\u6210\u8bbf\u95ee\u952e\uff01", (String)"Util_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)proxy_user_id, (String)"bos_user");
        Map<String, String> info = ConnectorUtil.getThirdLoginInfo(cfg, user);
        info.put("key", Util.generateEasKey(cfg, user));
        return Cipher.encrypt((String)Json.toString(info));
    }

    public static void save(DynamicObject obj) {
        ConnectorUtil.save(obj);
    }

    static String generateEasKey(DynamicObject cfg, DynamicObject user) {
        StringBuilder sb = new StringBuilder();
        sb.append(cfg.get(FIELD_SERVER_IP)).append('/');
        sb.append(cfg.get(FIELD_SERVER_PORT)).append('/');
        sb.append(cfg.get(FIELD_USER)).append('/');
        sb.append(cfg.get(FIELD_DATA_CENTER)).append('/');
        sb.append(cfg.getPkValue()).append('/');
        RequestContext ctx = RequestContext.get();
        sb.append(ctx.getTenantId()).append('/');
        sb.append(ctx.getAccountId()).append('/');
        if (user != null) {
            sb.append('/').append(user.getPkValue());
            sb.append('/').append(user.get(FIELD_SECRET));
        }
        return Hash.md5((String)sb.toString()).toUpperCase();
    }

    public static String generateURL(DynamicObject cfg) {
        StringBuilder url = Util.generateURI(cfg);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("u", cfg.get(FIELD_USER));
        map.put("p", cfg.get(FIELD_SECRET));
        map.put("d", cfg.get(FIELD_DATA_CENTER));
        map.put("t", System.currentTimeMillis());
        map.put("r", UUID.randomUUID().toString());
        String json = Json.toString(map);
        DynamicObject user = Util.getProxyUser(cfg);
        String key = Util.generateEasKey(cfg, user);
        url.append(Cipher.encrypt((String)json, (String)key));
        return url.toString();
    }

    static DynamicObject getProxyUser(DynamicObject cfg) {
        DynamicObject user = null;
        long proxy_user_id = cfg.getLong("ierp_proxy_user_id");
        if (proxy_user_id > 0L) {
            user = BusinessDataServiceHelper.loadSingleFromCache((Object)proxy_user_id, (String)"bos_user");
        }
        return user;
    }

    public static StringBuilder generateURI(DynamicObject cfg) {
        StringBuilder url = new StringBuilder();
        String ip = D.s((Object)cfg.get(FIELD_SERVER_IP));
        if (ip == null) {
            throw new IscBizException(ResManager.loadKDString((String)"EAS\u670d\u52a1\u5668\u7684\u201cIP\u6216\u57df\u540d\u201d\u6ca1\u6709\u586b\u5199\u3002", (String)"Util_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        String dc = D.s((Object)cfg.get(FIELD_DATA_CENTER));
        if (dc == null) {
            throw new IscBizException(ResManager.loadKDString((String)"EAS\u670d\u52a1\u5668\u7684\u201c\u6570\u636e\u4e2d\u5fc3\u201d\u6ca1\u6709\u586b\u5199\u3002", (String)"Util_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        String protocal = Util.getHttpProtocal(cfg);
        url.append(protocal).append("://").append(ip);
        int port = D.i((Object)cfg.get(FIELD_SERVER_PORT));
        url.append(':').append(port);
        String serviceURI = Util.getServiceURI(cfg);
        url.append(serviceURI);
        double version = ConnectorVersion.get(Util.generateVersionURL(cfg));
        if (version > 7.0) {
            url.append(ConnectorUtil.getIscHub(cfg)).append("_._");
        }
        url.append(dc).append('?');
        return url;
    }

    public static String generateVersionURL(DynamicObject cfg) {
        StringBuilder url = new StringBuilder();
        String protocal = Util.getHttpProtocal(cfg);
        url.append(protocal).append("://").append(cfg.get(FIELD_SERVER_IP));
        url.append(':').append(cfg.get(FIELD_SERVER_PORT));
        String serviceURI = Util.getServiceURI(cfg);
        url.append(serviceURI).append("/version");
        return url.toString();
    }

    private static String getHttpProtocal(DynamicObject cfg) {
        String protocal = D.s((Object)cfg.getString("http_protocal"));
        if (protocal == null) {
            protocal = "http";
        }
        return protocal;
    }

    private static String getServiceURI(DynamicObject cfg) {
        String serviceURI = D.s((Object)cfg.getString("eas_service"));
        if (serviceURI == null) {
            serviceURI = "/isc/proxy/";
        }
        if (!serviceURI.endsWith("/")) {
            serviceURI = serviceURI + "/";
        }
        return serviceURI;
    }

    public static void deploy(DynamicObject cfg, String ierpServerURL, String password, PermissionMode mode) {
        String accessKey = Util.getEasAccessKey(cfg);
        String key = Util.generateKey(password, Util.getAlgorithm(cfg));
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("h", Hash.md5((String)(ierpServerURL + accessKey)));
        m.put("t", System.currentTimeMillis());
        String q = Cipher.encrypt((String)Json.toString(m), (String)key);
        String url = Util.generateURI(cfg).append("deploy.").append(q).toString();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PARAM_COMMAND, "remote_deploy");
        param.put("ierp_server_url", ierpServerURL);
        param.put("access_key", Cipher.encrypt((String)accessKey, (String)key));
        param.put("permission_mode", mode.toString());
        NetUtil.asyncHttpInvoke((String)url, param);
    }

    public static List<String> getDataCenterList(String protocal, String ip, String port) {
        String s;
        if (StringUtil.isEmpty((String)protocal) || StringUtil.isEmpty((String)ip) || StringUtil.isEmpty((String)port)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u534f\u8bae\u3001IP\u3001\u7aef\u53e3\uff0c\u624d\u80fd\u9009\u62e9\u6570\u636e\u4e2d\u5fc3", (String)"Util_42", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        String url = protocal + "://" + ip + ":" + port + "/isc/queryEasInfo/getDataCenterList";
        try {
            s = NetUtil.httpRead((String)url, (String)"UTF-8");
        }
        catch (Exception e) {
            throw new IscBizException(StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
        }
        return (List)JSON.parseObject((String)s, (Type)TypeReference.LIST_STRING, (Feature[])new Feature[0]);
    }

    public static StringBuilder getConnectorInfo(DynamicObject dbLink) {
        double version = Util.getVersionFromRemote(dbLink);
        String ip = dbLink.getString(FIELD_SERVER_IP);
        String port = dbLink.getString(FIELD_SERVER_PORT);
        String protocal = dbLink.getString("http_protocal");
        StringBuilder res = new StringBuilder();
        if (StringUtil.isEmpty((String)protocal) || StringUtil.isEmpty((String)ip) || StringUtil.isEmpty((String)port)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u534f\u8bae\uff0cip\uff0c\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a", (String)"Util_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (version < 6.0) {
            res.append(String.format(ResManager.loadKDString((String)"\u5f53\u524dEAS sp\u5305\u7248\u672c\u4e3a\uff1a%1$s\uff0c\u4e0d\u652f\u6301\u67e5\u770bsp\u5305\u6784\u5efa\u65f6\u95f4\uff0c\u8bf7\u66f4\u65b0sp\u5305\u3002", (String)"Util_38", (String)"isc-iscb-platform-core", (Object[])new Object[0]), version));
        } else {
            String url = protocal + "://" + ip + ":" + port + "/isc/proxy/connector_info";
            try {
                res.append(NetUtil.httpRead((String)url, (String)"UTF-8"));
            }
            catch (Exception e) {
                throw new IscBizException(ResManager.loadKDString((String)"\u67e5\u770bEAS sp\u5305\u6784\u5efa\u65f6\u95f4\u65f6\u53d1\u751f\u5f02\u5e38", (String)"Util_39", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (Throwable)e);
            }
        }
        res.append('\n').append(ResManager.loadKDString((String)"EAS sp\u5305\u90e8\u7f72\u8def\u5f84\uff1aeas\\server\\lib\\sp \uff08isc-iscb-connector-eas.jar\u3001isc-iscb-util.jar\uff09", (String)"Util_41", (String)"isc-iscb-platform-core", (Object[])new Object[0])).append('\n').append(ResManager.loadKDString((String)"\u6700\u65b0sp\u5305\u4e0b\u8f7d\u8def\u5f84\uff1ahttps://developer.kingdee.com/article/146134", (String)"Util_40", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        return res;
    }

    public static void pushPermission(DynamicObject cfg, Map<Object, Object> permission, String adminPassword) {
        String key = Util.generateKey(adminPassword, Util.getAlgorithm(cfg));
        String data = Cipher.encrypt((String)Json.toString(permission), (String)key);
        String url = new EasProxyContext(cfg).getRemoteURL();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PARAM_COMMAND, "push_permission");
        param.put("data", data);
        NetUtil.asyncHttpInvoke((String)url, param);
    }

    public static List<String> getDataCenters(String url) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PARAM_COMMAND, "get_datacenters");
        return (List)NetUtil.asyncHttpInvoke((String)url, param);
    }

    public static String generateKey(String password) {
        return Util.generateKey(password, "MD5");
    }

    public static String generateKey(String password, String algorithm) {
        if (password == null || password.length() == 0) {
            return Cipher.DEFAULT_KEY;
        }
        if (StringUtil.isEmpty((String)algorithm)) {
            algorithm = "MD5";
        }
        return Util.encryptStr("00000000-0000-0000-0000-00000000000013B7DE7F" + password, algorithm);
    }

    public static String encryptStr(String sourceStr, String algorithm) {
        if ("MD5".equals(algorithm) || "SHA-256".equals(algorithm)) {
            return EncryptUtil.encrypt((String)sourceStr, (String)algorithm);
        }
        if ("SM3".equals(algorithm)) {
            return Util.encrytStrBySm3(sourceStr);
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u52a0\u5bc6\u7b97\u6cd5\u7c7b\u578b\uff1a%s", (String)"Util_24", (String)"isc-iscb-platform-core", (Object[])new Object[0]), algorithm));
    }

    private static String encrytStrBySm3(String str) {
        SM3Digest digest = new SM3Digest();
        byte[] resBuf = new byte[digest.getDigestSize()];
        byte[] srcBytes = str.getBytes(D.UTF_8);
        digest.update(srcBytes, 0, srcBytes.length);
        digest.doFinal(resBuf, 0);
        return new String(Base64.encode((byte[])resBuf), D.UTF_8);
    }

    public static String getAlgorithm(DynamicObject cfg) {
        double version = Util.getVersionFromRemote(cfg);
        if (version >= 4.0) {
            String s = NetUtil.httpRead((String)Util.getQueryPwdAlgorithmUrl(cfg), (String)"UTF-8");
            try {
                return Cipher.decrypt((String)s);
            }
            catch (Throwable e) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2EAS\u5bc6\u7801\u52a0\u5bc6\u7b97\u6cd5\u51fa\u9519\uff0cEAS\u8fd4\u56de\u7684\u539f\u59cb\u62a5\u6587\u4e3a\uff1a%s", (String)"Util_36", (String)"isc-iscb-platform-core", (Object[])new Object[0]), s), e);
            }
        }
        return "MD5";
    }

    private static double getVersionFromRemote(DynamicObject cfg) {
        String getVersionUrl = Util.generateVersionURL(cfg);
        ConnectorVersion.remove(getVersionUrl);
        return ConnectorVersion.get(getVersionUrl);
    }

    private static String getQueryPwdAlgorithmUrl(DynamicObject cfg) {
        StringBuilder url = new StringBuilder();
        String protocal = Util.getHttpProtocal(cfg);
        url.append(protocal).append("://").append(cfg.get(FIELD_SERVER_IP));
        url.append(':').append(cfg.get(FIELD_SERVER_PORT));
        url.append("/isc/queryEasInfo/getPwdEncrytAlgorithm?dc=").append(cfg.getString(FIELD_DATA_CENTER));
        return url.toString();
    }

    public static void checkEntityName(String entityName) {
        if (entityName != null && !entityName.contains(".")) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"EAS\u5b9e\u4f53\u5168\u540d\u5e94\u5305\u542b\u5c0f\u6570\u70b9\u3010.\u3011\uff0c\u800c\u5f53\u524d\u5168\u540d\u4e3a%s\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u975eEAS\u7c7b\u578b\u7684\u6570\u636e\u6e90\u8bef\u914d\u7f6e\u4e86EAS\u8fde\u63a5\uff0c\u6700\u5e38\u89c1\u7684\u662f\u5c06\u201c\u9884\u7f6e\u5f53\u524d\u82cd\u7a79\u201d\u6570\u636e\u6e90\u8bef\u914d\u7f6e\u4e86EAS\u8fde\u63a5\u3002", (String)"Util_25", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entityName));
        }
    }
}

