/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.connector.ftp.FtpConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ftp.FtpConnector;
import kd.isc.iscb.platform.core.connector.ftp.util.FtpMode;
import kd.isc.iscb.platform.core.connector.ftp.util.IscFtpException;
import kd.isc.iscb.platform.core.connector.ftp.util.PathInfo;
import kd.isc.iscb.platform.core.connector.sunftp.FtpConfig;
import kd.isc.iscb.platform.core.connector.sunftp.FtpFile;
import kd.isc.iscb.platform.core.connector.sunftp.FtpUtil;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.script.misc.StringUtil;
import sun.net.ftp.FtpClient;
import sun.net.ftp.FtpProtocolException;

public class FtpConnectionFactory
implements ConnectionFactory,
FtpConnector {
    @Override
    public FtpConnectionWrapper create(DynamicObject cfg) {
        return new FtpConnectionWrapper(this, cfg);
    }

    @Override
    public void test(ConnectionWrapper cn) {
        cn.ensureFluidControl();
        FtpConnectionWrapper ftpCn = (FtpConnectionWrapper)cn;
        ftpCn.getWorkingDirectory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getWorkingDirectory(DynamicObject cfg) {
        try (FtpClient client = this.createFtpClient(cfg);){
            String string = client.getWorkingDirectory();
            return string;
        }
        catch (Throwable e) {
            throw new IscFtpException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<FtpFile> list(DynamicObject cfg, String dirPath) {
        if (StringUtil.isEmpty((String)dirPath)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u76ee\u5f55\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (String)"FtpConnectionFactory_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        try (FtpClient client = this.createFtpClient(cfg);){
            List<FtpFile> list = FtpUtil.list(client, dirPath, FtpConfig.getCharset(cfg));
            return list;
        }
        catch (Throwable e) {
            throw new IscFtpException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(DynamicObject cfg, String path) {
        if (StringUtil.isEmpty((String)path)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FtpConnectionFactory_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        try (FtpClient client = this.createFtpClient(cfg);){
            FtpUtil.delete(client, path);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            throw new IscFtpException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object get(DynamicObject cfg, PathInfo pathInfo, String fileName, long restartOffset) {
        if (StringUtil.isEmpty((String)fileName)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FtpConnectionFactory_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        try (FtpClient client = this.createFtpClient(cfg);){
            long size = client.getSize(pathInfo.getDirPath() + fileName);
            long maxFileSize = FtpUtil.getMaxFileSize(D.s((Object)cfg.get("attr8")));
            if (size > maxFileSize) {
                throw new IscFtpException(String.format(ResManager.loadKDString((String)"\u6700\u5927\u652f\u6301\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f\u4e3a[%1$s \u5b57\u8282], \u5b9e\u9645\u6587\u4ef6\u5927\u5c0f\u4e3a[%2$s \u5b57\u8282]\u3002", (String)"FtpConnectionFactory_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), maxFileSize, size));
            }
            Object object = FtpUtil.readFileContent(client, pathInfo, fileName, restartOffset);
            return object;
        }
        catch (Throwable e) {
            throw new IscFtpException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean put(DynamicObject cfg, String dirPath, String fileName, InputStream fileStream, boolean isUpdate) {
        if (StringUtil.isEmpty((String)dirPath)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FtpConnectionFactory_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (StringUtil.isEmpty((String)fileName)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FtpConnectionFactory_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        try (FtpClient client = this.createFtpClient(cfg);){
            FtpUtil.createNotExistDir(client, dirPath, FtpConfig.getCharset(cfg));
            client.putFile(PathInfo.getDirPath(dirPath) + fileName, fileStream, !isUpdate);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            throw new IscFtpException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean rmdir(DynamicObject cfg, String dirPath) {
        if (StringUtil.isEmpty((String)dirPath)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u76ee\u5f55\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FtpConnectionFactory_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        try (FtpClient client = this.createFtpClient(cfg);){
            FtpUtil.rmdir(client, dirPath, FtpConfig.getCharset(cfg));
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            throw new IscFtpException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean mkdir(DynamicObject cfg, String dirPath) {
        if (StringUtil.isEmpty((String)dirPath)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u76ee\u5f55\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FtpConnectionFactory_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        try (FtpClient client = this.createFtpClient(cfg);){
            FtpUtil.mkdir(client, dirPath);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            throw new IscFtpException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists(DynamicObject cfg, String path) {
        if (StringUtil.isEmpty((String)path)) {
            throw new IscFtpException(ResManager.loadKDString((String)"\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FtpConnectionFactory_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        try (FtpClient client = this.createFtpClient(cfg);){
            boolean bl = FtpUtil.exists(client, path);
            return bl;
        }
        catch (Throwable e) {
            throw new IscFtpException(e);
        }
    }

    private FtpClient createFtpClient(DynamicObject cfg) {
        FtpConfig config = new FtpConfig(cfg);
        FtpClient client = null;
        try {
            client = FtpClient.create();
            client.setConnectTimeout(config.getConnectionTimeout());
            InetSocketAddress dest = new InetSocketAddress(config.getHost(), config.getPort());
            client.connect(dest);
            this.innerLogin(config, client);
            client.setType(config.getTransferType());
            client.enablePassiveMode(config.getMode() == FtpMode.Passive);
        }
        catch (Throwable e) {
            ConnectorUtil.close(client);
            throw new IscFtpException(e);
        }
        return client;
    }

    private void innerLogin(FtpConfig config, FtpClient client) throws IOException, FtpProtocolException {
        try {
            client.login(config.getUser(), config.getPassword().toCharArray());
        }
        catch (FtpProtocolException e) {
            if (e.getMessage() != null && e.getMessage().contains(config.getPassword())) {
                throw new IscFtpException(ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef:", (String)"FtpConnectionFactory_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e);
            }
            throw e;
        }
    }

    @Override
    public Map<String, MetaType> getMetaList(ConnectionWrapper cn) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"FTP\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u201c\u540c\u6b65\u5143\u6570\u636e\u5217\u8868\u201d\u64cd\u4f5c\u3002", (String)"FtpConnectionFactory_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public boolean hasMetaData(String metaFullname, String type, ConnectionWrapper cn) {
        throw new UnsupportedOperationException();
    }
}

